
/*****************************************************************************
 *                                    M L X                                  *
 *                 Rendering Library for Accelerated 3d Hardware             *
 *                           (C) SuSE GmbH 1997, 1998                        *
 *****************************************************************************/
/* author: simon pogarcic, sim@suse.de */

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 * to control messages from all modules
 */
#if 1
#define LOG_DEBUG_ALL
#endif



#ifndef _LOG_DEBUG_H_
#define _LOG_DEBUG_H_

#ifndef __KERNEL__
#include <stdio.h>
#endif


#ifndef LOG_DBGINFO
#define LOG_DBGINFO "<info>"
#endif

#ifndef LOG_DBGSLEEP
#define LOG_DBGSLEEP 5
#endif



#if defined(LOG_DEBUG) && defined(LOG_DEBUG_ALL)

static char LogIsOn=1;
# define LOG_ON LogIsOn = 1;
# define LOG_OFF LogIsOn = 0;

# ifdef __KERNEL__
#  include <linux/sched.h>
#  define LOG(f, a...)	if(LogIsOn) printk(LOG_DBGINFO f, ## a)
#  ifdef SLOG_DEBUG
#   define SLOG(f, a...) \
    { \
	if(LogIsOn) { printk(LOG_DBGINFO f, ## a); \
	current->timeout = jiffies + LOG_DBGSLEEP * HZ; \
	current->state = TASK_INTERRUPTIBLE; \
	schedule(); \
	current->timeout = 0; }\
    }
#  else
#   define SLOG(f, a...)
#  endif
# else
#  define LOG(f, a...) if(LogIsOn) { fprintf(stderr, "%-12s: ", LOG_DBGINFO); \
				     fprintf(stderr, f, ## a); }
# endif

#else

# define LOG_ON
# define LOG_OFF
# define LOG(f, a...)

#endif



#define TLOG(f, a...)



#ifdef __KERNEL__
# define ERR(f, a...)	printk(LOG_DBGINFO "ERR: " f, ## a)
#else
# define ERR(f, a...)	{ fprintf(stderr, "%-12s: ", LOG_DBGINFO); \
			  fprintf(stderr, "ERR: " f, ## a); }
#endif



#ifdef __KERNEL__
# define MSG(f, a...)	printk(LOG_DBGINFO f, ## a)
#else
# define MSG(f, a...)	{ fprintf(stderr, "%-12s: ", LOG_DBGINFO); \
			  fprintf(stderr, f, ## a); }
#endif



#endif
