
/*****************************************************************************
 *                                  G P M o d                                *
 *                    Generic kernel module for PCI hardware                 *
 *                           (C) SuSE GmbH 1997, 1998                        *
 *****************************************************************************/
/* Author: simon pogarcic, sim@suse.de */
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _CLIENT_GPM_H_
#define _CLIENT_GPM_H_

#include <sys/types.h>

#include "common_gpm.h"
#include "project_gpm.h"



void *		gpcli_mmap_pcidev( Tubyte, Tubyte, Tubyte );
GPMIoctlArea_t *gpcli_get_areainfo( Tint, Tuint );

void *		gpcli_mmap_memshare( Tulong, Tuint, Tint * );
void *		gpcli_mmap_memalloc( Tulong, Tuint, Tint *, Tuint * );

Tint		gpcli_install_isr( Tubyte );
Tint		gpcli_uninstall_isr( Tubyte );
Tint		gpcli_config_isr( Tubyte, Tubyte, Tuint, Tulong );

Tint		gpcli_find_cardnr( Tuint, Tubyte * );

Tint		gpcli_read_pcibase( GPMIoctlRw_t * );
Tint		gpcli_write_pcibase( GPMIoctlRw_t * );

Tint		gpcli_get_pciconfig( GPMPciParam_t * );
Tint		gpcli_set_pciconfig( GPMPciParam_t * );

Tint		gpcli_enter_app( void );
void		gpcli_exit_app( Tint, Tbool );



extern GPMCardInfo_t	GpcliCardsInfo[];
extern Tuint		GpcliCardsFound;
extern GPMCard_t *	GpcliSupportedCards;
extern pid_t		GpcliMyPid;



#endif

