/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.util;

import clover.org.apache.commons.lang.mutable.MutableLong;
import com.cenqua.clover.Logger;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class CoverageUtils {
    public static final int RLE_RUN_MARKER = -1;
    public static final int RLE_RUN_THRESHOLD = 3;

    public static void rleCompressAndWriteCoverage(DataOutputStream out, int[] coverage) throws IOException {
        int ints = 0;
        int i = 0;
        boolean inRun = false;
        int runCount = 0;
        int runValue = 0;
        while (i < coverage.length) {
            if (!inRun) {
                int value;
                boolean startRun = true;
                runValue = coverage[i];
                for (int j = 1; j < 3; ++j) {
                    if (i + j < coverage.length && runValue == coverage[i + j]) continue;
                    startRun = false;
                    break;
                }
                if (startRun) {
                    runCount = 3;
                    inRun = true;
                    i += runCount;
                    continue;
                }
                out.writeInt((value = coverage[i++]) == -1 ? -2 : value);
                ++ints;
                continue;
            }
            if (runValue == coverage[i]) {
                ++runCount;
                ++i;
                continue;
            }
            out.writeInt(-1);
            out.writeInt(runCount);
            out.writeInt(runValue == -1 ? -2 : runValue);
            inRun = false;
            ints += 3;
        }
        if (inRun) {
            out.writeInt(-1);
            out.writeInt(runCount);
            out.writeInt(runValue == -1 ? -2 : runValue);
            ints += 3;
        }
        Logger.getInstance().debug("[wrote " + coverage.length + " elements as " + ints * 4 + " bytes (RLE)]");
    }

    public static void writeUncompressedCoverage(DataOutputStream out, int[] coverage) throws IOException {
        for (int i = 0; i < coverage.length; ++i) {
            out.writeInt(coverage[i]);
        }
        Logger.getInstance().debug("[wrote " + coverage.length + " elements as " + coverage.length * 4 + " bytes (uncompressed)]");
    }

    public static int[] readCoverageAndSumCoverage(DataInputStream in, MutableLong sum) throws IOException {
        int offset;
        int elementCount = in.readInt();
        int[] elements = new int[elementCount];
        byte[] data = new byte[elementCount * 4];
        long localSum = 0L;
        int read = 0;
        for (offset = 0; read != -1 && offset != data.length; offset += read) {
            read = in.read(data, offset, data.length - offset);
        }
        try {
            int j = 0;
            int i = 0;
            while (i < elementCount) {
                int m;
                if ((m = (data[j++] & 0xFF) << 24 | (data[j++] & 0xFF) << 16 | (data[j++] & 0xFF) << 8 | data[j++] & 0xFF) == -1) {
                    int v;
                    int c = (data[j++] & 0xFF) << 24 | (data[j++] & 0xFF) << 16 | (data[j++] & 0xFF) << 8 | data[j++] & 0xFF;
                    if ((v = (data[j++] & 0xFF) << 24 | (data[j++] & 0xFF) << 16 | (data[j++] & 0xFF) << 8 | data[j++] & 0xFF) != 0) {
                        Arrays.fill(elements, i, i + c, v);
                        localSum += (long)(c * v);
                    }
                    i += c;
                    continue;
                }
                elements[i++] = m;
                localSum += (long)m;
            }
            Logger.getInstance().debug("[read " + elementCount + " elements as " + (offset + 1) + " bytes with sum " + localSum + "]");
            sum.setValue(localSum);
            return elements;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Recording corrupt");
        }
    }
}

