/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.remote;

import com.cenqua.clover.Logger;
import com.cenqua.clover.remote.Config;
import com.cenqua.clover.remote.DistributedConfig;
import com.cenqua.clover.remote.RecorderListener;
import com.cenqua.clover.remote.RecorderService;
import com.cenqua.clover.remote.RemoteServiceProvider;
import java.lang.reflect.InvocationTargetException;

public class RemoteFactory
implements RemoteServiceProvider {
    private static final RemoteFactory INSTANCE = new RemoteFactory();

    public static RemoteFactory getInstance() {
        return INSTANCE;
    }

    private RemoteFactory() {
    }

    public RecorderService createService(Config config) {
        String className = "com.cenqua.clover.remote.CajoTcpRecorderService";
        Logger.getInstance().verbose("Creating service com.cenqua.clover.remote.CajoTcpRecorderService for config: " + config.getName());
        RecorderService service = (RecorderService)RemoteFactory.instantiate("com.cenqua.clover.remote.CajoTcpRecorderService");
        service.init(config);
        return service;
    }

    public RecorderListener createListener(Config config) {
        String className = "com.cenqua.clover.remote.CajoTcpRecorderListener";
        Logger.getInstance().verbose("Creating listener com.cenqua.clover.remote.CajoTcpRecorderListener  for config: " + config.getName());
        RecorderListener listener = (RecorderListener)RemoteFactory.instantiate("com.cenqua.clover.remote.CajoTcpRecorderListener");
        listener.init(config);
        return listener;
    }

    public Config createConfig(String serverLocation) {
        return new DistributedConfig(serverLocation);
    }

    private static Object instantiate(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return RemoteFactory.instantiate(clazz);
        }
        catch (ClassNotFoundException e) {
            Logger.getInstance().error("Could not load class: " + className, e);
            return null;
        }
    }

    private static Object instantiate(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Can not instantiate a null class.");
        }
        try {
            return clazz.getConstructor(null).newInstance(null);
        }
        catch (NoSuchMethodException e) {
            Logger.getInstance().error("Could not create: " + clazz, e);
        }
        catch (IllegalAccessException e) {
            Logger.getInstance().error("Could not create: " + clazz, e);
        }
        catch (InvocationTargetException e) {
            Logger.getInstance().error("Could not create: " + clazz, e);
        }
        catch (InstantiationException e) {
            Logger.getInstance().error("Could not create: " + clazz, e);
        }
        return null;
    }
}

