/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.remote;

import clover.gnu.cajo.invoke.Remote;
import clover.gnu.cajo.invoke.RemoteInvoke;
import clover.gnu.cajo.utils.extra.ItemProxy;
import clover.retrotranslator.edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import com.cenqua.clover.ErrorInfo;
import com.cenqua.clover.Logger;
import com.cenqua.clover.remote.Config;
import com.cenqua.clover.remote.DistributedConfig;
import com.cenqua.clover.remote.RecorderListener;
import com.cenqua.clover.remote.RpcMessage;
import com_cenqua_clover.Clover;
import java.rmi.ConnectException;
import java.util.Timer;
import java.util.TimerTask;

public class CajoTcpRecorderListener
implements RecorderListener {
    private DistributedConfig config;
    private final AtomicBoolean reconnecting = new AtomicBoolean(false);
    private final Timer reconnectionTimer = new Timer(true);

    public void init(Config tcpConfig) {
        this.config = (DistributedConfig)tcpConfig;
    }

    public void allRecordersSliceStart(String type, Integer slice, Long startTime) {
        Clover.allRecordersSliceStart(type, slice, startTime);
    }

    public void allRecordersSliceEnd(String type, String method, Integer slice, Integer i, ErrorInfo ei) {
        Clover.allRecordersSliceEnd(type, method, slice, i, ei);
    }

    public Object handleMessage(RpcMessage message) {
        return "SUCCESS";
    }

    public void cutOff(Exception x) {
        Logger.getInstance().debug("cutOff(" + x + "); from: " + this.config.getServerLocation() + ". Attempting to reconnect.");
        this.reconnect();
    }

    public void connect() {
        this.reconnect();
    }

    public void disconnect() {
        this.reconnectionTimer.cancel();
    }

    private boolean connectToServer() {
        String url = this.getConnectionUrl();
        try {
            Logger.getInstance().debug("Attempting connection to: " + url);
            Object server = Remote.getItem(url);
            Logger.getInstance().debug("Received remote item: " + server + " from: " + url);
            Logger.getInstance().debug("Invoking remote method: registerListener");
            RemoteInvoke result = (RemoteInvoke)Remote.invoke(server, "registerListener", null);
            Logger.getInstance().debug("Received result: " + result);
            ItemProxy proxy = new ItemProxy(result, this);
            Logger.getInstance().debug("Started proxy: " + proxy.getName());
            return true;
        }
        catch (ConnectException e) {
            Logger.getInstance().debug("Could not connect to server at " + url + ". " + e.getMessage(), e);
        }
        catch (Exception e) {
            Logger.getInstance().error("Error while connecting to: " + url + " : " + e, e);
        }
        return false;
    }

    public String getConnectionUrl() {
        return "//" + this.config.getServerLocation() + "/" + this.config.getName();
    }

    private void reconnect() {
        if (this.reconnecting.getAndSet(true)) {
            return;
        }
        this.reconnectionTimer.schedule((TimerTask)new ReconnectTimerTask(), 0L, (long)this.config.getRetryPeriod());
        Logger.getInstance().debug("Started timer to attempt reconnect every: " + this.config.getRetryPeriod() + " ms.");
    }

    private class ReconnectTimerTask
    extends TimerTask {
        private ReconnectTimerTask() {
        }

        public void run() {
            if (CajoTcpRecorderListener.this.connectToServer()) {
                CajoTcpRecorderListener.this.reconnecting.set(false);
                this.cancel();
            }
        }
    }
}

