/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.instr;

import cloverantlr.RecognitionException;
import cloverantlr.TokenStreamException;
import cloverantlr.TokenStreamRecognitionException;
import com.cenqua.clover.CloverException;
import com.cenqua.clover.CloverLicenseInfo;
import com.cenqua.clover.Logger;
import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.context.ContextStore;
import com.cenqua.clover.context.MethodRegexpContext;
import com.cenqua.clover.context.NamedContext;
import com.cenqua.clover.context.RegexpContext;
import com.cenqua.clover.context.StatementRegexpContext;
import com.cenqua.clover.instr.CloverToken;
import com.cenqua.clover.instr.CloverTokenStreamFilter;
import com.cenqua.clover.instr.ContextTreeNode;
import com.cenqua.clover.instr.FileStructureInfo;
import com.cenqua.clover.instr.InstrumentationConfig;
import com.cenqua.clover.instr.JavaRecognizer;
import com.cenqua.clover.instr.UnicodeJavaLexer;
import com.cenqua.clover.registry.BasePackageInfo;
import com.cenqua.clover.registry.Clover2Registry;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.FileMetrics;
import com.cenqua.clover.util.ChecksummingReader;
import com.cenqua.clover.util.FileUtils;
import com.cenqua.clover.util.Formatting;
import com.cenqua.clover.util.UnicodeDecodingReader;
import com.cenqua.clover.util.UnicodeEncodingWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Instrumenter {
    private InstrumentationConfig config;
    private Clover2Registry registry;
    private ContextTreeNode contextTreeRoot;
    private Logger log;
    private long startTS;
    private int numFiles;
    private int numClasses;
    private Set packages;
    private int numMethods;
    private int numTestMethods;
    private int loc;
    private int ncloc;

    public Instrumenter(InstrumentationConfig config) {
        this(Logger.getInstance(), config);
    }

    public Instrumenter(Logger log, InstrumentationConfig config) {
        this.log = log;
        this.config = config;
    }

    public InstrumentationConfig getConfig() {
        return this.config;
    }

    public void startInstrumentation() throws CloverException {
        try {
            Clover2Registry clover2Registry = Clover2Registry.createOrLoad(this.config.getRegistryFile(), this.config.getProjectName());
            if (clover2Registry == null) {
                throw new CloverException("Unable to create or load clover registry located at: " + this.config.getRegistryFile());
            }
            this.startInstrumentation(clover2Registry);
        }
        catch (IOException e) {
            throw new CloverException(e);
        }
    }

    public void startInstrumentation(Clover2Registry reg) throws CloverException {
        this.registry = reg;
        this.contextTreeRoot = new ContextTreeNode(reg.getContextStore().size(), new ContextSet());
        this.resetStatistics();
        this.startTS = System.currentTimeMillis();
        this.registry.setCurrentEncoding(this.config.getEncoding());
        this.registry.startInstr();
        this.log.info("Processing files at " + this.config.getSourceLevel() + " source level.");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File instrument(File srcFile, File destRoot) throws CloverException {
        File file;
        if (this.registry == null) {
            throw new IllegalStateException("Instrumenter not initialized.");
        }
        File instrTmp = null;
        InputStreamReader in = null;
        OutputStreamWriter out = null;
        try {
            instrTmp = File.createTempFile("clover", ".java");
            if (this.config.getEncoding() != null) {
                in = new InputStreamReader((InputStream)new FileInputStream(srcFile), this.config.getEncoding());
                out = new OutputStreamWriter((OutputStream)new FileOutputStream(instrTmp), this.config.getEncoding());
            } else {
                in = new FileReader(srcFile);
                out = new FileWriter(instrTmp);
            }
            FileInfo finfo = this.instrument(srcFile, in, out);
            File destDir = destRoot;
            BasePackageInfo pkg = finfo.getContainingPackage();
            if (!pkg.isDefault()) {
                destDir = new File(destRoot, pkg.getPath());
            }
            if (!destDir.isDirectory() && !destDir.mkdirs()) {
                throw new CloverException("Failed to create destination path " + destDir);
            }
            String srcFileName = srcFile.getName();
            if (srcFileName.indexOf(46) > -1) {
                srcFileName = srcFileName.substring(0, srcFile.getName().lastIndexOf(46)) + '.' + this.config.getInstrFileExtension();
            }
            File instr = new File(destDir, srcFileName);
            FileUtils.fileCopy(instrTmp, instr);
            this.log.verbose("Processed '" + srcFile + "' to '" + instr + "'");
            file = instr;
            if (instrTmp != null) {
                instrTmp.delete();
            }
        }
        catch (UnsupportedEncodingException e) {
            try {
                this.log.error(e.getMessage());
                throw new CloverException(e);
                catch (RecognitionException e2) {
                    String msg = srcFile + ":" + e2.getLine() + ":" + e2.getColumn() + ":" + e2.getMessage();
                    this.log.error(msg);
                    throw new CloverException(msg);
                }
                catch (TokenStreamRecognitionException e3) {
                    String msg = srcFile + ":" + e3.recog.getLine() + ":" + e3.recog.getColumn() + ":" + e3.getMessage();
                    this.log.error(msg);
                    throw new CloverException(msg);
                }
                catch (TokenStreamException e4) {
                    this.log.error("Error processing " + srcFile);
                    this.log.error(e4.getMessage());
                    throw new CloverException(e4);
                }
                catch (IOException e5) {
                    this.log.error("Error processing " + srcFile);
                    this.log.error(e5.getMessage());
                    throw new CloverException(e5);
                }
            }
            catch (Throwable throwable) {
                if (instrTmp != null) {
                    instrTmp.delete();
                }
                FileUtils.close(in);
                FileUtils.close(out);
                throw throwable;
            }
        }
        FileUtils.close(in);
        FileUtils.close(out);
        return file;
    }

    public FileInfo instrument(File orig, Reader in, Writer out) throws TokenStreamException, IOException, RecognitionException, CloverException {
        BufferedReader bin = new BufferedReader(in);
        BufferedWriter bout = new BufferedWriter(out);
        CloverTokenStreamFilter.guardAgainstDoubleInstrumentation(orig, bin);
        ChecksummingReader csr = new ChecksummingReader(bin);
        UnicodeDecodingReader udr = new UnicodeDecodingReader(csr);
        UnicodeJavaLexer lexer = new UnicodeJavaLexer(udr, this.config);
        CloverTokenStreamFilter filter = new CloverTokenStreamFilter(orig.getAbsolutePath(), lexer);
        FileStructureInfo fileStructureInfo = new FileStructureInfo(orig);
        JavaRecognizer parser = new JavaRecognizer(filter, this.config, fileStructureInfo, this.contextTreeRoot);
        parser.compilationUnit();
        if (!CloverLicenseInfo.isPkgAllowed(fileStructureInfo.getPackageName())) {
            throw new CloverException("Sorry, you are not licensed to instrument files in the package '" + fileStructureInfo.getPackageName() + "'.");
        }
        int linecount = lexer.getLineCount();
        if (filter.isEOLTerminated()) {
            --linecount;
        }
        int nclinecount = lexer.getNCLineCount();
        csr.close();
        udr.close();
        FileInfo fileInfo = this.registry.enterFile(fileStructureInfo.getPackageName(), orig, linecount, nclinecount, orig.lastModified(), orig.length(), csr.getChecksum());
        filter.instrument(fileStructureInfo, fileInfo, this.registry, this.config);
        this.matchContexts(fileStructureInfo, this.registry.getContextStore());
        UnicodeEncodingWriter uew = new UnicodeEncodingWriter(bout);
        filter.write(uew);
        this.registry.exitFile();
        ((Writer)uew).flush();
        ((Writer)uew).close();
        this.updateStatistics(fileInfo);
        return fileInfo;
    }

    public void endInstrumentation() throws CloverException {
        try {
            this.registry.endInstr();
            this.registry.store();
            long stopTS = System.currentTimeMillis();
            float secs = (float)(stopTS - this.startTS) / 1000.0f;
            int pkgs = this.packages.size();
            this.log.info("Clover all over. Instrumented " + this.numFiles + " file" + (this.numFiles != 1 ? "s" : "") + " (" + pkgs + " package" + (pkgs != 1 ? "s" : "") + ").");
            if (this.numTestMethods > 0) {
                this.log.info(this.numTestMethods + " test method" + (this.numTestMethods != 1 ? "s" : "") + " detected.");
            }
            this.log.info("Elapsed time = " + Formatting.format3d(secs) + " secs." + (secs > 0.0f ? " (" + Formatting.format3d((float)this.numFiles / secs) + " files/sec, " + Formatting.format3d((float)this.loc / secs) + " srclines/sec)" : ""));
        }
        catch (IOException e) {
            this.log.error("Error finalising instrumentation: ", e);
            throw new CloverException(e);
        }
    }

    private void resetStatistics() {
        this.numFiles = 0;
        this.numClasses = 0;
        this.packages = new HashSet();
        this.numMethods = 0;
        this.numTestMethods = 0;
        this.loc = 0;
        this.ncloc = 0;
    }

    private void updateStatistics(FileInfo finfo) {
        ++this.numFiles;
        FileMetrics metrics = (FileMetrics)finfo.getMetrics();
        this.numClasses += metrics.getNumClasses();
        this.packages.add(finfo.getContainingPackage().getName());
        this.numMethods += metrics.getNumMethods();
        this.numTestMethods += metrics.getNumTestMethods();
        this.loc += metrics.getLineCount();
        this.ncloc += metrics.getNcLineCount();
    }

    private void matchContexts(FileStructureInfo fileInfo, ContextStore contexts) {
        RegexpContext ctx;
        Iterator it;
        FileStructureInfo.Marker marker;
        int i;
        int numMarkers = fileInfo.getNumMethodMarkers();
        for (i = 0; i < numMarkers; ++i) {
            marker = fileInfo.getMethodMarker(i);
            it = contexts.getMethodContexts().iterator();
            while (it.hasNext()) {
                ctx = (MethodRegexpContext)it.next();
                if (!((MethodRegexpContext)ctx).matches((FileStructureInfo.MethodMarker)marker)) continue;
                this.addContextToMarker(ctx, marker);
                this.log.debug("Method context match, line " + marker.getStart().getLine() + ", id=" + ctx.getName());
            }
        }
        numMarkers = fileInfo.getNumStatementMarkers();
        for (i = 0; i < numMarkers; ++i) {
            marker = fileInfo.getStatementMarker(i);
            it = contexts.getStatementContexts().iterator();
            while (it.hasNext()) {
                ctx = (StatementRegexpContext)it.next();
                if (!((StatementRegexpContext)ctx).matches(marker)) continue;
                this.addContextToMarker(ctx, marker);
                this.log.debug("Statement context match, line " + marker.getStart().getLine() + ", id=" + ctx.getName());
            }
        }
    }

    private void addContextToMarker(NamedContext context, FileStructureInfo.Marker marker) {
        CloverToken curr;
        CloverToken end = marker.getEnd();
        for (curr = marker.getStart(); curr != null && curr != end; curr = curr.getNext()) {
            curr.addContext(context);
        }
        if (curr != null) {
            curr.addContext(context);
        }
    }

    public Clover2Registry getRegistry() {
        return this.registry;
    }
}

