/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.instr;

import cloverantlr.CharScanner;
import cloverantlr.CommonHiddenStreamToken;
import cloverantlr.Token;
import cloverantlr.TokenStreamException;
import cloverantlr.TokenStreamHiddenTokenFilter;
import com.cenqua.clover.CloverException;
import com.cenqua.clover.Contract;
import com.cenqua.clover.Logger;
import com.cenqua.clover.instr.CloverToken;
import com.cenqua.clover.instr.FileStructureInfo;
import com.cenqua.clover.instr.InstrumentationConfig;
import com.cenqua.clover.instr.InstrumentationState;
import com.cenqua.clover.registry.Clover2Registry;
import com.cenqua.clover.registry.FileInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class CloverTokenStreamFilter
extends TokenStreamHiddenTokenFilter {
    public static final String MARKER_PREFIX = "/* $$ This file has been instrumented by Clover ";
    public static final String MARKER = "/* $$ This file has been instrumented by Clover 2.5.1#20090528113005546 $$ */";
    private static final String DIRECTIVE_PREFIX = "///CLOVER:";
    private static final String DIRECTIVE_PREFIX2 = "// /CLOVER:";
    private static final String DIRECTIVE_ON = "ON";
    private static final String DIRECTIVE_OFF = "OFF";
    private static final String DIRECTIVE_FLUSH = "FLUSH";
    private static final String DIRECTIVE_CLASS = "USECLASS";
    private CloverToken last = null;
    private CloverToken first = null;
    private String filePath;
    static /* synthetic */ Class class$com$cenqua$clover$instr$CloverToken;

    public static void guardAgainstDoubleInstrumentation(File orig, BufferedReader bin) throws IOException, CloverException {
        String maybeMarker;
        Contract.check(bin.markSupported(), "Must use a markSupporting Reader when instrumenting");
        int markerLength = MARKER_PREFIX.length();
        bin.mark(markerLength);
        char[] chars = new char[markerLength];
        int charCount = bin.read(chars, 0, markerLength);
        if (charCount == markerLength && (maybeMarker = new String(chars)).equals(MARKER_PREFIX)) {
            throw new CloverException("Double instrumentation detected: " + orig.getAbsolutePath() + " appears to have already been instrumented by Clover.");
        }
        bin.reset();
    }

    public CloverTokenStreamFilter(String filePath, CharScanner input) {
        super(input);
        this.filePath = filePath;
        Class<?> clazz = class$com$cenqua$clover$instr$CloverToken;
        if (clazz == null) {
            clazz = class$com$cenqua$clover$instr$CloverToken = new CloverToken[0].getClass().getComponentType();
        }
        input.setTokenObjectClass(clazz.getName());
        this.hide(147);
        this.hide(148);
        this.hide(149);
    }

    private int countNewLines(String s) {
        int res = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (i < s.length() - 1 && s.charAt(i) == '\r' && s.charAt(i + 1) == '\n') {
                ++res;
                ++i;
                continue;
            }
            if (s.charAt(i) != '\r' && s.charAt(i) != '\n') continue;
            ++res;
        }
        return res;
    }

    private void scanForDirectives(Token tok, InstrumentationState state) {
        String text = tok.getText();
        if (text == null) {
            return;
        }
        int startDirective = text.indexOf(DIRECTIVE_PREFIX);
        int prefixLength = DIRECTIVE_PREFIX.length();
        if (startDirective == -1) {
            startDirective = text.indexOf(DIRECTIVE_PREFIX2);
            prefixLength = DIRECTIVE_PREFIX2.length();
        }
        int curLine = tok.getLine();
        while (startDirective >= 0) {
            curLine += this.countNewLines(text.substring(0, startDirective));
            String rest = text.substring(startDirective + prefixLength);
            if (rest.startsWith(DIRECTIVE_ON)) {
                Logger.getInstance().debug(this.filePath + ":" + curLine + ": switching Clover instrumentation ON as per directive");
                state.setInstrEnabled(true);
                state.setInstrContext(state.getInstrContext().clear(0));
            } else if (rest.startsWith(DIRECTIVE_OFF)) {
                Logger.getInstance().debug(this.filePath + ":" + curLine + ": switching Clover instrumentation OFF as per directive");
                state.setInstrContext(state.getInstrContext().set(0));
                state.setInstrEnabled(false);
            } else if (rest.startsWith(DIRECTIVE_FLUSH)) {
                Logger.getInstance().debug(this.filePath + ":" + curLine + ": inserting flush as per directive");
                state.setNeedsFlush(true);
            } else if (rest.startsWith(DIRECTIVE_CLASS)) {
                Logger.getInstance().debug(this.filePath + ":" + curLine + ": using static inner holder class for instrumentation var as per directive");
                state.getCfg().setClassInstrStragegy(true);
            } else {
                Logger.getInstance().warn(this.filePath + ":" + curLine + ": ignoring unknown Clover directive");
            }
            startDirective = rest.indexOf(DIRECTIVE_PREFIX);
            prefixLength = DIRECTIVE_PREFIX.length();
            if (startDirective == -1) {
                startDirective = rest.indexOf(DIRECTIVE_PREFIX2);
                prefixLength = DIRECTIVE_PREFIX2.length();
            }
            text = rest;
        }
    }

    public Token nextToken() throws TokenStreamException {
        CloverToken next = (CloverToken)super.nextToken();
        next.setFilter(this);
        if (this.last != null) {
            while (this.last.getNext() != null) {
                this.last = this.last.getNext();
            }
            next.setPrev(this.last);
            this.last.setNext(next);
        } else {
            this.first = next;
        }
        this.last = next;
        return next;
    }

    public void instrument(FileStructureInfo structure, FileInfo fileInfo, Clover2Registry registry, InstrumentationConfig cfg) {
        InstrumentationState state = new InstrumentationState(structure, cfg);
        state.setRegistry(registry);
        state.setFileInfo(fileInfo);
        this.scanHiddens(this.getInitialHiddenToken(), state);
        for (CloverToken curr = this.first; curr != null; curr = curr.getNext()) {
            if (curr.hasEmitters()) {
                curr.initEmitters(state);
            }
            this.scanHiddens(curr.getHiddenAfter(), state);
        }
    }

    public void write(Writer outWriter) throws IOException {
        PrintWriter out = new PrintWriter(outWriter);
        out.print(MARKER);
        this.dumpHiddens(out, this.getInitialHiddenToken());
        for (CloverToken curr = this.first; curr != null; curr = curr.getNext()) {
            curr.triggerPreEmitters(out);
            String str = curr.getText();
            if (str != null) {
                out.print(str);
            }
            curr.triggerPostEmitters(out);
            this.dumpHiddens(out, curr.getHiddenAfter());
        }
    }

    public boolean isEOLTerminated() {
        CloverToken beforeEOF;
        if (this.last != null && (beforeEOF = this.last.getPrev()) != null && beforeEOF.getHiddenAfter() != null) {
            CommonHiddenStreamToken curr;
            CommonHiddenStreamToken prev = curr = beforeEOF.getHiddenAfter();
            while (curr != null) {
                prev = curr;
                curr = curr.getHiddenAfter();
            }
            return prev.getText().endsWith("\n") || prev.getText().endsWith("\r");
        }
        return false;
    }

    private void dumpHiddens(PrintWriter out, CommonHiddenStreamToken tok) {
        while (tok != null) {
            out.print(tok.getText());
            tok = tok.getHiddenAfter();
        }
    }

    private void scanHiddens(CommonHiddenStreamToken tok, InstrumentationState state) {
        while (tok != null) {
            int type = tok.getType();
            if (148 == type || 149 == type) {
                this.scanForDirectives(tok, state);
            }
            tok = tok.getHiddenAfter();
        }
    }
}

