/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.instr;

import cloverantlr.CommonHiddenStreamToken;
import com.cenqua.clover.context.NamedContext;
import com.cenqua.clover.instr.CloverTokenStreamFilter;
import com.cenqua.clover.instr.Emitter;
import com.cenqua.clover.instr.InstrumentationState;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CloverToken
extends CommonHiddenStreamToken {
    private CloverToken next;
    private CloverToken prev;
    private List preEmitters;
    private List postEmitters;
    private CloverTokenStreamFilter filter;
    private boolean emittersEnabled;

    public CloverToken() {
    }

    public CloverToken(int t, String txt) {
        super(t, txt);
    }

    public CloverToken(String s) {
        super(s);
    }

    public CloverToken getNext() {
        return this.next;
    }

    public void setNext(CloverToken next) {
        this.next = next;
    }

    public CloverToken getPrev() {
        return this.prev;
    }

    public void setPrev(CloverToken prev) {
        this.prev = prev;
    }

    public boolean isEmittersEnabled() {
        return this.emittersEnabled;
    }

    public void setEmittersEnabled(boolean emittersEnabled) {
        Emitter emitter;
        Iterator emitters;
        this.emittersEnabled = emittersEnabled;
        if (this.hasPreEmitters()) {
            emitters = this.preEmitters.iterator();
            while (emitters.hasNext()) {
                emitter = (Emitter)emitters.next();
                emitter.setEnabled(emittersEnabled);
            }
        }
        if (this.hasPostEmitters()) {
            emitters = this.postEmitters.iterator();
            while (emitters.hasNext()) {
                emitter = (Emitter)emitters.next();
                emitter.setEnabled(emittersEnabled);
            }
        }
    }

    public void addContext(NamedContext context) {
        Emitter emitter;
        Iterator emitters;
        if (this.hasPreEmitters()) {
            emitters = this.preEmitters.iterator();
            while (emitters.hasNext()) {
                emitter = (Emitter)emitters.next();
                emitter.addContext(context);
            }
        }
        if (this.hasPostEmitters()) {
            emitters = this.postEmitters.iterator();
            while (emitters.hasNext()) {
                emitter = (Emitter)emitters.next();
                emitter.addContext(context);
            }
        }
    }

    public void addPreEmitter(Emitter emitter) {
        if (this.preEmitters == null) {
            this.preEmitters = new LinkedList();
        }
        this.preEmitters.add(emitter);
    }

    public boolean hasPreEmitters() {
        return this.preEmitters != null;
    }

    public void triggerPreEmitters(Writer out) throws IOException {
        if (this.hasPreEmitters()) {
            Iterator emitters = this.preEmitters.iterator();
            while (emitters.hasNext()) {
                Emitter emitter = (Emitter)emitters.next();
                emitter.emit(out);
            }
        }
    }

    public boolean hasPostEmitters() {
        return this.postEmitters != null;
    }

    public void triggerPostEmitters(Writer out) throws IOException {
        if (this.hasPostEmitters()) {
            Iterator emitters = this.postEmitters.iterator();
            while (emitters.hasNext()) {
                Emitter emitter = (Emitter)emitters.next();
                emitter.emit(out);
            }
        }
    }

    public void addPostEmitter(Emitter emitter) {
        if (this.postEmitters == null) {
            this.postEmitters = new LinkedList();
        }
        this.postEmitters.add(emitter);
    }

    public void setFilter(CloverTokenStreamFilter filter) {
        this.filter = filter;
    }

    public CloverTokenStreamFilter getFilter() {
        return this.filter;
    }

    public boolean hasEmitters() {
        return this.hasPreEmitters() || this.hasPostEmitters();
    }

    public void initEmitters(InstrumentationState state) {
        Emitter emitter;
        Iterator emitters;
        if (this.hasPreEmitters()) {
            emitters = this.preEmitters.iterator();
            while (emitters.hasNext()) {
                emitter = (Emitter)emitters.next();
                emitter.initialise(state);
            }
        }
        if (this.hasPostEmitters()) {
            emitters = this.postEmitters.iterator();
            while (emitters.hasNext()) {
                emitter = (Emitter)emitters.next();
                emitter.initialise(state);
            }
        }
    }
}

