/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.instr;

import com.cenqua.clover.instr.BooleanStrategy;
import com.cenqua.clover.instr.InstrumentationState;
import com.cenqua.clover.instr.MethodSignature;
import com.cenqua.clover.instr.Modifiers;
import com.cenqua.clover.instr.TestDetector;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AggregateTestDetector
implements TestDetector {
    private final List detectors = new ArrayList();
    private final BooleanStrategy strategy;

    public AggregateTestDetector(BooleanStrategy strategy) {
        this.strategy = strategy;
    }

    public void addDetector(TestDetector detector) {
        this.detectors.add(detector);
    }

    public boolean isEmpty() {
        return this.detectors.isEmpty();
    }

    public boolean isClassMatch(InstrumentationState state, Map tags, Modifiers mods, String pkgName, String classname, String superclass) {
        boolean[] values = new boolean[this.detectors.size()];
        for (int i = 0; i < this.detectors.size(); ++i) {
            TestDetector detector = (TestDetector)this.detectors.get(i);
            values[i] = detector.isClassMatch(state, tags, mods, pkgName, classname, superclass);
        }
        return this.strategy.process(values);
    }

    public boolean isMethodMatch(InstrumentationState state, MethodSignature sig) {
        boolean[] values = new boolean[this.detectors.size()];
        for (int i = 0; i < this.detectors.size(); ++i) {
            TestDetector detector = (TestDetector)this.detectors.get(i);
            values[i] = detector.isMethodMatch(state, sig);
        }
        return this.strategy.process(values);
    }
}

