/*
 * Decompiled with CFR 0.152.
 */
package clover.gnu.cajo.utils.extra;

import clover.gnu.cajo.invoke.Remote;
import clover.gnu.cajo.utils.extra.Scheduler;
import java.io.Serializable;
import java.util.LinkedList;

public final class Timer
implements Serializable {
    private final Scheduler sched;
    private final int index;
    private boolean running;
    private LinkedList tasks;

    public Timer(Scheduler scheduler) {
        this.sched = scheduler;
        this.index = scheduler.load(this);
    }

    public synchronized void load(Object object, long l, int n) {
        if (this.tasks == null) {
            this.tasks = new LinkedList();
        }
        this.tasks.add(new TimedTask(object, l, n));
        if (!this.running) {
            this.running = true;
            this.sched.wake(this.index);
        }
    }

    public synchronized void remove(Object object) {
        for (int i = 0; i < this.tasks.size(); ++i) {
            TimedTask timedTask = (TimedTask)this.tasks.get(i);
            if (!timedTask.task.equals(object)) continue;
            timedTask.drop();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void slice() {
        TimedTask timedTask = null;
        Timer timer = this;
        synchronized (timer) {
            long l = System.currentTimeMillis();
            for (int i = 0; i < this.tasks.size(); ++i) {
                TimedTask timedTask2 = (TimedTask)this.tasks.get(i);
                if (l < timedTask2.time) continue;
                if (timedTask2.count != 0 && --timedTask2.count == 0) {
                    timedTask2.drop();
                } else {
                    timedTask2.time += timedTask2.interval;
                }
                timedTask = timedTask2;
                break;
            }
        }
        if (timedTask != null) {
            try {
                Remote.invoke(timedTask.task, "slice", null);
            }
            catch (Exception exception) {
                Timer timer2 = this;
                synchronized (timer2) {
                    timedTask.drop();
                }
            }
        }
    }

    private final class TimedTask
    implements Serializable {
        private final Object task;
        private final long interval;
        private int count;
        private long time;

        private TimedTask(Object object, long l, int n) {
            this.task = object;
            this.interval = l;
            this.count = n;
            this.time = System.currentTimeMillis() + this.interval;
        }

        private void drop() {
            Timer.this.tasks.remove(Timer.this.tasks.indexOf(this));
            if (Timer.this.tasks.isEmpty()) {
                Timer.this.tasks = null;
                if (Timer.this.running) {
                    Timer.this.running = false;
                    Timer.this.sched.stop(Timer.this.index);
                }
            }
        }
    }
}

