/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.win32;

import com.sun.jna.FunctionMapper;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Structure;
import com.sun.jna.win32.StdCallLibrary;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class W32StdCallTest
extends TestCase {
    private TestLibrary testlib;

    public static void main(String[] argList) {
        TestRunner.run(W32StdCallTest.class);
    }

    protected void setUp() {
        this.testlib = (TestLibrary)Native.loadLibrary((String)"testlib", TestLibrary.class, (Map)new HashMap(){
            {
                this.put("function-mapper", StdCallLibrary.FUNCTION_MAPPER);
            }
        });
    }

    protected void tearDown() {
        this.testlib = null;
    }

    public void testFunctionMapper() throws Exception {
        FunctionMapper mapper = StdCallLibrary.FUNCTION_MAPPER;
        NativeLibrary lib = NativeLibrary.getInstance((String)"testlib");
        Method[] methods = new Method[]{TestLibrary.class.getMethod("returnInt32ArgumentStdCall", Integer.TYPE), TestLibrary.class.getMethod("returnStructureByValueArgumentStdCall", TestLibrary.TestStructure.ByValue.class), TestLibrary.class.getMethod("callInt32StdCallCallback", TestLibrary.Int32Callback.class, Integer.TYPE, Integer.TYPE)};
        for (int i = 0; i < methods.length; ++i) {
            String name = mapper.getFunctionName(lib, methods[i]);
            W32StdCallTest.assertTrue((String)("Function name not decorated for method " + methods[i].getName() + ": " + name), (name.indexOf("@") != -1 ? 1 : 0) != 0);
            W32StdCallTest.assertEquals((String)"Wrong name in mapped function", (String)name, (String)lib.getFunction(name, 1).getName());
        }
    }

    public void testStdCallReturnInt32Argument() {
        int MAGIC = 305419896;
        W32StdCallTest.assertEquals((String)"Expect zero return", (int)0, (int)this.testlib.returnInt32ArgumentStdCall(0));
        W32StdCallTest.assertEquals((String)"Expect magic return", (int)305419896, (int)this.testlib.returnInt32ArgumentStdCall(305419896));
    }

    public void testStdCallReturnStructureByValueArgument() {
        TestLibrary.TestStructure.ByValue s = new TestLibrary.TestStructure.ByValue();
        W32StdCallTest.assertEquals((String)"Wrong value", (Object)((Object)s), (Object)((Object)this.testlib.returnStructureByValueArgumentStdCall(s)));
    }

    public void testStdCallCallback() {
        int MAGIC = 0x11111111;
        final boolean[] called = new boolean[]{false};
        TestLibrary.Int32Callback cb = new TestLibrary.Int32Callback(){

            public int callback(int arg, int arg2) {
                called[0] = true;
                return arg + arg2;
            }
        };
        int EXPECTED = 0x33333333;
        int value = this.testlib.callInt32StdCallCallback(cb, 0x11111111, 0x22222222);
        W32StdCallTest.assertTrue((String)"stdcall callback not called", (boolean)called[0]);
        if (value == -1) {
            W32StdCallTest.fail((String)"stdcall callback did not restore the stack pointer");
        }
        W32StdCallTest.assertEquals((String)"Wrong stdcall callback value", (String)Integer.toHexString(0x33333333), (String)Integer.toHexString(value));
        value = this.testlib.callInt32StdCallCallback(cb, -1, -2);
        if (value == -1) {
            W32StdCallTest.fail((String)"stdcall callback did not restore the stack pointer");
        }
        W32StdCallTest.assertEquals((String)"Wrong stdcall callback return", (int)-3, (int)value);
    }

    public static interface TestLibrary
    extends StdCallLibrary {
        public int returnInt32ArgumentStdCall(int var1);

        public TestStructure.ByValue returnStructureByValueArgumentStdCall(TestStructure.ByValue var1);

        public int callInt32StdCallCallback(Int32Callback var1, int var2, int var3);

        public static interface Int32Callback
        extends StdCallLibrary.StdCallCallback {
            public int callback(int var1, int var2);
        }

        public static class TestStructure
        extends Structure {
            public byte c;
            public short s;
            public int i;
            public long j;
            public Inner inner;

            protected List getFieldOrder() {
                return Arrays.asList("c", "s", "i", "j", "inner");
            }

            public static class ByValue
            extends TestStructure
            implements Structure.ByValue {
            }
        }

        public static class Inner
        extends Structure {
            public double value;

            protected List getFieldOrder() {
                return Arrays.asList("value");
            }
        }
    }
}

