/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.win32;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.win32.W32APIOptions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class W32APIMapperTest
extends TestCase {
    final String MAGIC = "magic";
    UnicodeLibrary unicode;
    ASCIILibrary ascii;

    public static void main(String[] args) {
        TestRunner.run(W32APIMapperTest.class);
    }

    protected void setUp() {
        this.unicode = (UnicodeLibrary)Native.loadLibrary((String)"testlib", UnicodeLibrary.class, (Map)W32APIOptions.UNICODE_OPTIONS);
        this.ascii = (ASCIILibrary)Native.loadLibrary((String)"testlib", ASCIILibrary.class, (Map)W32APIOptions.ASCII_OPTIONS);
    }

    protected void tearDown() {
        this.unicode = null;
        this.ascii = null;
    }

    public void testInvalidHandleValue() {
        String expected = "opaque@0xffffffff";
        if (Pointer.SIZE == 8) {
            expected = expected + "ffffffff";
        }
        W32APIMapperTest.assertEquals((String)"Wrong value", (String)expected, (String)Pointer.createConstant((long)(Pointer.SIZE == 8 ? -1L : 0xFFFFFFFFL)).toString());
    }

    public void testBooleanArgumentConversion() {
        W32APIMapperTest.assertTrue((String)"Wrong boolean TRUE argument conversion (unicode)", (boolean)this.unicode.returnInt32Argument(true));
        W32APIMapperTest.assertFalse((String)"Wrong boolean FALSE argument conversion (unicode)", (boolean)this.unicode.returnInt32Argument(false));
        W32APIMapperTest.assertTrue((String)"Wrong boolean TRUE argument conversion (ASCII)", (boolean)this.ascii.returnInt32Argument(true));
        W32APIMapperTest.assertFalse((String)"Wrong boolean FALSE argument conversion (ASCII)", (boolean)this.ascii.returnInt32Argument(false));
    }

    public void testUnicodeMapping() {
        W32APIMapperTest.assertEquals((String)"Strings should correspond to wide strings", (String)"magic", (String)this.unicode.returnWStringArgument("magic"));
        String[] args = new String[]{"one", "two"};
        W32APIMapperTest.assertEquals((String)"String arrays should be converted to wchar_t*[] and back", (String)args[0], (String)this.unicode.returnWideStringArrayElement(args, 0));
    }

    public void testASCIIMapping() {
        W32APIMapperTest.assertEquals((String)"Strings should correspond to C strings", (String)"magic", (String)this.ascii.returnStringArgument("magic"));
    }

    public void testUnicodeStructureSize() {
        UnicodeLibrary.TestStructure s = new UnicodeLibrary.TestStructure();
        W32APIMapperTest.assertEquals((String)"Wrong structure size", (int)(Pointer.SIZE * 2 + 8), (int)s.size());
    }

    public void testASCIIStructureSize() {
        ASCIILibrary.TestStructure s = new ASCIILibrary.TestStructure();
        W32APIMapperTest.assertEquals((String)"Wrong structure size", (int)(Pointer.SIZE * 2 + 8), (int)s.size());
    }

    public void testUnicodeStructureWriteBoolean() {
        UnicodeLibrary.TestStructure s = new UnicodeLibrary.TestStructure();
        s.bool2 = true;
        s.write();
        W32APIMapperTest.assertEquals((String)"Wrong value written for FALSE", (int)0, (int)s.getPointer().getInt((long)(Pointer.SIZE * 2)));
        W32APIMapperTest.assertEquals((String)"Wrong value written for TRUE", (int)1, (int)s.getPointer().getInt((long)(Pointer.SIZE * 2 + 4)));
    }

    public void testASCIIStructureWriteBoolean() {
        ASCIILibrary.TestStructure s = new ASCIILibrary.TestStructure();
        s.bool2 = true;
        s.write();
        W32APIMapperTest.assertEquals((String)"Wrong value written for FALSE", (int)0, (int)s.getPointer().getInt((long)(Pointer.SIZE * 2)));
        W32APIMapperTest.assertEquals((String)"Wrong value written for TRUE", (int)1, (int)s.getPointer().getInt((long)(Pointer.SIZE * 2 + 4)));
    }

    public void testUnicodeStructureReadBoolean() {
        UnicodeLibrary.TestStructure s = new UnicodeLibrary.TestStructure();
        s.getPointer().setInt((long)(Pointer.SIZE * 2), 1);
        s.getPointer().setInt((long)(Pointer.SIZE * 2 + 4), 0);
        s.read();
        W32APIMapperTest.assertTrue((String)"Wrong value read for TRUE", (boolean)s.bool);
        W32APIMapperTest.assertFalse((String)"Wrong value read for FALSE", (boolean)s.bool2);
    }

    public void testASCIIStructureReadBoolean() {
        ASCIILibrary.TestStructure s = new ASCIILibrary.TestStructure();
        s.getPointer().setInt((long)(Pointer.SIZE * 2), 1);
        s.getPointer().setInt((long)(Pointer.SIZE * 2 + 4), 0);
        s.read();
        W32APIMapperTest.assertTrue((String)"Wrong value read for TRUE", (boolean)s.bool);
        W32APIMapperTest.assertFalse((String)"Wrong value read for FALSE", (boolean)s.bool2);
    }

    public void testUnicodeStructureWriteString() {
        UnicodeLibrary.TestStructure s = new UnicodeLibrary.TestStructure();
        s.string = null;
        s.string2 = "magic";
        s.write();
        W32APIMapperTest.assertEquals((String)"Improper null write", null, (Object)s.getPointer().getPointer(0L));
        W32APIMapperTest.assertEquals((String)"Improper string write", (String)"magic", (String)s.getPointer().getPointer((long)Pointer.SIZE).getString(0L, true));
    }

    public void testASCIIStructureWriteString() {
        ASCIILibrary.TestStructure s = new ASCIILibrary.TestStructure();
        s.string = null;
        s.string2 = "magic";
        s.write();
        W32APIMapperTest.assertEquals((String)"Improper null write", null, (Object)s.getPointer().getPointer(0L));
        W32APIMapperTest.assertEquals((String)"Improper string write", (String)"magic", (String)s.getPointer().getPointer((long)Pointer.SIZE).getString(0L, false));
    }

    public void testUnicodeStructureReadString() {
        UnicodeLibrary.TestStructure s = new UnicodeLibrary.TestStructure();
        s.string = "magic";
        s.string2 = null;
        s.write();
        s.read();
        W32APIMapperTest.assertEquals((String)"Improper string read", (String)"magic", (String)s.string);
        W32APIMapperTest.assertEquals((String)"Improper null string read", null, (String)s.string2);
    }

    public void testASCIIStructureReadString() {
        ASCIILibrary.TestStructure s = new ASCIILibrary.TestStructure();
        s.string = "magic";
        s.string2 = null;
        s.write();
        s.read();
        W32APIMapperTest.assertEquals((String)"Improper string read", (String)"magic", (String)s.string);
        W32APIMapperTest.assertEquals((String)"Improper null string read", null, (String)s.string2);
    }

    public static interface ASCIILibrary
    extends Library {
        public String returnStringArgument(String var1);

        public boolean returnInt32Argument(boolean var1);

        public static class TestStructure
        extends Structure {
            public String string;
            public String string2;
            public boolean bool;
            public boolean bool2;

            protected List getFieldOrder() {
                return Arrays.asList("string", "string2", "bool", "bool2");
            }
        }
    }

    public static interface UnicodeLibrary
    extends Library {
        public String returnWStringArgument(String var1);

        public boolean returnInt32Argument(boolean var1);

        public String returnWideStringArrayElement(String[] var1, int var2);

        public static class TestStructure
        extends Structure {
            public String string;
            public String string2;
            public boolean bool;
            public boolean bool2;

            protected List getFieldOrder() {
                return Arrays.asList("string", "string2", "bool", "bool2");
            }
        }
    }
}

