/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.FromNativeContext;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.NativeMapped;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.WString;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class ReturnTypesTest
extends TestCase {
    private static final double DOUBLE_MAGIC = -118.625;
    private static final float FLOAT_MAGIC = -118.625f;
    TestLibrary lib;
    static final String MAGIC = "magic";

    protected void setUp() {
        this.lib = (TestLibrary)Native.loadLibrary((String)"testlib", TestLibrary.class);
    }

    protected void tearDown() {
        this.lib = null;
    }

    public void testReturnObject() throws Exception {
        HashMap options = new HashMap(){
            {
                this.put("allow-objects", Boolean.TRUE);
            }
        };
        this.lib = (TestLibrary)Native.loadLibrary((String)"testlib", TestLibrary.class, (Map)options);
        ReturnTypesTest.assertNull((String)"null value not returned", (Object)this.lib.returnObjectArgument(null));
        Object VALUE = new Object(){

            public String toString() {
                return ReturnTypesTest.this.getName();
            }
        };
        ReturnTypesTest.assertEquals((String)"Wrong object returned", (Object)VALUE, (Object)this.lib.returnObjectArgument(VALUE));
    }

    public void testReturnObjectUnsupported() throws Exception {
        try {
            this.lib.returnObjectArgument(new TestLibrary.TestObject());
            ReturnTypesTest.fail((String)"Java Object return is not supported, should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            ReturnTypesTest.assertTrue((String)("Exception should include return object type: " + e), (e.getMessage().indexOf(TestLibrary.TestObject.class.getName()) != -1 ? 1 : 0) != 0);
        }
        catch (Throwable e) {
            ReturnTypesTest.fail((String)("Method declared with Java Object return should throw IllegalArgumentException, not " + e));
        }
    }

    public void testInvokeBoolean() {
        ReturnTypesTest.assertFalse((String)"Expect false", (boolean)this.lib.returnFalse());
        ReturnTypesTest.assertTrue((String)"Expect true", (boolean)this.lib.returnTrue());
    }

    public void testInvokeInt() {
        ReturnTypesTest.assertEquals((String)"Expect 32-bit zero", (int)0, (int)this.lib.returnInt32Zero());
        ReturnTypesTest.assertEquals((String)"Expect 32-bit magic", (String)"12345678", (String)Integer.toHexString(this.lib.returnInt32Magic()));
    }

    public void testInvokeLong() {
        ReturnTypesTest.assertEquals((String)"Expect 64-bit zero", (long)0L, (long)this.lib.returnInt64Zero());
        ReturnTypesTest.assertEquals((String)"Expect 64-bit magic", (String)"123456789abcdef0", (String)Long.toHexString(this.lib.returnInt64Magic()));
    }

    public void testInvokeNativeLong() {
        if (NativeLong.SIZE == 4) {
            ReturnTypesTest.assertEquals((String)"Expect 32-bit zero", (Object)new NativeLong(0L), (Object)this.lib.returnLongZero());
            ReturnTypesTest.assertEquals((String)"Expect 32-bit magic", (String)"12345678", (String)Integer.toHexString(this.lib.returnLongMagic().intValue()));
        } else {
            ReturnTypesTest.assertEquals((String)"Expect 64-bit zero", (Object)new NativeLong(0L), (Object)this.lib.returnLongZero());
            ReturnTypesTest.assertEquals((String)"Expect 64-bit magic", (String)"123456789abcdef0", (String)Long.toHexString(this.lib.returnLongMagic().longValue()));
        }
    }

    protected NativeMappedLibrary loadNativeMappedLibrary() {
        return (NativeMappedLibrary)Native.loadLibrary((String)"testlib", NativeMappedLibrary.class);
    }

    public void testInvokeNativeMapped() {
        NativeMappedLibrary lib = this.loadNativeMappedLibrary();
        int MAGIC = 305419896;
        Custom EXPECTED = new Custom(305419896);
        ReturnTypesTest.assertEquals((String)"Argument not mapped", (Object)EXPECTED, (Object)lib.returnInt32Argument(305419896));
    }

    public void testInvokeFloat() {
        ReturnTypesTest.assertEquals((String)"Expect float zero", (double)0.0, (double)this.lib.returnFloatZero(), (double)0.0);
        ReturnTypesTest.assertEquals((String)"Expect float magic", (double)-118.625, (double)this.lib.returnFloatMagic(), (double)0.0);
    }

    public void testInvokeDouble() {
        ReturnTypesTest.assertEquals((String)"Expect double zero", (double)0.0, (double)this.lib.returnDoubleZero(), (double)0.0);
        ReturnTypesTest.assertEquals((String)"Expect double magic", (double)-118.625, (double)this.lib.returnDoubleMagic(), (double)0.0);
    }

    public void testInvokeString() {
        ReturnTypesTest.assertEquals((String)"Expect String magic", (String)MAGIC, (String)this.lib.returnStringMagic());
    }

    public void testInvokeWString() {
        WString s = this.lib.returnWStringMagic();
        ReturnTypesTest.assertEquals((String)"Wrong length", (int)MAGIC.length(), (int)s.toString().length());
        ReturnTypesTest.assertEquals((String)"Expect WString magic", (Object)new WString(MAGIC), (Object)s);
    }

    public void testInvokeStructure() {
        TestLibrary.SimpleStructure.allocations = 0;
        TestLibrary.SimpleStructure s = this.lib.returnStaticTestStructure();
        ReturnTypesTest.assertEquals((String)"Expect test structure magic", (double)-118.625, (double)s.value, (double)0.0);
        if (((Object)((Object)this)).getClass() == ReturnTypesTest.class) {
            ReturnTypesTest.assertEquals((String)"Returned Structure should allocate no memory", (int)0, (int)TestLibrary.SimpleStructure.allocations);
        }
    }

    public void testInvokeNullStructure() {
        TestLibrary.SimpleStructure s = this.lib.returnNullTestStructure();
        ReturnTypesTest.assertNull((String)"Expect null structure return", (Object)((Object)s));
    }

    public void testReturnSmallStructureByValue() {
        TestLibrary.TestSmallStructure.ByValue s = this.lib.returnSmallStructureByValue();
        ReturnTypesTest.assertNotNull((String)"Returned structure must not be null", (Object)((Object)s));
        ReturnTypesTest.assertEquals((String)"Wrong char field value (1)", (int)1, (int)s.c1);
        ReturnTypesTest.assertEquals((String)"Wrong char field value (2)", (int)2, (int)s.c2);
        ReturnTypesTest.assertEquals((String)"Wrong short field value", (int)3, (int)s.s);
    }

    public void testReturnStructureByValue() {
        TestLibrary.TestStructure.ByValue s = this.lib.returnStructureByValue();
        ReturnTypesTest.assertNotNull((String)"Returned structure must not be null", (Object)((Object)s));
        ReturnTypesTest.assertEquals((String)"Wrong char field value", (int)1, (int)s.c);
        ReturnTypesTest.assertEquals((String)"Wrong short field value", (int)2, (int)s.s);
        ReturnTypesTest.assertEquals((String)"Wrong int field value", (int)3, (int)s.i);
        ReturnTypesTest.assertEquals((String)"Wrong long field value", (long)4L, (long)s.j);
        ReturnTypesTest.assertNotNull((String)"Structure not initialized", (Object)((Object)s.inner));
        ReturnTypesTest.assertEquals((String)"Wrong inner structure value", (double)5.0, (double)s.inner.value, (double)0.0);
    }

    public void testReturnPointerArray() {
        Memory value = new Memory(10L);
        Pointer[] input = new Pointer[]{value, null};
        Pointer[] result = this.lib.returnPointerArgument(input);
        ReturnTypesTest.assertEquals((String)"Wrong array length", (int)(input.length - 1), (int)result.length);
        ReturnTypesTest.assertEquals((String)"Wrong array element value", (Object)value, (Object)result[0]);
    }

    public void testReturnStringArray() {
        String value = this.getName();
        String[] input = new String[]{value, null};
        String[] result = this.lib.returnPointerArgument(input);
        ReturnTypesTest.assertEquals((String)"Wrong array length", (int)(input.length - 1), (int)result.length);
        ReturnTypesTest.assertEquals((String)"Wrong array element value", (String)value, (String)result[0]);
    }

    public void testReturnWStringArray() {
        WString value = new WString(this.getName());
        WString[] input = new WString[]{value, null};
        WString[] result = this.lib.returnPointerArgument(input);
        ReturnTypesTest.assertEquals((String)"Wrong array length", (int)(input.length - 1), (int)result.length);
        ReturnTypesTest.assertEquals((String)"Wrong array element value", (Object)value, (Object)result[0]);
    }

    public static void main(String[] argList) {
        TestRunner.run(ReturnTypesTest.class);
    }

    public static class Custom
    implements NativeMapped {
        private int value;

        public Custom() {
        }

        public Custom(int value) {
            this.value = value;
        }

        public Object fromNative(Object nativeValue, FromNativeContext context) {
            return new Custom((Integer)nativeValue);
        }

        public Class nativeType() {
            return Integer.class;
        }

        public Object toNative() {
            return new Integer(this.value);
        }

        public boolean equals(Object o) {
            return o instanceof Custom && ((Custom)o).value == this.value;
        }
    }

    public static interface NativeMappedLibrary
    extends Library {
        public Custom returnInt32Argument(int var1);
    }

    public static interface TestLibrary
    extends Library {
        public Object returnObjectArgument(Object var1);

        public TestObject returnObjectArgument(TestObject var1);

        public boolean returnFalse();

        public boolean returnTrue();

        public int returnInt32Zero();

        public int returnInt32Magic();

        public long returnInt64Zero();

        public long returnInt64Magic();

        public NativeLong returnLongZero();

        public NativeLong returnLongMagic();

        public float returnFloatZero();

        public float returnFloatMagic();

        public double returnDoubleZero();

        public double returnDoubleMagic();

        public String returnStringMagic();

        public WString returnWStringMagic();

        public SimpleStructure returnStaticTestStructure();

        public SimpleStructure returnNullTestStructure();

        public TestSmallStructure.ByValue returnSmallStructureByValue();

        public TestStructure.ByValue returnStructureByValue();

        public Pointer[] returnPointerArgument(Pointer[] var1);

        public String[] returnPointerArgument(String[] var1);

        public WString[] returnPointerArgument(WString[] var1);

        public static class TestObject {
        }

        public static class CheckFieldAlignment
        extends Structure {
            public int int32Field = 1;
            public long int64Field = 2L;
            public float floatField = 3.0f;
            public double doubleField = 4.0;

            protected List getFieldOrder() {
                return Arrays.asList("int32Field", "int64Field", "floatField", "doubleField");
            }
        }

        public static class TestStructure
        extends Structure {
            public byte c;
            public short s;
            public int i;
            public long j;
            public SimpleStructure inner;

            protected List getFieldOrder() {
                return Arrays.asList("c", "s", "i", "j", "inner");
            }

            public static class ByValue
            extends TestStructure
            implements Structure.ByValue {
            }
        }

        public static class TestSmallStructure
        extends Structure {
            public byte c1;
            public byte c2;
            public short s;

            protected List getFieldOrder() {
                return Arrays.asList("c1", "c2", "s");
            }

            public static class ByValue
            extends TestSmallStructure
            implements Structure.ByValue {
            }
        }

        public static class SimpleStructure
        extends Structure {
            public double value;
            public static int allocations = 0;

            public SimpleStructure() {
            }

            public SimpleStructure(Pointer p) {
                super(p);
                this.read();
            }

            protected void allocateMemory(int size) {
                super.allocateMemory(size);
                ++allocations;
            }

            protected List getFieldOrder() {
                return Arrays.asList("value");
            }
        }
    }
}

