/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class LibraryLoadTest
extends TestCase {
    private static final String BUILDDIR = System.getProperty("jna.builddir", "build" + (Platform.is64Bit() ? "-d64" : ""));
    private static final String UNICODE = "\u0444\u043b\u0441\u0432\u0443";

    public void testLoadJNALibrary() {
        LibraryLoadTest.assertTrue((String)"Pointer size should never be zero", (Pointer.SIZE > 0 ? 1 : 0) != 0);
    }

    public void testLoadJAWT() {
        if (!Platform.HAS_AWT) {
            return;
        }
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        AWT.loadJAWT(this.getName());
    }

    public void testLoadAWTAfterJNA() {
        if (!Platform.HAS_AWT) {
            return;
        }
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        if (Pointer.SIZE > 0) {
            Toolkit.getDefaultToolkit();
        }
    }

    private Object load() {
        return Native.loadLibrary((String)Platform.C_LIBRARY_NAME, CLibrary.class);
    }

    public void testLoadCLibrary() {
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(File src, File dst) throws Exception {
        FileInputStream is = new FileInputStream(src);
        FileOutputStream os = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        try {
            int count;
            while ((count = is.read(buf, 0, buf.length)) > 0) {
                os.write(buf, 0, count);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
            try {
                os.close();
            }
            catch (IOException e) {}
        }
    }

    public void testLoadLibraryWithUnicodeName() throws Exception {
        int dot;
        String tmp = System.getProperty("java.io.tmpdir");
        String libName = System.mapLibraryName("jnidispatch");
        File src = new File(BUILDDIR + "/native", libName);
        if (Platform.isWindowsCE()) {
            src = new File("/Storage Card", libName);
        }
        LibraryLoadTest.assertTrue((String)("Expected JNA native library at " + src + " is missing"), (boolean)src.exists());
        String newLibName = UNICODE;
        if (libName.startsWith("lib")) {
            newLibName = "lib" + newLibName;
        }
        if ((dot = libName.lastIndexOf(".")) != -1) {
            newLibName = Platform.isMac() ? newLibName + ".dylib" : newLibName + libName.substring(dot, libName.length());
        }
        File dst = new File(tmp, newLibName);
        dst.deleteOnExit();
        this.copy(src, dst);
        NativeLibrary.addSearchPath((String)UNICODE, (String)tmp);
        NativeLibrary nl = NativeLibrary.getInstance((String)UNICODE);
        nl.dispose();
    }

    public void testHandleObjectMethods() {
        CLibrary lib = (CLibrary)this.load();
        String method = "toString";
        try {
            lib.toString();
            method = "hashCode";
            lib.hashCode();
            method = "equals";
            lib.equals(null);
        }
        catch (UnsatisfiedLinkError e) {
            LibraryLoadTest.fail((String)("Object method '" + method + "' not handled"));
        }
    }

    public void testLoadDependentLibraryWithAlteredSearchPath() {
        block2: {
            try {
                TestLib2 lib = (TestLib2)Native.loadLibrary((String)"testlib2", TestLib2.class);
                lib.dependentReturnFalse();
            }
            catch (UnsatisfiedLinkError e) {
                if (!Platform.isWindows() || Platform.isWindowsCE()) break block2;
                LibraryLoadTest.fail((String)("Failed to load dependent libraries: " + e));
            }
        }
    }

    public void testLoadProperCLibraryVersion() {
        if (Platform.isWindows()) {
            return;
        }
        CLibrary lib = (CLibrary)Native.loadLibrary((String)"c", CLibrary.class);
        LibraryLoadTest.assertNotNull((String)"Couldn't get current user", (Object)lib.getpwuid(lib.geteuid()));
    }

    public static void main(String[] args) {
        TestRunner.run(LibraryLoadTest.class);
    }

    private static class AWT {
        private AWT() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void loadJAWT(String name) {
            Frame f = new Frame(name);
            f.pack();
            try {
                Native.getWindowPointer((Window)f);
            }
            finally {
                f.dispose();
            }
        }
    }

    public static interface TestLib2
    extends Library {
        public int dependentReturnFalse();
    }

    public static interface CLibrary
    extends Library {
        public int wcslen(WString var1);

        public int strlen(String var1);

        public int atol(String var1);

        public Pointer getpwuid(int var1);

        public int geteuid();
    }
}

