/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.FunctionMapper;
import com.sun.jna.LastErrorException;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class LastErrorTest
extends TestCase {
    private static final Map OPTIONS = new HashMap(){
        {
            this.put("function-mapper", new FunctionMapper(){

                public String getFunctionName(NativeLibrary library, Method m) {
                    if (m.getName().equals("noThrowLastError") || m.getName().equals("throwLastError")) {
                        return "setLastError";
                    }
                    return m.getName();
                }
            });
        }
    };

    public void testThrowLastError() {
        HashMap options = new HashMap();
        TestLibrary lib = (TestLibrary)Native.loadLibrary((String)"testlib", TestLibrary.class, (Map)OPTIONS);
        int ERROR = -1;
        lib.noThrowLastError(-1);
        LastErrorTest.assertEquals((String)"Last error not preserved", (int)-1, (int)Native.getLastError());
        try {
            lib.throwLastError(-1);
            LastErrorTest.fail((String)"Method should throw LastErrorException");
        }
        catch (LastErrorException e) {
            LastErrorTest.assertEquals((String)"Exception should contain error code", (int)-1, (int)e.getErrorCode());
        }
    }

    public void testThrowLastErrorDirect() {
        DirectTestLibrary lib = new DirectTestLibrary();
        int ERROR = -1;
        lib.noThrowLastError(-1);
        LastErrorTest.assertEquals((String)"Last error not preserved", (int)-1, (int)Native.getLastError());
        try {
            lib.throwLastError(-1);
            LastErrorTest.fail((String)"Method should throw LastErrorException");
        }
        catch (LastErrorException e) {
            LastErrorTest.assertEquals((String)"Exception should contain error code", (int)-1, (int)e.getErrorCode());
        }
    }

    public static void main(String[] args) {
        TestRunner.run(LastErrorTest.class);
    }

    public static class DirectTestLibrary
    implements TestLibrary {
        public native void noThrowLastError(int var1);

        public native void throwLastError(int var1) throws LastErrorException;

        static {
            Native.register((NativeLibrary)NativeLibrary.getInstance((String)"testlib", (Map)OPTIONS));
        }
    }

    public static interface TestLibrary
    extends Library {
        public void noThrowLastError(int var1);

        public void throwLastError(int var1) throws LastErrorException;
    }
}

