/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporting.util;

import cloverantlr.Token;
import cloverantlr.TokenStreamException;
import com.cenqua.clover.instr.InstrumentationConfig;
import com.cenqua.clover.instr.UnicodeJavaLexer;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;

public abstract class JavaSourceRenderer {
    private static final HashSet KEYWORD_TOKS = new HashSet();
    private static final HashSet JAVADOC_KEYWORDS = new HashSet();

    public void process(String s) throws TokenStreamException {
        if (s == null) {
            return;
        }
        this.process(new StringReader(s));
    }

    public void process(Reader in) throws TokenStreamException {
        Token token;
        UnicodeJavaLexer lexer = new UnicodeJavaLexer(in, new InstrumentationConfig());
        Token prev = token = lexer.nextToken();
        StringBuffer currentChunk = new StringBuffer();
        StringBuffer accumName = new StringBuffer();
        boolean gatherPkgIdent = false;
        boolean gatherImportIdent = false;
        while (prev != null && 1 != prev.getType()) {
            if (token != null && token.getType() == prev.getType()) {
                currentChunk.append(token.getText());
            } else {
                if (147 == prev.getType()) {
                    this.processWhiteSpace(currentChunk.toString());
                } else if (143 == prev.getType()) {
                    this.renderStringLiteral(currentChunk.toString());
                } else if (148 == prev.getType()) {
                    this.renderCommentChunk(currentChunk.toString());
                } else if (149 == prev.getType()) {
                    this.processComment(currentChunk.toString());
                } else if (KEYWORD_TOKS.contains(new Integer(prev.getType()))) {
                    this.renderKeyword(currentChunk.toString());
                    gatherPkgIdent = prev.getType() == 44;
                    gatherImportIdent = prev.getType() == 46;
                } else if (gatherPkgIdent || gatherImportIdent) {
                    if (45 == prev.getType()) {
                        if (gatherImportIdent) {
                            this.addImportScope(accumName.toString());
                        }
                        accumName = new StringBuffer();
                        gatherPkgIdent = false;
                        gatherImportIdent = false;
                        this.renderChunk(currentChunk.toString());
                    } else if (51 == prev.getType()) {
                        accumName.append(currentChunk.toString());
                        this.renderChunk(currentChunk.toString());
                    } else if (50 == prev.getType()) {
                        accumName.append(currentChunk.toString());
                        if (gatherPkgIdent) {
                            this.renderPackageSegment(accumName.toString(), currentChunk.toString());
                        } else {
                            this.renderImportSegment(accumName.toString(), currentChunk.toString());
                        }
                    } else {
                        this.renderChunk(currentChunk.toString());
                    }
                } else if (50 == prev.getType()) {
                    this.renderIdentifier(currentChunk.toString());
                } else {
                    this.renderChunk(currentChunk.toString());
                }
                currentChunk = new StringBuffer();
                currentChunk.append(token.getText());
            }
            prev = token;
            token = lexer.nextToken();
        }
        this.endDocument();
    }

    private void processWhiteSpace(String s) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c2;
            boolean atNewLine = false;
            char c1 = s.charAt(i);
            char c = c2 = i + 1 < s.length() ? s.charAt(i + 1) : (char)'\u0000';
            if (c1 == '\r' && c2 == '\n') {
                atNewLine = true;
                ++i;
            } else if (c1 == '\r' || c1 == '\n') {
                atNewLine = true;
            }
            if (atNewLine) {
                if (b.length() > 0) {
                    this.renderChunk(b.toString());
                    b = new StringBuffer();
                }
                this.renderNewLine();
                continue;
            }
            b.append(c1);
        }
        if (b.length() > 0) {
            this.renderChunk(b.toString());
        }
    }

    private void processComment(String s) {
        StringBuffer b = new StringBuffer();
        boolean inTag = false;
        for (int i = 0; i < s.length(); ++i) {
            char c2;
            boolean atNewLine = false;
            char c1 = s.charAt(i);
            char c = c2 = i + 1 < s.length() ? s.charAt(i + 1) : (char)'\u0000';
            if (c1 == '\r' && c2 == '\n') {
                atNewLine = true;
                ++i;
            } else if (c1 == '\r' || c1 == '\n') {
                atNewLine = true;
            }
            if (!inTag && c1 == '@' && Character.isLetter(c2)) {
                inTag = true;
                this.renderCommentChunk(b.toString());
                b = new StringBuffer();
            } else if (inTag && !Character.isLetter(c1)) {
                inTag = false;
                String tag = b.toString();
                if (JAVADOC_KEYWORDS.contains(tag.substring(1))) {
                    this.renderJavadocTag(tag);
                    b = new StringBuffer();
                }
            }
            if (atNewLine) {
                if (b.length() > 0) {
                    this.renderCommentChunk(b.toString());
                    b = new StringBuffer();
                }
                this.renderNewLine();
                continue;
            }
            b.append(c1);
        }
        if (b.length() > 0) {
            String left = b.toString();
            if (inTag && JAVADOC_KEYWORDS.contains(left)) {
                this.renderJavadocTag(left);
            } else {
                this.renderCommentChunk(left);
            }
        }
    }

    protected void renderNewLine() {
        this.renderChunk("\n");
    }

    protected void renderPackageSegment(String accum, String seg) {
        this.renderChunk(seg);
    }

    protected void renderImportSegment(String accum, String seg) {
        this.renderChunk(seg);
    }

    protected void renderIdentifier(String ident) {
        this.renderChunk(ident);
    }

    protected void addImportScope(String imp) {
    }

    protected abstract void renderStringLiteral(String var1);

    protected abstract void renderKeyword(String var1);

    protected abstract void renderCommentChunk(String var1);

    protected abstract void renderJavadocTag(String var1);

    protected abstract void renderChunk(String var1);

    protected void endDocument() {
    }

    static {
        KEYWORD_TOKS.add(new Integer(40));
        KEYWORD_TOKS.add(new Integer(39));
        KEYWORD_TOKS.add(new Integer(92));
        KEYWORD_TOKS.add(new Integer(61));
        KEYWORD_TOKS.add(new Integer(99));
        KEYWORD_TOKS.add(new Integer(62));
        KEYWORD_TOKS.add(new Integer(104));
        KEYWORD_TOKS.add(new Integer(107));
        KEYWORD_TOKS.add(new Integer(63));
        KEYWORD_TOKS.add(new Integer(77));
        KEYWORD_TOKS.add(new Integer(100));
        KEYWORD_TOKS.add(new Integer(86));
        KEYWORD_TOKS.add(new Integer(98));
        KEYWORD_TOKS.add(new Integer(68));
        KEYWORD_TOKS.add(new Integer(95));
        KEYWORD_TOKS.add(new Integer(55));
        KEYWORD_TOKS.add(new Integer(138));
        KEYWORD_TOKS.add(new Integer(106));
        KEYWORD_TOKS.add(new Integer(66));
        KEYWORD_TOKS.add(new Integer(96));
        KEYWORD_TOKS.add(new Integer(94));
        KEYWORD_TOKS.add(new Integer(87));
        KEYWORD_TOKS.add(new Integer(46));
        KEYWORD_TOKS.add(new Integer(127));
        KEYWORD_TOKS.add(new Integer(65));
        KEYWORD_TOKS.add(new Integer(78));
        KEYWORD_TOKS.add(new Integer(67));
        KEYWORD_TOKS.add(new Integer(74));
        KEYWORD_TOKS.add(new Integer(140));
        KEYWORD_TOKS.add(new Integer(139));
        KEYWORD_TOKS.add(new Integer(44));
        KEYWORD_TOKS.add(new Integer(70));
        KEYWORD_TOKS.add(new Integer(72));
        KEYWORD_TOKS.add(new Integer(71));
        KEYWORD_TOKS.add(new Integer(101));
        KEYWORD_TOKS.add(new Integer(64));
        KEYWORD_TOKS.add(new Integer(47));
        KEYWORD_TOKS.add(new Integer(56));
        KEYWORD_TOKS.add(new Integer(102));
        KEYWORD_TOKS.add(new Integer(75));
        KEYWORD_TOKS.add(new Integer(88));
        KEYWORD_TOKS.add(new Integer(103));
        KEYWORD_TOKS.add(new Integer(90));
        KEYWORD_TOKS.add(new Integer(73));
        KEYWORD_TOKS.add(new Integer(137));
        KEYWORD_TOKS.add(new Integer(105));
        KEYWORD_TOKS.add(new Integer(60));
        KEYWORD_TOKS.add(new Integer(76));
        KEYWORD_TOKS.add(new Integer(97));
        KEYWORD_TOKS.add(new Integer(41));
        JAVADOC_KEYWORDS.add("author");
        JAVADOC_KEYWORDS.add("version");
        JAVADOC_KEYWORDS.add("see");
        JAVADOC_KEYWORDS.add("since");
        JAVADOC_KEYWORDS.add("deprecated");
        JAVADOC_KEYWORDS.add("param");
        JAVADOC_KEYWORDS.add("return");
        JAVADOC_KEYWORDS.add("exception");
        JAVADOC_KEYWORDS.add("value");
        JAVADOC_KEYWORDS.add("serial");
        JAVADOC_KEYWORDS.add("inheritDoc");
        JAVADOC_KEYWORDS.add("link");
        JAVADOC_KEYWORDS.add("linkplain");
        JAVADOC_KEYWORDS.add("docRoot");
        JAVADOC_KEYWORDS.add("throws");
    }
}

