/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.json;

import clover.org.apache.velocity.VelocityContext;
import com.cenqua.clover.CloverException;
import com.cenqua.clover.Logger;
import com.cenqua.clover.registry.HasMetrics;
import com.cenqua.clover.reporters.Column;
import com.cenqua.clover.reporters.Columns;
import com.cenqua.clover.reporters.html.HtmlReportUtil;
import com.cenqua.clover.reporters.json.JSONException;
import com.cenqua.clover.reporters.json.JSONObject;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JSONHistoricalReporter {
    final File mBasePath;

    public JSONHistoricalReporter(File basePath) {
        this.mBasePath = basePath;
    }

    public void generateHistoricalJSON(VelocityContext context, Map data) throws Exception {
        JSONObject json = this.generateJSON(data);
        File jsonOutfile = new File(this.mBasePath, "historical-json.js");
        context.put("json", json.toString(2));
        context.put("callback", "processHistoricalCloverData");
        Logger.getInstance().info("Writing historical-data to: " + jsonOutfile);
        HtmlReportUtil.mergeTemplateToFile(jsonOutfile, context, "html_res/api-json.vm");
    }

    JSONObject generateJSON(Map data) throws JSONException {
        JSONObject json = new JSONObject();
        HashMap table = new HashMap();
        LinkedList cols = new LinkedList();
        LinkedList rows = new LinkedList();
        table.put("cols", cols);
        table.put("rows", rows);
        json.append("table", table);
        this.addColumnInfo(cols, "timestamp", "Date", "date");
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        List columns = Columns.getAllColumns();
        Iterator iterator = columns.iterator();
        while (iterator.hasNext()) {
            Column col = (Column)iterator.next();
            this.addColumnInfo(cols, col.getName(), col.getTitle(), "number");
        }
        Iterator iterator2 = data.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            HasMetrics hasMetrics = (HasMetrics)entry.getValue();
            Long timestamp = (Long)entry.getKey();
            HashMap rowData = new HashMap();
            rows.add(rowData);
            LinkedList row = new LinkedList();
            rowData.put("c", row);
            this.addRowInfo(row, new Date(timestamp), dateFormat.format(timestamp));
            this.addColumnData(columns, hasMetrics, row);
        }
        return json;
    }

    private void addColumnData(List columns, HasMetrics hasMetrics, List row) {
        Iterator iterator = columns.iterator();
        while (iterator.hasNext()) {
            Column col = (Column)iterator.next();
            try {
                col.init(hasMetrics.getMetrics());
            }
            catch (CloverException e) {
                Logger.getInstance().debug("Skipping data for column: " + col.getName(), e);
                continue;
            }
            this.addRowInfo(row, col.getNumber(), col.getFormat().format(col.getColumnData()));
        }
    }

    private void addRowInfo(List row, Object value, String fmtValue) {
        HashMap<String, Object> rowInfo = new HashMap<String, Object>();
        row.add(rowInfo);
        rowInfo.put("v", value);
        rowInfo.put("f", fmtValue);
    }

    private void addColumnInfo(List cols, String id, String label, String type) {
        HashMap<String, String> colInfo = new HashMap<String, String>();
        colInfo.put("id", id);
        colInfo.put("label", label);
        colInfo.put("type", type);
        cols.add(colInfo);
    }
}

