/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover;

import clover.org.apache.commons.lang.mutable.MutableLong;
import com.cenqua.clover.CloverException;
import com.cenqua.clover.CoverageData;
import com.cenqua.clover.CoverageDataSpec;
import com.cenqua.clover.CoverageRecordingTranscript;
import com.cenqua.clover.Logger;
import com.cenqua.clover.PerTestRecordingTranscript;
import com.cenqua.clover.ProgressListener;
import com.cenqua.clover.RecordingTranscripts;
import com.cenqua.clover.registry.BaseFileInfo;
import com.cenqua.clover.registry.Clover2Registry;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.FileInfoVisitor;
import com.cenqua.clover.registry.TestCaseInfo;
import com.cenqua.clover.util.FileUtils;
import java.io.IOException;
import java.util.Iterator;

public class CoverageDataCollator {
    private Clover2Registry registry;
    private RecordingTranscripts.Filter filter;

    public CoverageDataCollator(Clover2Registry registry) {
        this.registry = registry;
    }

    public CoverageData loadCoverageData(CoverageDataSpec spec, ProgressListener progressListener) throws CloverException {
        CoverageData coverageData = new CoverageData(this.registry, spec);
        this.maybeInitFilter(spec);
        this.filter.processDir();
        coverageData.setSource(this.filter);
        this.collateRecordingFiles(coverageData, spec);
        if (spec.isLoadPerTestData()) {
            this.collatePerTestRecordings(coverageData, spec, progressListener != null ? progressListener : ProgressListener.NOOP_LISTENER);
        }
        return coverageData;
    }

    private void maybeInitFilter(CoverageDataSpec spec) {
        long from = this.registry.getVersion() - spec.getSpan();
        long to = Long.MAX_VALUE;
        if (this.filter == null || this.filter.getFrom() != from || this.filter.getTo() != to) {
            this.filter = new RecordingTranscripts.Filter(FileUtils.getCurrentDirIfNull(this.registry.getRegistryFile().getParentFile()), this.registry.getRegistryFile().getName(), from, to, spec.isDeleteUnusedCoverage());
        }
    }

    private void collateRecordingFiles(CoverageData coverageData, CoverageDataSpec spec) {
        long start = System.currentTimeMillis();
        int numRecordings = 0;
        long tsNewestRecordingUsed = 0L;
        long tsOldestRecordingUsed = Long.MAX_VALUE;
        final MutableLong maxVersion = new MutableLong(0L);
        final MutableLong minVersion = new MutableLong(Long.MAX_VALUE);
        this.registry.getModel().visitFiles(new FileInfoVisitor(){

            public void visitFileInfo(BaseFileInfo f) {
                FileInfo file = (FileInfo)f;
                maxVersion.setValue(Math.max(maxVersion.longValue(), file.getMaxVersion()));
                minVersion.setValue(Math.min(minVersion.longValue(), file.getMinVersion()));
            }
        });
        Iterator it = this.filter.getCoverageRecordingFiles().iterator();
        while (it.hasNext()) {
            boolean[] alreadyTruncated = new boolean[]{false};
            RecordingTranscripts.FileRef recordingFile = (RecordingTranscripts.FileRef)it.next();
            try {
                CoverageRecordingTranscript rec = (CoverageRecordingTranscript)recordingFile.read(spec);
                long version = rec.getDbVersion();
                if (version <= maxVersion.longValue() && version >= minVersion.longValue()) {
                    coverageData.addCoverage(rec);
                    ++numRecordings;
                    if (recordingFile.getTimestamp() < tsOldestRecordingUsed) {
                        tsOldestRecordingUsed = recordingFile.getTimestamp();
                    }
                    if (rec.getWriteTimeStamp() <= tsNewestRecordingUsed) continue;
                    tsNewestRecordingUsed = rec.getWriteTimeStamp();
                    continue;
                }
                Logger.getInstance().debug("Ignoring coverage recording " + rec + " because no FileInfo supports its coverage range");
            }
            catch (IOException e) {
                Logger.getInstance().warn("Failed to load coverage recording " + recordingFile, e);
            }
        }
        coverageData.avoidObviousOverflow();
        coverageData.setTimestamp(tsNewestRecordingUsed);
        long end = System.currentTimeMillis();
        Logger.getInstance().debug("Processed " + numRecordings + " recording files in " + (end - start) + "ms (" + (numRecordings != 0 ? "" + (end - start) / (long)numRecordings + "ms" : "-") + " per recording)");
    }

    private void collatePerTestRecordings(CoverageData coverageData, CoverageDataSpec spec, ProgressListener progressListener) throws CloverException {
        long start = System.currentTimeMillis();
        int numPerTestRecordings = 0;
        float progress = 0.0f;
        float progressIncrement = this.filter.getPerTestRecordingFiles().size() > 0 ? 1.0f / (float)this.filter.getPerTestRecordingFiles().size() : 1.0f;
        Iterator it = this.filter.getPerTestRecordingFiles().iterator();
        while (it.hasNext()) {
            ++numPerTestRecordings;
            RecordingTranscripts.FileRef recordingFile = (RecordingTranscripts.FileRef)it.next();
            try {
                PerTestRecordingTranscript recording = (PerTestRecordingTranscript)recordingFile.read(spec);
                TestCaseInfo tci = TestCaseInfo.Factory.getInstanceForSlice(recording);
                coverageData.addCoverage(tci, recording);
            }
            catch (IOException e) {
                Logger.getInstance().warn("Failed to load per-test coverage recording " + recordingFile, e);
            }
            progressListener.handleProgress("Reading per-test data", progress += progressIncrement);
        }
        long end = System.currentTimeMillis();
        Logger.getInstance().debug("Processed " + numPerTestRecordings + " per-test recording files in " + (end - start) + "ms (" + (numPerTestRecordings != 0 ? "" + (end - start) / (long)numPerTestRecordings + "ms" : "-") + " per recording)");
    }

    public void setSpec(CoverageDataSpec spec) {
        this.maybeInitFilter(spec);
    }
}

