/*
 * Decompiled with CFR 0.152.
 */
package cloverantlr;

import cloverantlr.ANTLRGrammarParseBehavior;
import cloverantlr.ANTLRLexer;
import cloverantlr.ANTLRParser;
import cloverantlr.CodeGenerator;
import cloverantlr.DefaultToolErrorHandler;
import cloverantlr.DefineGrammarSymbols;
import cloverantlr.FileCopyException;
import cloverantlr.FileLineFormatter;
import cloverantlr.LLkAnalyzer;
import cloverantlr.LLkGrammarAnalyzer;
import cloverantlr.MakeGrammar;
import cloverantlr.NameSpace;
import cloverantlr.RecognitionException;
import cloverantlr.TokenBuffer;
import cloverantlr.TokenStream;
import cloverantlr.TokenStreamException;
import cloverantlr.ToolErrorHandler;
import cloverantlr.collections.impl.BitSet;
import cloverantlr.collections.impl.Vector;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;

public class Tool {
    public static final String version = "2.7.1";
    ToolErrorHandler errorHandler;
    protected boolean hasError = false;
    boolean genDiagnostics = false;
    boolean genHTML = false;
    protected static String outputDir = ".";
    String grammarFile;
    transient Reader f = new InputStreamReader(System.in);
    protected static String literalsPrefix = "LITERAL_";
    protected static boolean upperCaseMangledLiterals = false;
    protected static NameSpace nameSpace = null;
    protected static String namespaceAntlr = null;
    protected static String namespaceStd = null;
    protected static boolean genHashLines = true;
    private static BitSet cmdLineArgValid = new BitSet();

    public Tool() {
        this.errorHandler = new DefaultToolErrorHandler();
    }

    public static void setFileLineFormatter(FileLineFormatter formatter) {
        FileLineFormatter.setFormatter(formatter);
    }

    private static void checkForInvalidArguments(String[] args, BitSet cmdLineArgValid) {
        for (int a = 0; a < args.length; ++a) {
            if (cmdLineArgValid.member(a)) continue;
            Tool.warning("invalid command-line argument: " + args[a] + "; ignored");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyFile(String source_name, String dest_name) throws IOException {
        File source_file = new File(source_name);
        File destination_file = new File(dest_name);
        InputStreamReader source = null;
        OutputStreamWriter destination = null;
        try {
            if (!source_file.exists() || !source_file.isFile()) {
                throw new FileCopyException("FileCopy: no such source file: " + source_name);
            }
            if (!source_file.canRead()) {
                throw new FileCopyException("FileCopy: source file is unreadable: " + source_name);
            }
            if (destination_file.exists()) {
                if (!destination_file.isFile()) throw new FileCopyException("FileCopy: destination is not a file: " + dest_name);
                DataInputStream in = new DataInputStream(System.in);
                if (!destination_file.canWrite()) {
                    throw new FileCopyException("FileCopy: destination file is unwriteable: " + dest_name);
                }
            } else {
                File parentdir = Tool.parent(destination_file);
                if (!parentdir.exists()) {
                    throw new FileCopyException("FileCopy: destination directory doesn't exist: " + dest_name);
                }
                if (!parentdir.canWrite()) {
                    throw new FileCopyException("FileCopy: destination directory is unwriteable: " + dest_name);
                }
            }
            source = new FileReader(source_file);
            destination = new FileWriter(destination_file);
            char[] buffer = new char[1024];
            while (true) {
                int bytes_read;
                if ((bytes_read = source.read(buffer, 0, 1024)) == -1) {
                    return;
                }
                destination.write(buffer, 0, bytes_read);
            }
        }
        finally {
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException e) {}
            }
            if (destination != null) {
                try {
                    destination.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected void doEverything(String[] args) {
        cloverantlr.preprocessor.Tool preTool = new cloverantlr.preprocessor.Tool(this, args);
        if (!preTool.preprocess()) {
            System.exit(1);
        }
        String[] modifiedArgs = preTool.preprocessedArgList();
        this.processArguments(modifiedArgs);
        this.f = this.getGrammarReader();
        TokenBuffer tokenBuf = new TokenBuffer((TokenStream)new ANTLRLexer(this.f));
        LLkAnalyzer analyzer = new LLkAnalyzer(this);
        MakeGrammar behavior = new MakeGrammar(this, args, analyzer);
        try {
            ANTLRParser p = new ANTLRParser(tokenBuf, (ANTLRGrammarParseBehavior)behavior, this);
            p.setFilename(this.grammarFile);
            p.grammar();
            if (this.hasError) {
                System.err.println("Exiting due to errors.");
                System.exit(1);
            }
            Tool.checkForInvalidArguments(modifiedArgs, cmdLineArgValid);
            String codeGenClassName = "cloverantlr." + this.getLanguage(behavior) + "CodeGenerator";
            try {
                Class<?> codeGenClass = Class.forName(codeGenClassName);
                CodeGenerator codeGen = (CodeGenerator)codeGenClass.newInstance();
                codeGen.setBehavior((DefineGrammarSymbols)behavior);
                codeGen.setAnalyzer((LLkGrammarAnalyzer)analyzer);
                codeGen.setTool(this);
                codeGen.gen();
            }
            catch (ClassNotFoundException cnfe) {
                Tool.panic("Cannot instantiate code-generator: " + codeGenClassName);
            }
            catch (InstantiationException ie) {
                Tool.panic("Cannot instantiate code-generator: " + codeGenClassName);
            }
            catch (IllegalArgumentException ie) {
                Tool.panic("Cannot instantiate code-generator: " + codeGenClassName);
            }
            catch (IllegalAccessException iae) {
                Tool.panic("code-generator class '" + codeGenClassName + "' is not accessible");
            }
        }
        catch (RecognitionException pe) {
            System.err.println("Unhandled parser error: " + pe.getMessage());
            System.exit(1);
        }
        catch (TokenStreamException io) {
            System.err.println("TokenStreamException: " + io.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    public void error(String s) {
        this.hasError = true;
        System.err.println("error: " + s);
    }

    public void error(String s, String file, int line) {
        this.hasError = true;
        if (file != null) {
            System.err.println(FileLineFormatter.getFormatter().getFormatString(file, line) + s);
        } else {
            System.err.println("line " + line + ": " + s);
        }
    }

    public static Object factory(String p) {
        Object o = null;
        try {
            Class<?> c = Class.forName(p);
            o = c.newInstance();
        }
        catch (Exception e) {
            Tool.warning("Can't create an object of type " + p);
            return null;
        }
        return o;
    }

    public static String fileMinusPath(String f) {
        String separator = System.getProperty("file.separator");
        int endOfPath = f.lastIndexOf(separator);
        if (endOfPath == -1) {
            return f;
        }
        return f.substring(endOfPath + 1);
    }

    public String getLanguage(MakeGrammar behavior) {
        if (this.genDiagnostics) {
            return "Diagnostic";
        }
        if (this.genHTML) {
            return "HTML";
        }
        return behavior.language;
    }

    public static String getOutputDirectory() {
        return outputDir;
    }

    private static void help() {
        System.err.println("usage: java cloverantlr.Tool [args] file.g");
        System.err.println("  -o outputDir       specify output directory where all output generated.");
        System.err.println("  -glib superGrammar specify location of supergrammar file.");
        System.err.println("  -debug             launch the ParseView debugger upon parser invocation.");
        System.err.println("  -html              generate an html file from your grammar (minus actions).");
        System.err.println("  -diagnostic        generate a textfile with diagnostics.");
        System.err.println("  -trace             have all rules call traceIn/traceOut.");
        System.err.println("  -traceParser       have parser rules call traceIn/traceOut.");
        System.err.println("  -traceLexer        have lexer rules call traceIn/traceOut.");
        System.err.println("  -traceTreeParser   have tree parser rules call traceIn/traceOut.");
    }

    public static void main(String[] args) {
        System.err.println("ANTLR Parser Generator   Version 2.7.1   1989-2000 jGuru.com");
        try {
            if (args.length == 0) {
                Tool.help();
            }
            Tool theTool = new Tool();
            theTool.doEverything(args);
            theTool = null;
        }
        catch (Exception e) {
            System.err.println(System.getProperty("line.separator") + System.getProperty("line.separator"));
            System.err.println("#$%%*&@# internal error: " + e.toString());
            System.err.println("[complain to nearest government official");
            System.err.println(" or send hate-mail to parrt@jguru.com;");
            System.err.println(" please send stack trace with report.]" + System.getProperty("line.separator"));
            e.printStackTrace();
        }
        System.exit(0);
    }

    public static PrintWriter openOutputFile(String f) throws IOException {
        return new PrintWriter(new FileWriter(outputDir + System.getProperty("file.separator") + f));
    }

    public Reader getGrammarReader() {
        try {
            if (this.grammarFile != null) {
                this.f = new FileReader(this.grammarFile);
            }
        }
        catch (IOException e) {
            Tool.panic("Error: cannot open grammar file " + this.grammarFile);
            Tool.help();
            System.exit(1);
        }
        return this.f;
    }

    public static void panic() {
        System.err.println("panic");
        System.exit(1);
    }

    public static void panic(String s) {
        System.err.println("panic: " + s);
        System.exit(1);
    }

    public static File parent(File f) {
        String dirname = f.getParent();
        if (dirname == null) {
            if (f.isAbsolute()) {
                return new File(File.separator);
            }
            return new File(System.getProperty("user.dir"));
        }
        return new File(dirname);
    }

    public static Vector parseSeparatedList(String list, char separator) {
        Vector v = new Vector(10);
        StringBuffer buf = new StringBuffer(100);
        int i = 0;
        while (i < list.length()) {
            while (i < list.length() && list.charAt(i) != separator) {
                buf.append(list.charAt(i));
                ++i;
            }
            v.appendElement(buf.toString());
            buf.setLength(0);
            if (i >= list.length()) continue;
            ++i;
        }
        if (v.size() == 0) {
            return null;
        }
        return v;
    }

    public static String pathToFile(String f) {
        String separator = System.getProperty("file.separator");
        int endOfPath = f.lastIndexOf(separator);
        if (endOfPath == -1) {
            return "." + System.getProperty("file.separator");
        }
        return f.substring(0, endOfPath + 1);
    }

    private void processArguments(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-diagnostic")) {
                this.genDiagnostics = true;
                this.genHTML = false;
                Tool.setArgOK(i);
                continue;
            }
            if (args[i].equals("-o")) {
                Tool.setArgOK(i);
                if (i + 1 >= args.length) {
                    this.error("missing output directory with -o option; ignoring");
                    continue;
                }
                Tool.setOutputDirectory(args[++i]);
                Tool.setArgOK(i);
                continue;
            }
            if (args[i].equals("-html")) {
                this.genHTML = true;
                this.genDiagnostics = false;
                Tool.setArgOK(i);
                continue;
            }
            if (args[i].charAt(0) == '-') continue;
            this.grammarFile = args[i];
            Tool.setArgOK(i);
        }
    }

    public static void setArgOK(int i) {
        cmdLineArgValid.add(i);
    }

    public static void setOutputDirectory(String o) {
        outputDir = o;
    }

    public static String stripBack(String s, char c) {
        while (s.length() > 0 && s.charAt(s.length() - 1) == c) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String stripBack(String s, String remove) {
        boolean changed;
        do {
            changed = false;
            for (int i = 0; i < remove.length(); ++i) {
                char c = remove.charAt(i);
                while (s.length() > 0 && s.charAt(s.length() - 1) == c) {
                    changed = true;
                    s = s.substring(0, s.length() - 1);
                }
            }
        } while (changed);
        return s;
    }

    public static String stripFront(String s, char c) {
        while (s.length() > 0 && s.charAt(0) == c) {
            s = s.substring(1);
        }
        return s;
    }

    public static String stripFront(String s, String remove) {
        boolean changed;
        do {
            changed = false;
            for (int i = 0; i < remove.length(); ++i) {
                char c = remove.charAt(i);
                while (s.length() > 0 && s.charAt(0) == c) {
                    changed = true;
                    s = s.substring(1);
                }
            }
        } while (changed);
        return s;
    }

    public static String stripFrontBack(String src, String head, String tail) {
        int h = src.indexOf(head);
        int t = src.lastIndexOf(tail);
        if (h == -1 || t == -1) {
            return src;
        }
        return src.substring(h + 1, t);
    }

    public static void toolError(String s) {
        System.err.println("error: " + s);
    }

    public static void warning(String s) {
        System.err.println("warning: " + s);
    }

    public static void warning(String s, String file, int line) {
        if (file != null) {
            System.err.println(FileLineFormatter.getFormatter().getFormatString(file, line) + "warning:" + s);
        } else {
            System.err.println("warning; line " + line + ": " + s);
        }
    }

    public static void warning(String[] s, String file, int line) {
        if (s == null || s.length == 0) {
            Tool.panic("bad multi-line message to Tool.warning");
        }
        if (file != null) {
            System.err.println(FileLineFormatter.getFormatter().getFormatString(file, line) + "warning:" + s[0]);
            for (int i = 1; i < s.length; ++i) {
                System.err.println(FileLineFormatter.getFormatter().getFormatString(file, line) + s[i]);
            }
        } else {
            System.err.println("warning: line " + line + ": " + s[0]);
            for (int i = 1; i < s.length; ++i) {
                System.err.println("warning: line " + line + ": " + s[i]);
            }
        }
    }

    public void setNameSpace(String name) {
        if (null == nameSpace) {
            nameSpace = new NameSpace(Tool.stripFrontBack(name, "\"", "\""));
        }
    }
}

