/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class VarArgsTest
extends TestCase {
    final int MAGIC32 = 305419896;
    TestLibrary lib;

    protected void setUp() {
        this.lib = (TestLibrary)Native.loadLibrary((String)"testlib", TestLibrary.class);
    }

    protected void tearDown() {
        this.lib = null;
    }

    public void testIntVarArgs() {
        int arg1 = 1;
        int arg2 = 2;
        VarArgsTest.assertEquals((String)"VarArgs not added correctly", (int)(arg1 + arg2), (int)this.lib.addInt32VarArgs("dd", new Integer(arg1), new Integer(arg2)));
    }

    public void testShortVarArgs() {
        short arg1 = 1;
        short arg2 = 2;
        VarArgsTest.assertEquals((String)"VarArgs not added correctly", (int)(arg1 + arg2), (int)this.lib.addInt32VarArgs("dd", new Short(arg1), new Short(arg2)));
    }

    public void testLongVarArgs() {
        int arg1 = 1;
        int arg2 = 2;
        VarArgsTest.assertEquals((String)"VarArgs not added correctly", (int)(arg1 + arg2), (int)this.lib.addInt32VarArgs("ll", new Long(arg1), new Long(arg2)));
    }

    public void testStringVarArgs() {
        Object[] args = new Object[]{"Test"};
        VarArgsTest.assertEquals((String)"Did not return correct string", (Object)args[0], (Object)this.lib.returnStringVarArgs("", args));
    }

    public void testAppendNullToVarargs() {
        Number[] args = new Number[]{new Integer(1)};
        VarArgsTest.assertEquals((String)"No trailing NULL was appended to varargs list", (int)1, (int)this.lib.addInt32VarArgs("dd", args));
    }

    public void testModifyStructureInVarargs() {
        TestLibrary.TestStructure arg1 = new TestLibrary.TestStructure();
        TestLibrary.TestStructure[] varargs = new TestLibrary.TestStructure[]{new TestLibrary.TestStructure()};
        this.lib.modifyStructureVarArgs("ss", (Object)arg1, new Object[]{varargs[0]});
        VarArgsTest.assertEquals((String)"Structure memory not read in fixed arg w/varargs", (int)305419896, (int)arg1.magic);
        VarArgsTest.assertEquals((String)"Structure memory not read in varargs", (int)305419896, (int)varargs[0].magic);
    }

    public static void main(String[] args) {
        TestRunner.run(VarArgsTest.class);
    }

    public static interface TestLibrary
    extends Library {
        public int addInt32VarArgs(String var1, Number ... var2);

        public String returnStringVarArgs(String var1, Object ... var2);

        public void modifyStructureVarArgs(String var1, Object var2, Object ... var3);

        public static class TestStructure
        extends Structure {
            public int magic = 0;

            protected List getFieldOrder() {
                return Arrays.asList("magic");
            }
        }
    }
}

