/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.CallbackReference;
import com.sun.jna.DefaultTypeMapper;
import com.sun.jna.FromNativeContext;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.Function;
import com.sun.jna.IntegerType;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.Structure;
import com.sun.jna.ToNativeContext;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.WString;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class StructureTest
extends TestCase {
    public static void main(String[] argList) {
        TestRunner.run(StructureTest.class);
    }

    public void testSimpleSize() throws Exception {
        class TestStructure
        extends Structure {
            public int field;

            TestStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("field");
            }
        }
        TestStructure s = new TestStructure();
        StructureTest.assertEquals((String)"Wrong size", (int)4, (int)s.size());
    }

    public void testInitializeFromPointer() {
        class TestStructureX
        extends Structure {
            public int field1;
            public int field2;

            protected List getFieldOrder() {
                return Arrays.asList("field1", "field2");
            }

            public TestStructureX() {
            }

            public TestStructureX(Pointer p) {
                super(p);
            }
        }
        TestStructureX s = new TestStructureX();
        Pointer p = s.getPointer();
        TestStructureX s1 = new TestStructureX(p);
        Pointer p1 = s1.getPointer();
        StructureTest.assertEquals((String)"Constructor address not used", (Object)p, (Object)p1);
        StructureTest.assertFalse((String)"Pointer should not be auto-allocated", (boolean)p.getClass().equals(p1.getClass()));
        StructureTest.assertNotSame((String)("Initial pointer should not be used directly: " + p), (Object)p, (Object)p1);
    }

    public void testInitializeWithTypeMapper() {
        DefaultTypeMapper m = new DefaultTypeMapper();
        class TestStructure
        extends Structure {
            public int field;

            protected List getFieldOrder() {
                return Arrays.asList("field");
            }

            public TestStructure(TypeMapper m) {
                super(0, m);
            }
        }
        TestStructure s = new TestStructure((TypeMapper)m);
        StructureTest.assertEquals((String)"Type mapper not installed", (Object)m, (Object)s.getTypeMapper());
    }

    public void testFieldsAllocated() {
        class TestStructure
        extends Structure {
            public int field;

            public TestStructure() {
            }

            public TestStructure(Pointer p) {
                super(p);
            }

            protected List getFieldOrder() {
                return Arrays.asList("field");
            }

            public int fieldCount() {
                this.ensureAllocated();
                return this.fields().size();
            }
        }
        TestStructure s = new TestStructure();
        StructureTest.assertEquals((String)"Wrong number of fields (default)", (int)1, (int)s.fieldCount());
        s = new TestStructure((Pointer)new Memory(4L));
        StructureTest.assertEquals((String)"Wrong number of fields (preallocated)", (int)1, (int)s.fieldCount());
    }

    public void testProvidedMemoryTooSmall() {
        try {
            class TestStructure
            extends Structure {
                public int field;

                public TestStructure(Pointer p) {
                    super(p);
                }

                protected List getFieldOrder() {
                    return Arrays.asList("field");
                }
            }
            new TestStructure((Pointer)new Memory(2L));
            StructureTest.fail((String)"Expect exception if provided memory is insufficient");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testClearOnAllocate() {
        TestAllocStructure s = new TestAllocStructure();
        s.read();
        StructureTest.assertEquals((String)"Memory not cleared on structure init", (int)0, (int)s.f0);
        StructureTest.assertEquals((String)"Memory not cleared on structure init", (int)0, (int)s.f1);
        StructureTest.assertEquals((String)"Memory not cleared on structure init", (int)0, (int)s.f2);
        StructureTest.assertEquals((String)"Memory not cleared on structure init", (int)0, (int)s.f3);
        s = (TestAllocStructure)s.toArray(2)[1];
        StructureTest.assertEquals((String)"Memory not cleared on array init", (int)0, (int)s.f0);
        StructureTest.assertEquals((String)"Memory not cleared on array init", (int)0, (int)s.f1);
        StructureTest.assertEquals((String)"Memory not cleared on array init", (int)0, (int)s.f2);
        StructureTest.assertEquals((String)"Memory not cleared on array init", (int)0, (int)s.f3);
    }

    public void testGNUCAlignment() {
        class TestStructure
        extends Structure {
            public byte b;
            public short s;
            public int i;
            public long l;
            public float f;
            public double d;

            TestStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("b", "s", "i", "l", "f", "d");
            }
        }
        TestStructure s = new TestStructure();
        s.setAlignType(2);
        int SIZE = Structure.MAX_GNUC_ALIGNMENT == 8 ? 32 : 28;
        StructureTest.assertEquals((String)"Wrong structure size", (int)SIZE, (int)s.size());
    }

    public void testMSVCAlignment() {
        class TestStructure
        extends Structure {
            public byte b;
            public short s;
            public int i;
            public long l;
            public float f;
            public double d;

            TestStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("b", "s", "i", "l", "f", "d");
            }
        }
        TestStructure s = new TestStructure();
        s.setAlignType(3);
        StructureTest.assertEquals((String)"Wrong structure size", (int)32, (int)s.size());
    }

    private void testStructureSize(int index) {
        try {
            SizeTest lib = (SizeTest)Native.loadLibrary((String)"testlib", SizeTest.class);
            Class<?> cls = Class.forName(((Object)((Object)this)).getClass().getName() + "$TestStructure" + index);
            Structure s = Structure.newInstance(cls);
            StructureTest.assertEquals((String)("Incorrect size for structure " + index + "=>" + s.toString(true)), (int)lib.getStructureSize(index), (int)s.size());
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public void testStructureSize0() {
        this.testStructureSize(0);
    }

    public void testStructureSize1() {
        this.testStructureSize(1);
    }

    public void testStructureSize2() {
        this.testStructureSize(2);
    }

    public void testStructureSize3() {
        this.testStructureSize(3);
    }

    public void testStructureSize4() {
        this.testStructureSize(4);
    }

    public void testStructureSize5() {
        this.testStructureSize(5);
    }

    private void testAlignStruct(int index) {
        AlignmentTest lib = (AlignmentTest)Native.loadLibrary((String)"testlib", AlignmentTest.class);
        try {
            IntByReference offset = new IntByReference();
            LongByReference value = new LongByReference();
            Class<?> cls = Class.forName(((Object)((Object)this)).getClass().getName() + "$TestStructure" + index);
            Structure s = (Structure)cls.newInstance();
            int result = lib.testStructureAlignment(s, index, offset, value);
            StructureTest.assertEquals((String)("Wrong native value at field " + result + "=0x" + Long.toHexString(value.getValue()) + " (actual native field offset=" + offset.getValue() + ") in " + s), (int)-2, (int)result);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public void testAlignStruct0() {
        this.testAlignStruct(0);
    }

    public void testAlignStruct1() {
        this.testAlignStruct(1);
    }

    public void testAlignStruct2() {
        this.testAlignStruct(2);
    }

    public void testAlignStruct3() {
        this.testAlignStruct(3);
    }

    public void testAlignStruct4() {
        this.testAlignStruct(4);
    }

    public void testAlignStruct5() {
        this.testAlignStruct(5);
    }

    public void testStructureWithNoFields() {
        try {
            class TestStructure
            extends Structure {
                TestStructure() {
                }

                protected List getFieldOrder() {
                    return Arrays.asList(new String[0]);
                }
            }
            new TestStructure();
            StructureTest.fail((String)"Structure should not be instantiable if it has no public member fields");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testStructureWithOnlyNonPublicMemberFields() {
        try {
            class TestStructure
            extends Structure {
                int field;

                TestStructure() {
                }

                protected List getFieldOrder() {
                    return Arrays.asList("field");
                }
            }
            new TestStructure();
            StructureTest.fail((String)"Structure should not be instantiable if it has no public member fields");
        }
        catch (Error error) {
            // empty catch block
        }
    }

    public void testStructureField() {
        class TestStructure
        extends Structure {
            public PublicTestStructure s1;
            public PublicTestStructure s2;
            public int after;

            TestStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("s1", "s2", "after");
            }
        }
        TestStructure s = new TestStructure();
        TestStructure s2 = new TestStructure();
        StructureTest.assertNotNull((String)"Inner structure should be initialized", (Object)((Object)s.s1));
        StructureTest.assertNotNull((String)"Inner structure should be initialized (cached)", (Object)((Object)s2.s1));
        StructureTest.assertEquals((String)"Wrong aggregate size", (int)(s.s1.size() + s.s2.size() + 4), (int)s.size());
        s.write();
        StructureTest.assertEquals((String)"Wrong memory for structure field 1 after write", (Object)s.getPointer(), (Object)s.s1.getPointer());
        StructureTest.assertEquals((String)"Wrong memory for structure field 2 after write", (Object)s.getPointer().share((long)s.s1.size()), (Object)s.s2.getPointer());
        s.read();
        StructureTest.assertEquals((String)"Wrong memory for structure field 1 after read", (Object)s.getPointer(), (Object)s.s1.getPointer());
        StructureTest.assertEquals((String)"Wrong memory for structure field 2 after read", (Object)s.getPointer().share((long)s.s1.size()), (Object)s.s2.getPointer());
    }

    public void testStructureFieldAvoidsSeparateMemoryAllocation() {
        class TestStructure
        extends Structure {
            public NonAllocatingTestStructure s1;

            protected List getFieldOrder() {
                return Arrays.asList("s1");
            }
        }
        TestStructure ts = new TestStructure();
        StructureTest.assertNotNull((String)"Inner structure should be initialized", (Object)((Object)ts.s1));
    }

    public void testPrimitiveArrayField() {
        class TestStructure
        extends Structure {
            public byte[] buffer = new byte[1024];

            TestStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("buffer");
            }
        }
        TestStructure s = new TestStructure();
        TestStructure s2 = new TestStructure();
        StructureTest.assertEquals((String)"Wrong size for structure with nested array", (int)1024, (int)s.size());
        StructureTest.assertEquals((String)"Wrong size for structure with nested array (cached)", (int)1024, (int)s2.size());
        StructureTest.assertNotNull((String)"Array should be initialized", (Object)s.buffer);
        StructureTest.assertNotNull((String)"Array should be initialized (cached)", (Object)s2.buffer);
        s.write();
        s.read();
    }

    public void testStructureArrayField() {
        class TestStructure
        extends Structure {
            public PublicTestStructure[] inner = new PublicTestStructure[2];
            public PublicTestStructure[] inner2 = (PublicTestStructure[])new PublicTestStructure().toArray(2);

            TestStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("inner", "inner2");
            }
        }
        TestStructure s = new TestStructure();
        int innerSize = new PublicTestStructure().size();
        StructureTest.assertEquals((String)"Wrong size for structure with nested array of struct", (int)(s.inner.length * innerSize + s.inner2.length * innerSize), (int)s.size());
        PublicTestStructure s0 = s.inner2[0];
        PublicTestStructure s1 = s.inner2[1];
        s.write();
        StructureTest.assertNotNull((String)"Inner array elements should auto-initialize after write", (Object)((Object)s.inner[0]));
        StructureTest.assertSame((String)"Inner array (2) element 0 reference should not be changed after write", (Object)((Object)s0), (Object)((Object)s.inner2[0]));
        StructureTest.assertSame((String)"Inner array (2) element 1 reference should not be changed after write", (Object)((Object)s1), (Object)((Object)s.inner2[1]));
        s.inner[1].x = -1;
        s.inner[0].x = -1;
        s.inner2[1].x = -1;
        s.inner2[0].x = -1;
        s.read();
        StructureTest.assertEquals((String)"Inner structure array element 0 not properly read", (int)0, (int)s.inner[0].x);
        StructureTest.assertEquals((String)"Inner structure array element 1 not properly read", (int)0, (int)s.inner[1].x);
        StructureTest.assertEquals((String)"Inner structure array (2) element 0 not properly read", (int)1, (int)s.inner2[0].x);
        StructureTest.assertEquals((String)"Inner structure array (2) element 1 not properly read", (int)0, (int)s.inner2[1].x);
        StructureTest.assertEquals((String)"Wrong memory for uninitialized nested array", (Object)s.getPointer(), (Object)s.inner[0].getPointer());
        StructureTest.assertEquals((String)"Wrong memory for initialized nested array", (Object)s.getPointer().share((long)(innerSize * s.inner.length)), (Object)s.inner2[0].getPointer());
    }

    public void testToArrayWithStructureArrayField() {
        ToArrayTestStructure[] array = (ToArrayTestStructure[])new ToArrayTestStructure().toArray(2);
        StructureTest.assertEquals((String)"Wrong address for top-level array element", (Object)array[0].getPointer().share((long)array[0].size()), (Object)array[1].getPointer());
        StructureTest.assertEquals((String)"Wrong address for nested array element", (Object)array[1].inner[0].getPointer().share((long)array[1].inner[0].size()), (Object)array[1].inner[1].getPointer());
    }

    public void testUninitializedNestedArrayFails() {
        class TestStructure
        extends Structure {
            public Pointer[] buffer;

            TestStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("buffer");
            }
        }
        TestStructure s = new TestStructure();
        try {
            s.size();
            StructureTest.fail((String)"Size can't be calculated unless array fields are initialized");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testReadWriteStructure() {
        class TestStructure
        extends Structure {
            public boolean z;
            public byte b;
            public char c;
            public short s;
            public int i;
            public long l;
            public float f;
            public double d;
            public byte[] ba = new byte[3];
            public char[] ca = new char[3];
            public short[] sa = new short[3];
            public int[] ia = new int[3];
            public long[] la = new long[3];
            public float[] fa = new float[3];
            public double[] da = new double[3];
            public PublicTestStructure nested;

            public TestStructure() {
                this.allocateMemory();
            }

            protected List getFieldOrder() {
                return Arrays.asList("z", "b", "c", "s", "i", "l", "f", "d", "ba", "ca", "sa", "ia", "la", "fa", "da", "nested");
            }
        }
        TestStructure s = new TestStructure();
        s.z = true;
        s.b = 1;
        s.c = (char)2;
        s.s = (short)3;
        s.i = 4;
        s.l = 5L;
        s.f = 6.0f;
        s.d = 7.0;
        s.nested.x = 1;
        s.nested.y = 2;
        for (int i = 0; i < 3; ++i) {
            s.ba[i] = (byte)(8 + i);
            s.ca[i] = (char)(11 + i);
            s.sa[i] = (short)(14 + i);
            s.ia[i] = 17 + i;
            s.la[i] = 23 + i;
            s.fa[i] = 26.0f + (float)i;
            s.da[i] = 29.0 + (double)i;
        }
        s.write();
        Pointer p = s.getPointer();
        s = new TestStructure();
        s.useMemory(p);
        s.read();
        StructureTest.assertEquals((String)"Wrong boolean field value after write/read", (boolean)s.z, (boolean)true);
        StructureTest.assertEquals((String)"Wrong byte field value after write/read", (int)s.b, (int)1);
        StructureTest.assertEquals((String)"Wrong char field value after write/read", (int)s.c, (int)2);
        StructureTest.assertEquals((String)"Wrong short field value after write/read", (int)s.s, (int)3);
        StructureTest.assertEquals((String)"Wrong int field value after write/read", (int)s.i, (int)4);
        StructureTest.assertEquals((String)"Wrong long field value after write/read", (long)s.l, (long)5L);
        StructureTest.assertEquals((String)"Wrong float field value after write/read", (float)s.f, (float)6.0f, (float)0.0f);
        StructureTest.assertEquals((String)"Wrong double field value after write/read", (double)s.d, (double)7.0, (double)0.0);
        StructureTest.assertEquals((String)"Wrong nested struct field value after write/read (x)", (int)s.nested.x, (int)1);
        StructureTest.assertEquals((String)"Wrong nested struct field value after write/read (y)", (int)s.nested.y, (int)2);
        for (int i = 0; i < 3; ++i) {
            StructureTest.assertEquals((String)"Wrong byte array field value after write/read", (byte)s.ba[i], (byte)((byte)(8 + i)));
            StructureTest.assertEquals((String)"Wrong char array field value after write/read", (char)s.ca[i], (char)((char)(11 + i)));
            StructureTest.assertEquals((String)"Wrong short array field value after write/read", (short)s.sa[i], (short)((short)(14 + i)));
            StructureTest.assertEquals((String)"Wrong int array field value after write/read", (int)s.ia[i], (int)(17 + i));
            StructureTest.assertEquals((String)"Wrong long array field value after write/read", (long)s.la[i], (long)(23 + i));
            StructureTest.assertEquals((String)"Wrong float array field value after write/read", (float)s.fa[i], (float)(26.0f + (float)i), (float)0.0f);
            StructureTest.assertEquals((String)"Wrong double array field value after write/read", (double)s.da[i], (double)(29.0 + (double)i), (double)0.0);
        }
        int[] ia = s.ia;
        s.read();
        StructureTest.assertTrue((String)"Array field reference should be unchanged", (ia == s.ia ? 1 : 0) != 0);
    }

    public void testNativeLongSize() throws Exception {
        class TestStructure
        extends Structure {
            public NativeLong l;

            TestStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("l");
            }
        }
        TestStructure s = new TestStructure();
        StructureTest.assertEquals((String)"Wrong size", (int)NativeLong.SIZE, (int)s.size());
    }

    public void testNativeLongRead() throws Exception {
        class TestStructure
        extends Structure {
            public int i;
            public NativeLong l;

            TestStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("i", "l");
            }
        }
        TestStructure s = new TestStructure();
        if (NativeLong.SIZE == 8) {
            long MAGIC = 1311768467139281697L;
            s.getPointer().setLong(8L, 1311768467139281697L);
            s.read();
            StructureTest.assertEquals((String)"NativeLong field mismatch", (long)1311768467139281697L, (long)s.l.longValue());
        } else {
            int MAGIC = -1410478301;
            s.getPointer().setInt(4L, -1410478301);
            s.read();
            StructureTest.assertEquals((String)"NativeLong field mismatch", (int)-1410478301, (int)s.l.intValue());
        }
    }

    public void testNativeLongWrite() throws Exception {
        class TestStructure
        extends Structure {
            public int i;
            public NativeLong l;

            TestStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("i", "l");
            }
        }
        TestStructure s = new TestStructure();
        if (NativeLong.SIZE == 8) {
            long MAGIC = 1311768467139281697L;
            s.l = new NativeLong(1311768467139281697L);
            s.write();
            long l = s.getPointer().getLong(8L);
            StructureTest.assertEquals((String)"NativeLong field mismatch", (long)1311768467139281697L, (long)l);
        } else {
            int MAGIC = -1410478301;
            s.l = new NativeLong(-1410478301L);
            s.write();
            int i = s.getPointer().getInt(4L);
            StructureTest.assertEquals((String)"NativeLong field mismatch", (int)-1410478301, (int)i);
        }
    }

    public void testMemoryField() {
        class MemoryFieldStructure
        extends Structure {
            public Memory m;

            MemoryFieldStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("m");
            }
        }
        new MemoryFieldStructure().size();
    }

    public void testDisallowFunctionPointerAsField() {
        try {
            class BadFieldStructure
            extends Structure {
                public Function cb;

                BadFieldStructure() {
                }

                protected List getFieldOrder() {
                    return Arrays.asList("cb");
                }
            }
            new BadFieldStructure().size();
            StructureTest.fail((String)"Function fields should not be allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testUnsupportedField() {
        class BadNestedStructure
        extends Structure {
            public BadFieldStructure badStruct = new BadFieldStructure();

            BadNestedStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("badStruct");
            }
        }
        try {
            new BadFieldStructure();
            StructureTest.fail((String)"Should throw IllegalArgumentException on bad field");
        }
        catch (IllegalArgumentException e) {
            StructureTest.assertTrue((String)("Exception should include field name: " + e), (e.getMessage().indexOf("badField") != -1 ? 1 : 0) != 0);
        }
        try {
            new BadNestedStructure();
            StructureTest.fail((String)"Should throw IllegalArgumentException on bad field");
        }
        catch (IllegalArgumentException e) {
            StructureTest.assertTrue((String)("Exception should include enclosing type: " + e), (e.getMessage().indexOf(BadNestedStructure.class.getName()) != -1 ? 1 : 0) != 0);
            StructureTest.assertTrue((String)("Exception should include nested field name: " + e), (e.getMessage().indexOf("badStruct") != -1 ? 1 : 0) != 0);
            StructureTest.assertTrue((String)("Exception should include field name: " + e), (e.getMessage().indexOf("badField") != -1 ? 1 : 0) != 0);
        }
    }

    public void testToArray() {
        int[] allocated = new int[]{0};
        PublicTestStructure.allocations = 0;
        PublicTestStructure s = new PublicTestStructure();
        PublicTestStructure[] array = (PublicTestStructure[])s.toArray(1);
        StructureTest.assertEquals((String)"Array should consist of a single element", (int)1, (int)array.length);
        StructureTest.assertEquals((String)"First element should be original", (Object)((Object)s), (Object)((Object)array[0]));
        array = (PublicTestStructure[])s.toArray(2);
        StructureTest.assertEquals((String)"Structure memory should be expanded", (int)2, (int)array.length);
        StructureTest.assertEquals((String)"No memory should be allocated for new element", (int)1, (int)PublicTestStructure.allocations);
        StructureTest.assertEquals((String)"Structure.read called on New element", (int)0, (int)array[1].x);
    }

    public void testByReferenceArraySync() {
        PublicTestStructure.ByReference s = new PublicTestStructure.ByReference();
        PublicTestStructure.ByReference[] array = (PublicTestStructure.ByReference[])s.toArray(2);
        class TestStructure
        extends Structure {
            public PublicTestStructure.ByReference ref;

            TestStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("ref");
            }
        }
        TestStructure ts = new TestStructure();
        ts.ref = s;
        int VALUE = 42;
        array[0].x = 42;
        array[1].x = 42;
        ts.write();
        StructureTest.assertEquals((String)("Array element not written: " + (Object)((Object)array[0])), (int)42, (int)array[0].getPointer().getInt(0L));
        StructureTest.assertEquals((String)("Array element not written: " + (Object)((Object)array[1])), (int)42, (int)array[1].getPointer().getInt(0L));
        array[0].getPointer().setInt(4L, 42);
        array[1].getPointer().setInt(4L, 42);
        ts.read();
        StructureTest.assertEquals((String)("Array element not read: " + (Object)((Object)array[0])), (int)42, (int)array[0].y);
        StructureTest.assertEquals((String)("Array element not read: " + (Object)((Object)array[1])), (int)42, (int)array[1].y);
    }

    public void testCallbackWrite() {
        CbStruct s = new CbStruct();
        s.cb = new Callback(){

            public void callback() {
            }
        };
        s.write();
        Pointer func = s.getPointer().getPointer(0L);
        StructureTest.assertNotNull((String)"Callback trampoline not set", (Object)func);
        Map refs = CallbackReference.callbackMap;
        StructureTest.assertTrue((String)"Callback not cached", (boolean)refs.containsKey(s.cb));
        CallbackReference ref = (CallbackReference)refs.get(s.cb);
        StructureTest.assertEquals((String)"Wrong trampoline", (Object)ref.getTrampoline(), (Object)func);
    }

    public void testUninitializedArrayField() {
        try {
            class UninitializedArrayFieldStructure
            extends Structure {
                public byte[] array;

                UninitializedArrayFieldStructure() {
                }

                protected List getFieldOrder() {
                    return Arrays.asList("array");
                }
            }
            UninitializedArrayFieldStructure s = new UninitializedArrayFieldStructure();
            StructureTest.assertTrue((String)("Invalid size: " + s.size()), (s.size() > 0 ? 1 : 0) != 0);
            StructureTest.fail((String)"Uninitialized array field should cause write failure");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testPlainStructureArrayField() {
        try {
            new StructureWithArrayOfStructureField();
            StructureTest.fail((String)"Structure[] should not be allowed as a field of Structure");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            StructureTest.fail((String)("Wrong exception thrown when Structure[] field encountered in a Structure: " + e));
        }
    }

    public void testPointerArrayField() {
        class ArrayOfPointerStructure
        extends Structure {
            static final int SIZE = 10;
            public Pointer[] array = new Pointer[10];

            ArrayOfPointerStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("array");
            }
        }
        ArrayOfPointerStructure s = new ArrayOfPointerStructure();
        int size = s.size();
        StructureTest.assertEquals((String)"Wrong size", (int)(10 * Pointer.SIZE), (int)size);
        s.array[0] = s.getPointer();
        s.write();
        s.array[0] = null;
        s.read();
        StructureTest.assertEquals((String)"Wrong first element", (Object)s.getPointer(), (Object)s.array[0]);
    }

    public void testVolatileStructureField() {
        class VolatileStructure
        extends Structure {
            public volatile int counter;
            public int value;

            VolatileStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("counter", "value");
            }
        }
        VolatileStructure s = new VolatileStructure();
        s.counter = 1;
        s.value = 1;
        s.write();
        StructureTest.assertEquals((String)"Volatile field should not be written", (int)0, (int)s.getPointer().getInt(0L));
        StructureTest.assertEquals((String)"Non-volatile field should be written", (int)1, (int)s.getPointer().getInt(4L));
        s.writeField("counter");
        StructureTest.assertEquals((String)"Explicit volatile field write failed", (int)1, (int)s.getPointer().getInt(0L));
    }

    public void testStructureByReferenceField() {
        StructureWithPointers s = new StructureWithPointers();
        StructureTest.assertEquals((String)"Wrong size for structure with structure references", (int)(Pointer.SIZE * 2), (int)s.size());
        StructureTest.assertNull((String)"Initial refs should be null", (Object)((Object)s.s1));
    }

    public void testRegenerateStructureByReferenceField() {
        StructureWithPointers s = new StructureWithPointers();
        PublicTestStructure.ByReference inner = new PublicTestStructure.ByReference();
        PublicTestStructure.allocations = 0;
        s.s1 = inner;
        s.write();
        s.s1 = null;
        s.read();
        StructureTest.assertEquals((String)"Inner structure not regenerated on read", (Object)((Object)inner), (Object)((Object)s.s1));
        StructureTest.assertEquals((String)"Inner structure should not allocate memory", (int)0, (int)PublicTestStructure.allocations);
    }

    public void testPreserveStructureByReferenceWithUnchangedPointerOnRead() {
        PublicTestStructure.ByReference inner;
        StructureWithPointers s = new StructureWithPointers();
        s.s1 = inner = new PublicTestStructure.ByReference();
        s.write();
        s.read();
        StructureTest.assertSame((String)"Read should preserve structure object", (Object)((Object)inner), (Object)((Object)s.s1));
        StructureTest.assertTrue((String)"Read should preserve structure memory", (boolean)(inner.getPointer() instanceof Memory));
    }

    public void testPreservePointerFields() {
        class TestStructure
        extends Structure {
            public Pointer p = new Memory(256L);
            public TestPointer p2 = new TestPointer(){
                {
                    this.setPointer((Pointer)new Memory(256L));
                }
            };

            TestStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("p", "p2");
            }
        }
        TestStructure s = new TestStructure();
        Pointer p = s.p;
        TestPointer p2 = s.p2;
        s.write();
        s.read();
        StructureTest.assertSame((String)"Should preserve Pointer references if peer unchanged", (Object)p, (Object)s.p);
        StructureTest.assertSame((String)"Should preserve PointerType references if peer unchanged", (Object)((Object)p2), (Object)((Object)s.p2));
    }

    public void testPreserveStringFields() {
        class TestStructure
        extends Structure {
            public String s;
            public WString ws;

            TestStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("s", "ws");
            }
        }
        TestStructure s = new TestStructure();
        Memory m = new Memory((long)(this.getName().length() + 1));
        m.setString(0L, this.getName());
        Memory m2 = new Memory((long)((this.getName().length() + 1) * Native.WCHAR_SIZE));
        m2.setString(0L, this.getName(), true);
        s.getPointer().setPointer(0L, (Pointer)m);
        s.getPointer().setPointer((long)Pointer.SIZE, (Pointer)m2);
        s.read();
        StructureTest.assertEquals((String)"Wrong String field value", (String)this.getName(), (String)s.s);
        StructureTest.assertEquals((String)"Wrong WString field value", (Object)new WString(this.getName()), (Object)s.ws);
        s.write();
        StructureTest.assertEquals((String)"String field should not be overwritten", (Object)m, (Object)s.getPointer().getPointer(0L));
        StructureTest.assertEquals((String)"String field should not be overwritten", (Object)m2, (Object)s.getPointer().getPointer((long)Pointer.SIZE));
    }

    public void testInitializeStructureFieldWithStrings() {
        StructureFromNative o = new StructureFromNative();
        o.s = this.getName();
        o.write();
        StructureFromNative t = new StructureFromNative(o.getPointer());
        StructureTest.assertEquals((String)"String field not initialized", (String)this.getName(), (String)t.s);
        class ContainingStructure
        extends Structure {
            public StructureFromNative inner;

            ContainingStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("inner");
            }
        }
        ContainingStructure outer = new ContainingStructure();
        outer.inner = t;
        outer.write();
        StructureTest.assertEquals((String)"Inner String field corrupted", (String)this.getName(), (String)outer.inner.s);
        outer.inner.read();
        StructureTest.assertEquals((String)"Native memory behind Inner String field not updated", (String)this.getName(), (String)outer.inner.s);
    }

    public void testOverwriteStructureByReferenceFieldOnRead() {
        PublicTestStructure.ByReference inner2;
        StructureWithPointers s = new StructureWithPointers();
        PublicTestStructure.ByReference inner = new PublicTestStructure.ByReference();
        s.s1 = inner2 = new PublicTestStructure.ByReference();
        s.write();
        s.s1 = inner;
        s.read();
        StructureTest.assertNotSame((String)"Read should overwrite structure reference", (Object)((Object)inner), (Object)((Object)s.s1));
    }

    public void testAutoWriteStructureByReferenceField() {
        StructureWithPointers s = new StructureWithPointers();
        s.s1 = new PublicTestStructure.ByReference();
        s.s1.x = -1;
        s.write();
        StructureTest.assertEquals((String)"Structure.ByReference field not written automatically", (int)-1, (int)s.s1.getPointer().getInt(0L));
    }

    public void testStructureByReferenceArrayField() {
        class TestStructure
        extends Structure {
            public PublicTestStructure.ByReference[] array = new PublicTestStructure.ByReference[2];

            TestStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("array");
            }
        }
        TestStructure s = new TestStructure();
        StructureTest.assertEquals((String)"Wrong structure size", (int)(2 * Pointer.SIZE), (int)s.size());
        PublicTestStructure.ByReference ref = new PublicTestStructure.ByReference();
        ref.x = 42;
        PublicTestStructure.ByReference[] aref = s.array;
        s.array[0] = ref;
        s.array[1] = new PublicTestStructure.ByReference();
        s.write();
        s.read();
        StructureTest.assertSame((String)"Array reference should not change", (Object)aref, (Object)s.array);
        StructureTest.assertSame((String)"Elements should not be overwritten when unchanged", (Object)((Object)ref), (Object)((Object)s.array[0]));
        s.array[0] = null;
        s.read();
        StructureTest.assertNotSame((String)"Null should be overwritten with a new ref", (Object)((Object)ref), (Object)((Object)s.array[0]));
        StructureTest.assertNotNull((String)"New ref should not be null", (Object)((Object)s.array[0]));
        StructureTest.assertEquals((String)"New ref should be equivalent", (Object)((Object)ref), (Object)((Object)s.array[0]));
    }

    public void testAutoReadWriteStructureByReferenceArrayField() {
        class TestStructure
        extends Structure {
            public PublicTestStructure.ByReference field;

            TestStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("field");
            }
        }
        TestStructure s = new TestStructure();
        s.field = new PublicTestStructure.ByReference();
        PublicTestStructure.ByReference[] array = (PublicTestStructure.ByReference[])s.field.toArray(2);
        int VALUE = -1;
        array[1].x = -1;
        s.write();
        StructureTest.assertEquals((String)"ByReference array member not auto-written", (int)-1, (int)array[1].getPointer().getInt(0L));
        array[1].getPointer().setInt(0L, -2);
        s.read();
        StructureTest.assertEquals((String)"ByReference array member not auto-read", (int)-2, (int)array[1].x);
    }

    public void testNestedStructureTypeInfo() {
        NestedTypeInfoStructure s = new NestedTypeInfoStructure();
        Pointer p = s.getTypeInfo();
        StructureTest.assertNotNull((String)"Type info should not be null", (Object)p);
        TestFFIType ffi_type = new TestFFIType(p);
        StructureTest.assertEquals((String)("FFIType size mismatch: " + (Object)((Object)ffi_type)), (int)s.size(), (int)ffi_type.size.intValue());
        Pointer els = ffi_type.elements;
        Pointer inner = s.inner.getTypeInfo();
        StructureTest.assertEquals((String)"Wrong type information for 'inner' field", (Object)inner, (Object)els.getPointer(0L));
        StructureTest.assertEquals((String)"Wrong type information for integer field", (Object)Structure.getTypeInfo((Object)new Integer(0)), (Object)els.getPointer((long)Pointer.SIZE));
        StructureTest.assertNull((String)"Type element list should be null-terminated", (Object)els.getPointer((long)(Pointer.SIZE * 2)));
    }

    public void testInnerArrayTypeInfo() {
        class TestStructure
        extends Structure {
            public int[] inner = new int[5];

            TestStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("inner");
            }
        }
        TestStructure s = new TestStructure();
        Pointer p = s.getTypeInfo();
        StructureTest.assertNotNull((String)"Type info should not be null", (Object)p);
        TestFFIType ffi_type = new TestFFIType(p);
        StructureTest.assertEquals((String)"Wrong structure size", (int)20, (int)s.size());
        StructureTest.assertEquals((String)"FFIType info size mismatch", (int)s.size(), (int)ffi_type.size.intValue());
    }

    public void testTypeInfoForNull() {
        StructureTest.assertEquals((String)"Wrong type information for 'null'", (Object)Structure.getTypeInfo((Object)new Pointer(0L)), (Object)Structure.getTypeInfo(null));
    }

    public void testToString() {
        if (Platform.isWindowsCE()) {
            return;
        }
        class TestStructure
        extends Structure {
            public int intField;
            public PublicTestStructure inner;

            TestStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("intField", "inner");
            }
        }
        TestStructure s = new TestStructure();
        String LS = System.getProperty("line.separator");
        System.setProperty("jna.dump_memory", "true");
        String EXPECTED = "(?m).*" + s.size() + " bytes.*\\{" + LS + "  int intField@0=0" + LS + "  .* inner@4=.*\\{" + LS + "    int x@0=.*" + LS + "    int y@4=.*" + LS + "  \\}" + LS + "\\}" + LS + "memory dump" + LS + "\\[[0-9a-f]+\\]" + LS + "\\[[0-9a-f]+\\]" + LS + "\\[[0-9a-f]+\\]";
        String actual = s.toString();
        StructureTest.assertTrue((String)("Improperly formatted toString(): expected " + EXPECTED + "\n" + actual), (boolean)actual.matches(EXPECTED));
    }

    public void testNativeMappedWrite() {
        class TestStructure
        extends Structure {
            public ByteByReference ref;

            TestStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("ref");
            }
        }
        TestStructure s = new TestStructure();
        ByteByReference ref = s.ref = new ByteByReference();
        s.write();
        StructureTest.assertEquals((String)"Value not properly written", (Object)ref.getPointer(), (Object)s.getPointer().getPointer(0L));
        s.ref = null;
        s.write();
        StructureTest.assertNull((String)("Non-null value was written: " + s.getPointer().getPointer(0L)), (Object)s.getPointer().getPointer(0L));
    }

    public void testNativeMappedRead() {
        class TestStructure
        extends Structure {
            public ByteByReference ref;

            TestStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("ref");
            }
        }
        TestStructure s = new TestStructure();
        s.read();
        StructureTest.assertNull((String)"Should read null for initial field value", (Object)s.ref);
        ByteByReference ref = new ByteByReference();
        s.getPointer().setPointer(0L, ref.getPointer());
        s.read();
        StructureTest.assertEquals((String)"Field incorrectly read", (Object)ref, (Object)s.ref);
        s.getPointer().setPointer(0L, null);
        s.read();
        StructureTest.assertNull((String)"Null field incorrectly read", (Object)s.ref);
    }

    private ROStructure avoidConstantFieldOptimization(ROStructure s) {
        return s;
    }

    public void testReadOnlyField() {
        if (!Platform.RO_FIELDS) {
            try {
                new ROStructure();
                StructureTest.fail((String)"Creation of a Structure with final fields should fail");
            }
            catch (Exception e) {
                // empty catch block
            }
            return;
        }
        ROStructure s = new ROStructure();
        s.getPointer().setInt(0L, 42);
        s.read();
        s = this.avoidConstantFieldOptimization(s);
        StructureTest.assertEquals((String)"Field value should be set from native", (int)42, (int)s.field);
        s.getPointer().setInt(0L, 0);
        s.read();
        s = this.avoidConstantFieldOptimization(s);
        StructureTest.assertEquals((String)"Field value not synched after native change", (int)0, (int)s.field);
        s.getPointer().setInt(0L, 42);
        try {
            s.write();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        StructureTest.assertEquals((String)"Field should not be written", (int)42, (int)s.getPointer().getInt(0L));
        s.read();
        s = this.avoidConstantFieldOptimization(s);
        StructureTest.assertEquals((String)"Field value not synched after native change (2)", (int)42, (int)s.field);
    }

    public void testNativeMappedArrayField() {
        int i;
        int SIZE = 24;
        class TestStructure
        extends Structure {
            public NativeLong[] longs = new NativeLong[24];

            TestStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("longs");
            }
        }
        TestStructure s = new TestStructure();
        StructureTest.assertEquals((String)"Wrong structure size", (int)(Native.LONG_SIZE * 24), (int)s.size());
        NativeLong[] aref = s.longs;
        for (i = 0; i < s.longs.length; ++i) {
            s.longs[i] = new NativeLong((long)i);
        }
        s.write();
        for (i = 0; i < s.longs.length; ++i) {
            StructureTest.assertEquals((String)("Value not written to memory at index " + i), (int)i, (int)s.getPointer().getNativeLong((long)(i * NativeLong.SIZE)).intValue());
        }
        s.read();
        StructureTest.assertEquals((String)"Array reference should remain unchanged on read", (Object)aref, (Object)s.longs);
        for (i = 0; i < s.longs.length; ++i) {
            StructureTest.assertEquals((String)("Wrong value after read at index " + i), (int)i, (int)s.longs[i].intValue());
        }
    }

    public void testInitializeNativeMappedField() {
        long VALUE = 20L;
        final NativeLong INITIAL = new NativeLong(20L);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class TestStructure
        extends Structure {
            public NativeLong nl;
            public NativeLong uninitialized;

            TestStructure() {
                this.setAlignType(1);
                this.nl = INITIAL;
            }

            protected List getFieldOrder() {
                return Arrays.asList("nl", "uninitialized");
            }
        }
        TestStructure ts = new TestStructure();
        TestStructure ts2 = new TestStructure();
        StructureTest.assertEquals((String)"Wrong value in field", (long)20L, (long)ts.nl.longValue());
        StructureTest.assertSame((String)"Initial value overwritten", (Object)INITIAL, (Object)ts.nl);
        StructureTest.assertEquals((String)"Wrong field value before write", (long)20L, (long)ts.nl.longValue());
        StructureTest.assertNotNull((String)"Uninitialized field should be initialized", (Object)ts.uninitialized);
        StructureTest.assertNotNull((String)"Uninitialized field should be initialized (cached)", (Object)ts2.uninitialized);
        StructureTest.assertEquals((String)"Wrong initialized value", (long)0L, (long)ts.uninitialized.longValue());
        ts.write();
        StructureTest.assertEquals((String)"Wrong field value written", (long)20L, (long)ts.getPointer().getNativeLong(0L).longValue());
        StructureTest.assertEquals((String)"Wrong field value written (2)", (long)0L, (long)ts.getPointer().getNativeLong((long)NativeLong.SIZE).longValue());
        ts.read();
        StructureTest.assertEquals((String)"Wrong field value", (long)20L, (long)ts.nl.longValue());
        StructureTest.assertEquals((String)"Wrong field value (2)", (long)0L, (long)ts.uninitialized.longValue());
    }

    public void testThrowErrorOnMissingFieldOrderOnDerivedStructure() {
        try {
            class TestStructure2
            extends 29TestStructure {
                public int f3;

                TestStructure2() {
                    class TestStructure
                    extends Structure {
                        public int f1;
                        public int f2;

                        TestStructure() {
                        }

                        protected List getFieldOrder() {
                            return Arrays.asList("f1", "f2");
                        }
                    }
                }
            }
            new TestStructure2();
            StructureTest.fail((String)"Expected an error when structure fails to provide field order");
        }
        catch (Error error) {
            // empty catch block
        }
    }

    public void testThrowErrorOnIncorrectFieldOrderNameMismatch() {
        try {
            class TestStructure
            extends Structure {
                public int f1;
                public int f2;

                TestStructure() {
                }

                protected List getFieldOrder() {
                    return Arrays.asList("F1", "F2");
                }
            }
            new TestStructure();
            StructureTest.fail((String)"Expected an error when creating a structure without mismatched field names");
        }
        catch (Error error) {
            // empty catch block
        }
    }

    public void testThrowErrorOnIncorrectFieldOrderCount() {
        try {
            class TestStructure
            extends Structure {
                public int f1;
                public int f2;

                TestStructure() {
                }

                protected List getFieldOrder() {
                    return Arrays.asList("f1", "f2", "f3");
                }
            }
            new TestStructure();
            StructureTest.fail((String)"Expected an error when creating a structure with wrong number of fiels in getFieldOrder()");
        }
        catch (Error error) {
            // empty catch block
        }
    }

    public void testInheritedStructureFieldOrder() {
        class TestStructureSub
        extends 32TestStructure {
            public int second;

            TestStructureSub() {
                class TestStructure
                extends Structure {
                    public int first = 1;

                    TestStructure() {
                    }

                    protected List getFieldOrder() {
                        return Arrays.asList("first");
                    }
                }
                this.second = 2;
            }

            protected List getFieldOrder() {
                ArrayList<String> list = new ArrayList<String>(super.getFieldOrder());
                list.addAll(Arrays.asList("second"));
                return list;
            }
        }
        TestStructureSub s = new TestStructureSub();
        StructureTest.assertEquals((String)"Wrong size", (int)8, (int)s.size());
        s.write();
        StructureTest.assertEquals((String)("Wrong first field: " + (Object)((Object)s)), (int)s.first, (int)s.getPointer().getInt(0L));
        StructureTest.assertEquals((String)("Wrong second field: " + (Object)((Object)s)), (int)s.second, (int)s.getPointer().getInt(4L));
    }

    public void testVariedStructureFieldOrder() {
        final String[] ORDER = new String[]{"one", "two", "three"};
        String[] ORDER2 = new String[]{"one", "two", "three", "four", "five"};
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class TestStructure
        extends Structure {
            public int one = 1;
            public int three = 3;
            public int two = 2;

            TestStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList(ORDER);
            }
        }
        TestStructure s = new TestStructure();
        StructureTest.assertEquals((String)"Wrong field order", Arrays.asList(ORDER), (Object)s.getFieldOrder());
        s.write();
        StructureTest.assertEquals((String)("Wrong first field: " + (Object)((Object)s)), (int)s.one, (int)s.getPointer().getInt(0L));
        StructureTest.assertEquals((String)("Wrong second field: " + (Object)((Object)s)), (int)s.two, (int)s.getPointer().getInt(4L));
        StructureTest.assertEquals((String)("Wrong third field: " + (Object)((Object)s)), (int)s.three, (int)s.getPointer().getInt(8L));
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class DerivedTestStructure
        extends TestStructure {
            public int five;
            public int four;

            DerivedTestStructure() {
                super(StructureTest.this, stringArray);
                this.five = 5;
                this.four = 4;
            }

            @Override
            protected List getFieldOrder() {
                ArrayList<String> list = new ArrayList<String>(super.getFieldOrder());
                list.addAll(Arrays.asList("four", "five"));
                return list;
            }
        }
        DerivedTestStructure s2 = new DerivedTestStructure();
        StructureTest.assertEquals((String)"Wrong field order", Arrays.asList(ORDER2), (Object)s2.getFieldOrder());
        s2.write();
        StructureTest.assertEquals((String)("Wrong first field: " + (Object)((Object)s2)), (int)s2.one, (int)s2.getPointer().getInt(0L));
        StructureTest.assertEquals((String)("Wrong second field: " + (Object)((Object)s2)), (int)s2.two, (int)s2.getPointer().getInt(4L));
        StructureTest.assertEquals((String)("Wrong third field: " + (Object)((Object)s2)), (int)s2.three, (int)s2.getPointer().getInt(8L));
        StructureTest.assertEquals((String)("Wrong derived field (1): " + (Object)((Object)s2)), (int)s2.four, (int)s2.getPointer().getInt(12L));
        StructureTest.assertEquals((String)("Wrong derived field (2): " + (Object)((Object)s2)), (int)s2.five, (int)s2.getPointer().getInt(16L));
    }

    public void testCustomTypeMapper() {
        final DefaultTypeMapper mapper = new DefaultTypeMapper(){
            {
                class 1TestField {
                    1TestField() {
                    }
                }
                this.addTypeConverter(1TestField.class, new TypeConverter(){

                    public Object fromNative(Object value, FromNativeContext context) {
                        return new TestField();
                    }

                    public Class nativeType() {
                        return String.class;
                    }

                    public Object toNative(Object value, ToNativeContext ctx) {
                        return value == null ? null : value.toString();
                    }
                });
            }
        };
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class TestStructure
        extends Structure {
            public 1TestField field;

            public TestStructure() {
                super((TypeMapper)defaultTypeMapper);
            }

            protected List getFieldOrder() {
                return Arrays.asList("field");
            }
        }
        TestStructure s = new TestStructure();
        StructureTest.assertEquals((String)("Wrong type mapper: " + (Object)((Object)s)), (Object)mapper, (Object)s.getTypeMapper());
    }

    public void testWriteWithNullBoxedPrimitives() {
        class TestStructure
        extends Structure {
            public Boolean zfield;
            public Integer field;

            TestStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("zfield", "field");
            }
        }
        TestStructure s = new TestStructure();
        s.write();
        s.read();
        StructureTest.assertNotNull((String)"Field should not be null after read", (Object)s.field);
    }

    public void testStructureEquals() {
        int VALUE;
        class OtherStructure
        extends Structure {
            public int first;
            public int[] second = new int[4];
            public Pointer[] third = new Pointer[4];

            OtherStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("first", "second", "third");
            }
        }
        OtherStructure s0 = new OtherStructure();
        class TestStructure
        extends Structure {
            public int first;
            public int[] second = new int[4];
            public Pointer[] third = new Pointer[4];

            TestStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("first", "second", "third");
            }
        }
        TestStructure s1 = new TestStructure();
        TestStructure s2 = new TestStructure();
        TestStructure s3 = new TestStructure();
        s2.first = s3.first = (VALUE = 99);
        s1.first = s3.first;
        StructureTest.assertFalse((String)"Structures of different classes with same fields are not equal", (boolean)s1.equals((Object)s0));
        StructureTest.assertFalse((String)"Structures of different classes with same fields are not equal (reflexive)", (boolean)s0.equals((Object)s1));
        StructureTest.assertFalse((String)"Compare to null failed", (boolean)s1.equals(null));
        StructureTest.assertTrue((String)"Equals is not reflexive", (boolean)s1.equals((Object)s1));
        StructureTest.assertTrue((String)"Equals failed on identical structures", (boolean)s1.equals((Object)s2));
        StructureTest.assertTrue((String)"Equals is not symmetric", (boolean)s2.equals((Object)s1));
        StructureTest.assertTrue((String)"Equals is not transitive", (s1.equals((Object)s2) && s2.equals((Object)s3) && s1.equals((Object)s3) ? 1 : 0) != 0);
    }

    public void testStructureEqualsByValueByReference() {
        int VALUE;
        class TestStructure
        extends Structure {
            public int first;
            public int[] second = new int[4];
            public Pointer[] third = new Pointer[4];

            TestStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("first", "second", "third");
            }
        }
        TestStructure s1 = new TestStructure();
        class ByReference
        extends TestStructure
        implements Structure.ByReference {
            ByReference() {
            }
        }
        ByReference s2 = new ByReference();
        class ByValue
        extends TestStructure
        implements Structure.ByValue {
            ByValue() {
            }
        }
        ByValue s3 = new ByValue();
        s2.first = s3.first = (VALUE = 99);
        s1.first = s3.first;
        StructureTest.assertTrue((String)"Equals failed on identical ByReference", (boolean)s1.equals((Object)s2));
        StructureTest.assertTrue((String)"Equals is not symmetric (ByReference)", (boolean)s2.equals((Object)s1));
        StructureTest.assertTrue((String)"Equals failed on identical ByValue", (boolean)s1.equals((Object)s3));
        StructureTest.assertTrue((String)"Equals is not symmetric (ByValue)", (boolean)s3.equals((Object)s1));
        StructureTest.assertTrue((String)"Equals is not transitive (ByReference/ByValue)", (s1.equals((Object)s2) && s2.equals((Object)s3) && s1.equals((Object)s3) ? 1 : 0) != 0);
    }

    public void testStructureHashCodeMatchesEqualsTrue() {
        class TestStructure
        extends Structure {
            public int first;

            TestStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("first");
            }
        }
        TestStructure s1 = new TestStructure();
        TestStructure s2 = new TestStructure();
        s2.first = 305419896;
        s1.first = 305419896;
        StructureTest.assertEquals((String)"hashCode should match when structures equal", (int)s1.hashCode(), (int)s2.hashCode());
    }

    public void testStructureEqualsIgnoresPadding() {
        class TestStructure
        extends Structure {
            public byte first;
            public int second;

            TestStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("first", "second");
            }
        }
        TestStructure s1 = new TestStructure();
        TestStructure s2 = new TestStructure();
        s2.getPointer().setInt(0L, -1);
        s2.write();
        StructureTest.assertTrue((String)"Structure equals should ignore padding", (boolean)s1.equals((Object)s2));
    }

    public void testRecursiveWrite() {
        class TestStructureByRef
        extends Structure
        implements Structure.ByReference {
            public int unique;
            public TestStructureByRef s;

            public TestStructureByRef(Pointer p) {
                super(p);
            }

            public TestStructureByRef() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("unique", "s");
            }
        }
        TestStructureByRef s = new TestStructureByRef();
        s.s = new TestStructureByRef();
        s.unique = 1;
        s.s.s = s;
        s.s.unique = 2;
        s.write();
        StructureTest.assertEquals((String)"Structure field contents not written", (int)1, (int)s.getPointer().getInt(0L));
        StructureTest.assertEquals((String)"ByReference structure field contents not written", (int)2, (int)s.s.getPointer().getInt(0L));
        s.s.unique = 0;
        TestStructureByRef value = s.s;
        s.read();
        StructureTest.assertEquals((String)"ByReference structure field not preserved", (Object)((Object)value), (Object)((Object)s.s));
        StructureTest.assertEquals((String)"ByReference structure field contents not read", (int)2, (int)s.s.unique);
        StructureTest.assertTrue((String)"Temporary storage should be cleared", (boolean)s.busy().isEmpty());
    }

    public void testCyclicRead() {
        CyclicTestStructure s = new CyclicTestStructure();
        CyclicTestStructure.ByReference value = s.next = new CyclicTestStructure.ByReference();
        s.next.next = s.next;
        s.write();
        s.read();
        StructureTest.assertEquals((String)"ByReference structure field not preserved", (Object)((Object)value), (Object)((Object)s.next));
        value = s.next;
        s.next.next = null;
        s.read();
        StructureTest.assertSame((String)"ByReference structure field should reuse existing value", (Object)((Object)value), (Object)((Object)s.next));
        StructureTest.assertSame((String)"Nested ByReference structure field should reuse existing value", (Object)((Object)value), (Object)((Object)s.next.next));
    }

    public void testAvoidMemoryAllocationInPointerCTOR() {
        Memory p = new Memory(4L);
        class TestStructure
        extends Structure {
            public int field;

            protected List getFieldOrder() {
                return Arrays.asList("field");
            }

            public TestStructure(Pointer p) {
                super(p);
            }

            protected Memory autoAllocate(int size) {
                Assert.fail((String)"Memory should not be auto-allocated");
                return null;
            }
        }
        TestStructure s = new TestStructure((Pointer)p);
    }

    public void testPointerCTORWithInitializedFields() {
        Memory p = new Memory(260L);
        p.setInt(0L, 1);
        p.setByte(4L, (byte)2);
        p.setByte(5L, (byte)3);
        p.setByte(6L, (byte)4);
        p.setByte(7L, (byte)5);
        class TestStructure
        extends Structure {
            public int intField;
            public byte[] arrayField;

            protected List getFieldOrder() {
                return Arrays.asList("intField", "arrayField");
            }

            public TestStructure(Pointer p) {
                super(p);
                this.arrayField = new byte[256];
                this.read();
            }
        }
        TestStructure s = new TestStructure((Pointer)p);
        StructureTest.assertEquals((String)"Structure primitive field not initialized", (int)1, (int)s.intField);
        StructureTest.assertEquals((String)"Structure primitive array field not initialized", (byte)2, (byte)s.arrayField[0]);
        StructureTest.assertEquals((String)"Structure primitive array field not initialized", (byte)3, (byte)s.arrayField[1]);
        StructureTest.assertEquals((String)"Structure primitive array field not initialized", (byte)4, (byte)s.arrayField[2]);
        StructureTest.assertEquals((String)"Structure primitive array field not initialized", (byte)5, (byte)s.arrayField[3]);
        StructureTest.assertEquals((String)"Wrong structure size", (long)p.size(), (long)s.size());
    }

    public static void testByReferenceArrayField() {
        TestByReferenceArrayField.ByReference s = new TestByReferenceArrayField.ByReference();
        s.value1 = 22;
        s.array[0] = s;
        s.value2 = 42;
        s.write();
        TestByReferenceArrayField s2 = new TestByReferenceArrayField(s.getPointer());
        StructureTest.assertEquals((String)"value1 not properly read from Pointer", (int)s.value1, (int)s2.value1);
        StructureTest.assertNotNull((String)"Structure.ByReference array field was not initialized", (Object)s2.array);
        StructureTest.assertEquals((String)"Structure.ByReference array field initialized to incorrect length", (int)13, (int)s2.array.length);
        StructureTest.assertNotNull((String)"Structure.ByReference array field element was not initialized", (Object)((Object)s2.array[0]));
        StructureTest.assertEquals((String)"Incorrect value for Structure.ByReference array field element", (Object)s.array[0].getPointer(), (Object)s2.array[0].getPointer());
        StructureTest.assertEquals((String)"Field 'value2' not properly read from Pointer", (int)s.value2, (int)s2.value2);
    }

    public void testEquals() {
        class TestStructure
        extends Structure {
            public int field;

            protected List getFieldOrder() {
                return Arrays.asList("field");
            }

            public TestStructure() {
            }

            public TestStructure(Pointer p) {
                super(p);
                this.read();
            }
        }
        TestStructure s = new TestStructure();
        StructureTest.assertTrue((String)"Should match self", (boolean)s.equals((Object)s));
        StructureTest.assertFalse((String)"Not equal null", (boolean)s.equals(null));
        StructureTest.assertFalse((String)"Not equal some other object", (boolean)s.equals(new Object()));
        TestStructure s1 = new TestStructure(s.getPointer());
        StructureTest.assertEquals((String)"Same base address/type should be equal", (Object)((Object)s), (Object)((Object)s1));
    }

    public void testStructureLayoutCacheing() {
        class TestStructure
        extends Structure {
            public int field;

            TestStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("field");
            }
        }
        TestStructure ts = new TestStructure();
        ts.ensureAllocated();
        TestStructure ts2 = new TestStructure();
        ts2.ensureAllocated();
        StructureTest.assertSame((String)"Structure layout not cached", (Object)ts.fields(), (Object)ts2.fields());
    }

    public void testStructureLayoutVariableNoCache() {
        class TestStructure
        extends Structure {
            public byte[] variable;

            protected List getFieldOrder() {
                return Arrays.asList("variable");
            }

            public TestStructure(int size) {
                this.variable = new byte[size];
            }
        }
        TestStructure ts = new TestStructure(8);
        TestStructure ts2 = new TestStructure(16);
        ts.ensureAllocated();
        ts2.ensureAllocated();
        StructureTest.assertNotSame((String)"Structure layout should not be cached", (Object)ts.fields(), (Object)ts2.fields());
    }

    public void testStructureLayoutCacheingWithTypeMapper() {
        class TestTypeMapper
        extends DefaultTypeMapper {
            TestTypeMapper() {
                TypeConverter tc = new TypeConverter(){

                    public Class nativeType() {
                        return Integer.TYPE;
                    }

                    public Object fromNative(Object nativeValue, FromNativeContext c) {
                        return new Boolean(nativeValue.equals(new Integer(0)));
                    }

                    public Object toNative(Object value, ToNativeContext c) {
                        return new Integer(Boolean.TRUE.equals(value) ? -1 : 0);
                    }
                };
                this.addTypeConverter(Boolean.TYPE, tc);
                this.addTypeConverter(Boolean.class, tc);
            }
        }
        final TestTypeMapper m = new TestTypeMapper();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class TestStructure
        extends Structure {
            public boolean field;

            protected List getFieldOrder() {
                return Arrays.asList("field");
            }

            public TestStructure() {
                super((TypeMapper)testTypeMapper);
            }

            public TestStructure(TypeMapper m2) {
                super(m2);
            }
        }
        TestStructure ts = new TestStructure();
        TestStructure ts2 = new TestStructure();
        TestStructure ts3 = new TestStructure((TypeMapper)m);
        StructureTest.assertSame((String)"Structure layout should be cached with custom type mapper", (Object)ts.fields(), (Object)ts2.fields());
        StructureTest.assertSame((String)"Structure layout should be cached with custom type mapper, regardless of constructor type", (Object)ts.fields(), (Object)ts3.fields());
    }

    public void testStructureLayoutCacheingWithAlignment() {
        class TestStructure
        extends Structure {
            public byte first;
            public int second;

            protected List getFieldOrder() {
                return Arrays.asList("first", "second");
            }

            public TestStructure() {
                this.setAlignType(1);
            }

            public TestStructure(int alignType) {
                super(alignType);
            }
        }
        TestStructure ts = new TestStructure();
        TestStructure ts2 = new TestStructure();
        TestStructure ts3 = new TestStructure(1);
        StructureTest.assertSame((String)"Structure layout should be cached with custom alignment", (Object)ts.fields(), (Object)ts2.fields());
        StructureTest.assertSame((String)"Structure layout should be cached with custom alignment, regardless of how set", (Object)ts.fields(), (Object)ts3.fields());
    }

    public void testStructureSetIterator() {
        StructureTest.assertNotNull((String)"Indirect test of StructureSet.Iterator", (Object)Structure.busy().toString());
    }

    public void testFFITypeCalculationWithTypeMappedFields() {
        final TypeMapper mapper = new TypeMapper(){

            public FromNativeConverter getFromNativeConverter(Class cls) {
                if (Boolean.class.equals((Object)cls) || Boolean.TYPE.equals(cls)) {
                    return new FromNativeConverter(){

                        public Class nativeType() {
                            return Byte.TYPE;
                        }

                        public Object fromNative(Object nativeValue, FromNativeContext context) {
                            return nativeValue.equals(new Byte(0)) ? Boolean.FALSE : Boolean.TRUE;
                        }
                    };
                }
                return null;
            }

            public ToNativeConverter getToNativeConverter(Class javaType) {
                if (Boolean.class.equals((Object)javaType) || Boolean.TYPE.equals(javaType)) {
                    return new ToNativeConverter(){

                        public Object toNative(Object value, ToNativeContext context) {
                            return new Byte(Boolean.TRUE.equals(value) ? (byte)1 : 0);
                        }

                        public Class nativeType() {
                            return Byte.TYPE;
                        }
                    };
                }
                return null;
            }
        };
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class TestStructure
        extends Structure {
            public boolean b;
            public short s;
            public int p0;
            public int p1;
            public int p2;
            public int p3;
            public int p4;
            public int p5;
            public int p6;
            public int p7;

            public TestStructure() {
                super(typeMapper);
            }

            protected List getFieldOrder() {
                return Arrays.asList("b", "s", "p0", "p1", "p2", "p3", "p4", "p5", "p6", "p7");
            }
        }
        TestStructure s = new TestStructure();
        StructureTest.assertEquals((String)"Wrong type mapper for structure", (Object)mapper, (Object)s.getTypeMapper());
        TestFFIType ffi_type = new TestFFIType(Structure.getTypeInfo((Object)((Object)s)));
        StructureTest.assertEquals((String)"Java Structure size does not match FFIType size", (int)s.size(), (int)ffi_type.size.intValue());
    }

    public static class TestByReferenceArrayField
    extends Structure {
        public int value1;
        public ByReference[] array = new ByReference[13];
        public int value2;

        public TestByReferenceArrayField() {
        }

        public TestByReferenceArrayField(Pointer m) {
            super(m);
            this.read();
        }

        protected List getFieldOrder() {
            return Arrays.asList("value1", "array", "value2");
        }

        public static class ByReference
        extends TestByReferenceArrayField
        implements Structure.ByReference {
        }
    }

    public static class CyclicTestStructure
    extends Structure {
        public ByReference next;

        public CyclicTestStructure(Pointer p) {
            super(p);
        }

        public CyclicTestStructure() {
        }

        protected List getFieldOrder() {
            return Arrays.asList("next");
        }

        public static class ByReference
        extends CyclicTestStructure
        implements Structure.ByReference {
        }
    }

    public static class ROStructure
    extends Structure {
        public final int field;

        public ROStructure() {
            this.field = 0;
        }

        protected List getFieldOrder() {
            return Arrays.asList("field");
        }
    }

    class TestFFIType
    extends Structure {
        public size_t size;
        public short alignment;
        public short type;
        public Pointer elements;

        protected List getFieldOrder() {
            return Arrays.asList("size", "alignment", "type", "elements");
        }

        public TestFFIType(Pointer p) {
            super(p);
            this.read();
            Assert.assertTrue((String)("Test FFIType type not initialized: " + (Object)((Object)this)), (this.type != 0 ? 1 : 0) != 0);
            int size = Native.initialize_ffi_type((long)p.peer);
            this.read();
            Assert.assertEquals((String)("Test FFIType size improperly initialized: " + (Object)((Object)this)), (int)size, (int)this.size.intValue());
        }
    }

    public static class size_t
    extends IntegerType {
        public size_t() {
            this(0L);
        }

        public size_t(long value) {
            super(Native.POINTER_SIZE, value);
        }
    }

    static class NestedTypeInfoStructure
    extends Structure {
        public Inner inner;
        public int dummy;

        NestedTypeInfoStructure() {
        }

        protected List getFieldOrder() {
            return Arrays.asList("inner", "dummy");
        }

        public static class Inner
        extends Structure {
            public int dummy;

            protected List getFieldOrder() {
                return Arrays.asList("dummy");
            }
        }
    }

    public static class StructureFromNative
    extends Structure {
        public String s;

        protected List getFieldOrder() {
            return Arrays.asList("s");
        }

        public StructureFromNative(Pointer p) {
            super(p);
            this.read();
        }

        public StructureFromNative() {
        }
    }

    public static class TestPointer
    extends PointerType {
    }

    public static class StructureWithPointers
    extends Structure {
        public PublicTestStructure.ByReference s1;
        public PublicTestStructure.ByReference s2;

        protected List getFieldOrder() {
            return Arrays.asList("s1", "s2");
        }
    }

    public static class StructureWithArrayOfStructureField
    extends Structure {
        public Structure[] array;

        protected List getFieldOrder() {
            return Arrays.asList("array");
        }
    }

    static class CbStruct
    extends Structure {
        public Callback cb;

        CbStruct() {
        }

        protected List getFieldOrder() {
            return Arrays.asList("cb");
        }
    }

    public static class BadFieldStructure
    extends Structure {
        public Object badField;

        protected List getFieldOrder() {
            return Arrays.asList("badField");
        }
    }

    public static class ToArrayTestStructure
    extends Structure {
        public PublicTestStructure[] inner = (PublicTestStructure[])new PublicTestStructure().toArray(2);

        protected List getFieldOrder() {
            return Arrays.asList("inner");
        }
    }

    public static class NonAllocatingTestStructure
    extends PublicTestStructure {
        public NonAllocatingTestStructure() {
        }

        public NonAllocatingTestStructure(Pointer p) {
            super(p);
            this.read();
        }

        protected void allocateMemory(int size) {
            throw new Error("Memory unexpectedly allocated");
        }
    }

    public static class PublicTestStructure
    extends Structure {
        public int x = 1;
        public int y = 2;
        public static int allocations = 0;

        public PublicTestStructure() {
        }

        public PublicTestStructure(Pointer p) {
            super(p);
            this.read();
        }

        protected void allocateMemory(int size) {
            super.allocateMemory(size);
            ++allocations;
        }

        protected List getFieldOrder() {
            return Arrays.asList("x", "y");
        }

        public static class ByReference
        extends PublicTestStructure
        implements Structure.ByReference {
            public ByReference() {
            }

            public ByReference(Pointer p) {
                super(p);
            }
        }
    }

    public static interface AlignmentTest
    extends Library {
        public int testStructureAlignment(Structure var1, int var2, IntByReference var3, LongByReference var4);
    }

    public static interface SizeTest
    extends Library {
        public int getStructureSize(int var1);
    }

    public static class TestStructure5
    extends FilledStructure {
        public long field0 = 0x101010101010101L;
        public byte field1 = (byte)2;

        protected List getFieldOrder() {
            return Arrays.asList("field0", "field1");
        }
    }

    public static class TestStructure4
    extends FilledStructure {
        public int field0 = 0x1010101;
        public long field1 = 0x202020202020202L;
        public int field2 = 0x3030303;
        public long field3 = 0x404040404040404L;

        protected List getFieldOrder() {
            return Arrays.asList("field0", "field1", "field2", "field3");
        }
    }

    public static class TestStructure3
    extends FilledStructure {
        public int field0 = 0x1010101;
        public short field1 = (short)514;
        public int field2 = 0x3030303;

        protected List getFieldOrder() {
            return Arrays.asList("field0", "field1", "field2");
        }
    }

    public static class TestStructure2
    extends FilledStructure {
        public short field0 = (short)257;
        public int field1 = 0x2020202;

        protected List getFieldOrder() {
            return Arrays.asList("field0", "field1");
        }
    }

    public static class TestStructure1
    extends FilledStructure {
        public byte field0 = 1;
        public int field1 = 0x2020202;

        protected List getFieldOrder() {
            return Arrays.asList("field0", "field1");
        }
    }

    public static class TestStructure0
    extends FilledStructure {
        public byte field0 = 1;
        public short field1 = (short)514;

        protected List getFieldOrder() {
            return Arrays.asList("field0", "field1");
        }
    }

    public static abstract class FilledStructure
    extends Structure {
        private boolean initialized;

        protected void ensureAllocated() {
            super.ensureAllocated();
            if (!this.initialized) {
                this.initialized = true;
                for (int i = 0; i < this.size(); ++i) {
                    this.getPointer().setByte((long)i, (byte)-1);
                }
            }
        }
    }

    public static class TestAllocStructure
    extends Structure {
        public int f0;
        public int f1;
        public int f2;
        public int f3;

        protected List getFieldOrder() {
            return Arrays.asList("f0", "f1", "f2", "f3");
        }
    }
}

