/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Platform;
import com.sun.jna.Structure;
import com.sun.jna.StructureByValueTest;
import com.sun.jna.StructureFieldOrderInspector;
import com.sun.jna.StructureTest;
import com.sun.jna.Union;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;

public class StructureFieldOrderInspectorTest
extends TestCase {
    private String origPropJNANoSys;

    protected void setUp() {
        this.origPropJNANoSys = System.getProperty("jna.nosys");
        System.setProperty("jna.nosys", "true");
    }

    protected void tearDown() {
        if (this.origPropJNANoSys == null) {
            System.getProperties().remove("jna.nosys");
        } else {
            System.setProperty("jna.nosys", this.origPropJNANoSys);
        }
    }

    public void testFindStructureSubClasses() {
        Set<Class<? extends Structure>> classes = StructureFieldOrderInspector.findSubTypesOfStructure(Platform.class);
        StructureFieldOrderInspectorTest.assertTrue((String)"Found no Structure sub types.", (classes.size() > 0 ? 1 : 0) != 0);
        for (Class<? extends Structure> structureSubType : classes) {
            StructureFieldOrderInspectorTest.assertTrue((String)structureSubType.getName(), (boolean)Structure.class.isAssignableFrom(structureSubType));
        }
    }

    public void testCheckMethodGetFieldOrderExisting() {
        StructureFieldOrderInspector.checkMethodGetFieldOrder(StructureByValueTest.TestNativeMappedInStructure.class, null);
    }

    public void testCheckMethodGetFieldOrderTagInterface() {
        StructureFieldOrderInspector.checkMethodGetFieldOrder(StructureByValueTest.TestNativeMappedInStructure.ByValue.class, null);
    }

    public void testCheckMethodGetFieldOrderMissingField() throws Exception {
        try {
            StructureFieldOrderInspector.checkMethodGetFieldOrder(MyStructMissingField.class, null);
            StructureFieldOrderInspectorTest.fail((String)"Expected Error: Structure.getFieldOrder()...");
        }
        catch (RuntimeException e) {
            StructureFieldOrderInspectorTest.assertTrue((boolean)e.getCause().getCause().getMessage().contains("not match declared field names"));
        }
    }

    public void testCheckMethodGetFieldOrderExtraField() throws Exception {
        try {
            StructureFieldOrderInspector.checkMethodGetFieldOrder(MyStructExtraField.class, null);
            StructureFieldOrderInspectorTest.fail((String)"Expected Error: Structure.getFieldOrder()...");
        }
        catch (RuntimeException e) {
            StructureFieldOrderInspectorTest.assertTrue((boolean)e.getCause().getCause().getMessage().contains("not match declared field names"));
        }
    }

    public void testCheckMethodGetFieldOrderStaticField() throws Exception {
        StructureFieldOrderInspector.checkMethodGetFieldOrder(MyStructStaticField.class, null);
    }

    public void testCheckMethodGetFieldOrderSuperImplOnly() throws Exception {
        StructureFieldOrderInspector.checkMethodGetFieldOrder(MyStructChildEmpty.class, null);
    }

    public void testCheckMethodGetFieldOrderWithAbstractSubtype() throws Exception {
        StructureFieldOrderInspector.checkMethodGetFieldOrder(Union.class, null);
    }

    public void testCheckMethodGetFieldOrderWithIgnoreCtorError() throws Exception {
        ArrayList<String> ignoreConstructorError = new ArrayList<String>();
        ignoreConstructorError.add(StructureFieldOrderInspectorTest.class.getName());
        StructureFieldOrderInspector.checkMethodGetFieldOrder(MyStructExtraField.class, ignoreConstructorError);
    }

    public void testCheckStructureGetFieldOrder() throws Exception {
        StructureFieldOrderInspector.checkStructureGetFieldOrder(Platform.class, null);
    }

    public void testBatchCheckStructureGetFieldOrder() throws Exception {
        try {
            StructureFieldOrderInspector.batchCheckStructureGetFieldOrder(StructureTest.class, null);
            StructureFieldOrderInspectorTest.fail((String)"Expected structure failures");
        }
        catch (RuntimeException e) {
            StructureFieldOrderInspectorTest.assertTrue((boolean)e.getMessage().startsWith("Some Structure sub types"));
        }
    }

    private static final class MyStructChildEmpty
    extends MyStructSuper {
        private MyStructChildEmpty() {
        }
    }

    private static class MyStructSuper
    extends Structure {
        public long instanceField;

        private MyStructSuper() {
        }

        protected List getFieldOrder() {
            return Arrays.asList("instanceField");
        }
    }

    private static final class MyStructStaticField
    extends Structure {
        public long instanceField;
        public static long myStaticField = -1L;

        private MyStructStaticField() {
        }

        protected List getFieldOrder() {
            return Arrays.asList("instanceField");
        }
    }

    private static final class MyStructExtraField
    extends Structure {
        private MyStructExtraField() {
        }

        protected List getFieldOrder() {
            return Arrays.asList("extraField");
        }
    }

    private static final class MyStructMissingField
    extends Structure {
        public String missingDeclaredField;

        private MyStructMissingField() {
        }

        protected List getFieldOrder() {
            return Arrays.asList(new Object[0]);
        }
    }
}

