/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.FromNativeContext;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeString;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.Structure;
import com.sun.jna.Union;
import com.sun.jna.WString;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class ArgumentsMarshalTest
extends TestCase {
    TestLibrary lib;
    static final String MAGIC = "magic";

    protected void setUp() {
        this.lib = (TestLibrary)Native.loadLibrary((String)"testlib", TestLibrary.class);
    }

    protected void tearDown() {
        this.lib = null;
    }

    public void testJavaObjectArgument() {
        ArgumentsMarshalTest o = this;
        try {
            this.lib.returnStringArgument((Object)o);
            ArgumentsMarshalTest.fail((String)"Java Object arguments should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            ArgumentsMarshalTest.assertTrue((String)("Exception should include Object type description: " + e), (e.getMessage().indexOf(((Object)((Object)o)).getClass().getName()) != -1 ? 1 : 0) != 0);
        }
        catch (Throwable e) {
            ArgumentsMarshalTest.fail((String)("Java Object arguments should throw IllegalArgumentException, not " + e));
        }
    }

    public void testBooleanArgument() {
        ArgumentsMarshalTest.assertTrue((String)"True argument should be returned", (boolean)this.lib.returnBooleanArgument(true));
        ArgumentsMarshalTest.assertFalse((String)"False argument should be returned", (boolean)this.lib.returnBooleanArgument(false));
    }

    public void testInt8Argument() {
        byte b = 0;
        ArgumentsMarshalTest.assertEquals((String)"Wrong value returned", (byte)b, (byte)this.lib.returnInt8Argument(b));
        b = 127;
        ArgumentsMarshalTest.assertEquals((String)"Wrong value returned", (byte)b, (byte)this.lib.returnInt8Argument(b));
        b = -128;
        ArgumentsMarshalTest.assertEquals((String)"Wrong value returned", (byte)b, (byte)this.lib.returnInt8Argument(b));
    }

    public void testWideCharArgument() {
        char c = '\u0000';
        ArgumentsMarshalTest.assertEquals((String)"Wrong value returned", (char)c, (char)this.lib.returnWideCharArgument(c));
        char c2 = '\uffff';
        ArgumentsMarshalTest.assertEquals((String)"Wrong value returned", (char)c2, (char)this.lib.returnWideCharArgument(c2));
        char c3 = Short.MAX_VALUE;
        ArgumentsMarshalTest.assertEquals((String)"Wrong value returned", (char)c3, (char)this.lib.returnWideCharArgument(c3));
    }

    public void testInt16Argument() {
        short v = 0;
        ArgumentsMarshalTest.assertEquals((String)"Wrong value returned", (short)v, (short)this.lib.returnInt16Argument(v));
        v = Short.MAX_VALUE;
        ArgumentsMarshalTest.assertEquals((String)"Wrong value returned", (short)v, (short)this.lib.returnInt16Argument(v));
        v = Short.MIN_VALUE;
        ArgumentsMarshalTest.assertEquals((String)"Wrong value returned", (short)v, (short)this.lib.returnInt16Argument(v));
    }

    public void testIntArgument() {
        int value = 0;
        ArgumentsMarshalTest.assertEquals((String)"Should return 32-bit argument", (int)value, (int)this.lib.returnInt32Argument(value));
        value = 1;
        ArgumentsMarshalTest.assertEquals((String)"Should return 32-bit argument", (int)value, (int)this.lib.returnInt32Argument(value));
        value = Integer.MAX_VALUE;
        ArgumentsMarshalTest.assertEquals((String)"Should return 32-bit argument", (int)value, (int)this.lib.returnInt32Argument(value));
        value = Integer.MIN_VALUE;
        ArgumentsMarshalTest.assertEquals((String)"Should return 32-bit argument", (int)value, (int)this.lib.returnInt32Argument(value));
    }

    public void testLongArgument() {
        long value = 0L;
        ArgumentsMarshalTest.assertEquals((String)"Should return 64-bit argument", (long)value, (long)this.lib.returnInt64Argument(value));
        value = 1L;
        ArgumentsMarshalTest.assertEquals((String)"Should return 64-bit argument", (long)value, (long)this.lib.returnInt64Argument(value));
        value = Integer.MAX_VALUE;
        ArgumentsMarshalTest.assertEquals((String)"Should return 64-bit argument", (long)value, (long)this.lib.returnInt64Argument(value));
        value = 0x80000000L;
        ArgumentsMarshalTest.assertEquals((String)"Should return 64-bit argument", (long)value, (long)this.lib.returnInt64Argument(value));
        value = 0x7FFFFFFF00000000L;
        ArgumentsMarshalTest.assertEquals((String)"Should return 64-bit argument", (long)value, (long)this.lib.returnInt64Argument(value));
        value = Long.MIN_VALUE;
        ArgumentsMarshalTest.assertEquals((String)"Should return 64-bit argument", (long)value, (long)this.lib.returnInt64Argument(value));
    }

    public void testNativeLongArgument() {
        NativeLong value = new NativeLong(0L);
        ArgumentsMarshalTest.assertEquals((String)"Should return 0", (Object)value, (Object)this.lib.returnLongArgument(value));
        value = new NativeLong(1L);
        ArgumentsMarshalTest.assertEquals((String)"Should return 1", (Object)value, (Object)this.lib.returnLongArgument(value));
        value = new NativeLong(Integer.MAX_VALUE);
        ArgumentsMarshalTest.assertEquals((String)"Should return 0x7FFFFFFF", (Object)value, (Object)this.lib.returnLongArgument(value));
        value = new NativeLong(Integer.MIN_VALUE);
        ArgumentsMarshalTest.assertEquals((String)"Should return 0x80000000", (Object)value, (Object)this.lib.returnLongArgument(value));
    }

    protected NativeMappedLibrary loadNativeMappedLibrary() {
        return (NativeMappedLibrary)Native.loadLibrary((String)"testlib", NativeMappedLibrary.class);
    }

    public void testNativeMappedArgument() {
        NativeMappedLibrary lib = this.loadNativeMappedLibrary();
        int MAGIC = 305419896;
        Custom arg = new Custom(305419896);
        ArgumentsMarshalTest.assertEquals((String)"Argument not mapped", (int)305419896, (int)lib.returnInt32Argument(arg));
    }

    public void testPointerArgumentReturn() {
        ArgumentsMarshalTest.assertEquals((String)"Expect null pointer", null, (Object)this.lib.returnPointerArgument(null));
        TestLibrary.CheckFieldAlignment s = new TestLibrary.CheckFieldAlignment();
        ArgumentsMarshalTest.assertEquals((String)"Expect structure pointer", (Object)s.getPointer(), (Object)this.lib.returnPointerArgument(s.getPointer()));
    }

    public void testStringArgumentReturn() {
        ArgumentsMarshalTest.assertEquals((String)"Expect null pointer", null, (String)this.lib.returnStringArgument(null));
        ArgumentsMarshalTest.assertEquals((String)"Expect string magic", (String)MAGIC, (String)this.lib.returnStringArgument(MAGIC));
    }

    public void testWStringArgumentReturn() {
        ArgumentsMarshalTest.assertEquals((String)"Expect null pointer", null, (String)this.lib.returnStringArgument(null));
        ArgumentsMarshalTest.assertEquals((String)"Expect string magic", (String)MAGIC, (String)this.lib.returnStringArgument(MAGIC).toString());
    }

    public void testInt64ArgumentAlignment() {
        long value = this.lib.checkInt64ArgumentAlignment(0x10101010, 0x1111111111111111L, 0x1010101, 0x2222222222222222L);
        ArgumentsMarshalTest.assertEquals((String)"Improper handling of interspersed int32/int64", (long)0x3333333344444444L, (long)value);
    }

    public void testDoubleArgumentAlignment() {
        double value = this.lib.checkDoubleArgumentAlignment(1.0f, 2.0, 3.0f, 4.0);
        ArgumentsMarshalTest.assertEquals((String)"Improper handling of interspersed float/double", (double)10.0, (double)value, (double)0.0);
    }

    public void testStructurePointerArgument() {
        TestLibrary.CheckFieldAlignment struct = new TestLibrary.CheckFieldAlignment();
        ArgumentsMarshalTest.assertEquals((String)"Native address of structure should be returned", (Object)struct.getPointer(), (Object)this.lib.testStructurePointerArgument(struct));
        struct = new TestLibrary.CheckFieldAlignment.ByValue();
        ArgumentsMarshalTest.assertEquals((String)"Structure argument should be passed according to method parameter type, not argument type", (Object)struct.getPointer(), (Object)this.lib.testStructurePointerArgument(struct));
        struct = null;
        ArgumentsMarshalTest.assertNull((String)"Null argument should be returned", (Object)this.lib.testStructurePointerArgument(struct));
    }

    public void testStructureByValueArgument() {
        TestLibrary.CheckFieldAlignment.ByValue struct = new TestLibrary.CheckFieldAlignment.ByValue();
        ArgumentsMarshalTest.assertEquals((String)("Wrong alignment in " + struct.toString(true)), (String)"0", (String)Integer.toHexString(this.lib.testStructureByValueArgument(struct)));
    }

    public void testStructureByValueTypeInfo() {
        class TestStructure
        extends Structure
        implements Structure.ByValue {
            public byte b;
            public char c;
            public short s;
            public int i;
            public long j;
            public float f;
            public double d;
            public Pointer[] parray = new Pointer[2];
            public byte[] barray = new byte[2];

            TestStructure() {
            }

            protected List getFieldOrder() {
                return Arrays.asList("b", "c", "s", "i", "j", "f", "d", "parray", "barray");
            }
        }
        TestStructure s = new TestStructure();
        s.size();
    }

    public void testWriteStructureArrayArgumentMemory() {
        int LENGTH = 10;
        TestLibrary.CheckFieldAlignment block = new TestLibrary.CheckFieldAlignment();
        TestLibrary.CheckFieldAlignment[] array = (TestLibrary.CheckFieldAlignment[])block.toArray(10);
        for (int i = 0; i < array.length; ++i) {
            array[i].int32Field = i;
        }
        ArgumentsMarshalTest.assertEquals((String)"Structure array memory not properly initialized", (int)-1, (int)this.lib.testStructureArrayInitialization(array, array.length));
    }

    public void testUninitializedStructureArrayArgument() {
        int LENGTH = 10;
        TestLibrary.CheckFieldAlignment[] block = new TestLibrary.CheckFieldAlignment[10];
        this.lib.modifyStructureArray(block, block.length);
        for (int i = 0; i < block.length; ++i) {
            ArgumentsMarshalTest.assertNotNull((String)("Structure array not initialized at " + i), (Object)((Object)block[i]));
            ArgumentsMarshalTest.assertEquals((String)("Wrong value for int32 field of structure at " + i), (int)i, (int)block[i].int32Field);
            ArgumentsMarshalTest.assertEquals((String)("Wrong value for int64 field of structure at " + i), (long)(i + 1), (long)block[i].int64Field);
            ArgumentsMarshalTest.assertEquals((String)("Wrong value for float field of structure at " + i), (float)(i + 2), (float)block[i].floatField, (float)0.0f);
            ArgumentsMarshalTest.assertEquals((String)("Wrong value for double field of structure at " + i), (double)(i + 3), (double)block[i].doubleField, (double)0.0);
        }
    }

    public void testRejectNoncontiguousStructureArrayArgument() {
        TestLibrary.CheckFieldAlignment s3 = new TestLibrary.CheckFieldAlignment();
        TestLibrary.CheckFieldAlignment s1 = new TestLibrary.CheckFieldAlignment();
        TestLibrary.CheckFieldAlignment s2 = new TestLibrary.CheckFieldAlignment();
        TestLibrary.CheckFieldAlignment[] block = new TestLibrary.CheckFieldAlignment[]{s1, s2, s3};
        try {
            this.lib.modifyStructureArray(block, block.length);
            ArgumentsMarshalTest.fail((String)"Library invocation should fail");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void testWriteStructureByReferenceArrayArgumentMemory() {
        TestLibrary.CheckFieldAlignment.ByReference[] array = new TestLibrary.CheckFieldAlignment.ByReference[]{new TestLibrary.CheckFieldAlignment.ByReference(), new TestLibrary.CheckFieldAlignment.ByReference(), new TestLibrary.CheckFieldAlignment.ByReference(), new TestLibrary.CheckFieldAlignment.ByReference()};
        for (int i = 0; i < array.length; ++i) {
            array[i].int32Field = i;
        }
        ArgumentsMarshalTest.assertEquals((String)"Structure.ByReference array memory not properly initialized", (int)-1, (int)this.lib.testStructureByReferenceArrayInitialization(array, array.length));
    }

    public void testReadStructureByReferenceArrayArgumentMemory() {
        TestLibrary.CheckFieldAlignment.ByReference[] array = new TestLibrary.CheckFieldAlignment.ByReference[]{new TestLibrary.CheckFieldAlignment.ByReference(), new TestLibrary.CheckFieldAlignment.ByReference(), new TestLibrary.CheckFieldAlignment.ByReference(), new TestLibrary.CheckFieldAlignment.ByReference()};
        this.lib.modifyStructureByReferenceArray(array, array.length);
        for (int i = 0; i < array.length; ++i) {
            ArgumentsMarshalTest.assertEquals((String)("Wrong value for int32 field of structure at " + i), (int)i, (int)array[i].int32Field);
            ArgumentsMarshalTest.assertEquals((String)("Wrong value for int64 field of structure at " + i), (long)(i + 1), (long)array[i].int64Field);
            ArgumentsMarshalTest.assertEquals((String)("Wrong value for float field of structure at " + i), (float)(i + 2), (float)array[i].floatField, (float)0.0f);
            ArgumentsMarshalTest.assertEquals((String)("Wrong value for double field of structure at " + i), (double)(i + 3), (double)array[i].doubleField, (double)0.0);
        }
    }

    public void testByteArrayArgument() {
        byte[] buf = new byte[1024];
        int MAGIC = -19;
        ArgumentsMarshalTest.assertEquals((String)"Wrong return value", (int)buf.length, (int)this.lib.fillInt8Buffer(buf, buf.length, (byte)-19));
        for (int i = 0; i < buf.length; ++i) {
            ArgumentsMarshalTest.assertEquals((String)("Bad value at index " + i), (byte)-19, (byte)buf[i]);
        }
    }

    public void testShortArrayArgument() {
        short[] buf = new short[1024];
        int MAGIC = -21523;
        ArgumentsMarshalTest.assertEquals((String)"Wrong return value", (int)buf.length, (int)this.lib.fillInt16Buffer(buf, buf.length, (short)-21523));
        for (int i = 0; i < buf.length; ++i) {
            ArgumentsMarshalTest.assertEquals((String)("Bad value at index " + i), (short)-21523, (short)buf[i]);
        }
    }

    public void testIntArrayArgument() {
        int[] buf = new int[1024];
        int MAGIC = -1410478301;
        ArgumentsMarshalTest.assertEquals((String)"Wrong return value", (int)buf.length, (int)this.lib.fillInt32Buffer(buf, buf.length, -1410478301));
        for (int i = 0; i < buf.length; ++i) {
            ArgumentsMarshalTest.assertEquals((String)("Bad value at index " + i), (int)-1410478301, (int)buf[i]);
        }
    }

    public void testLongArrayArgument() {
        long[] buf = new long[1024];
        long MAGIC = 1311768467139281697L;
        ArgumentsMarshalTest.assertEquals((String)"Wrong return value", (int)buf.length, (int)this.lib.fillInt64Buffer(buf, buf.length, 1311768467139281697L));
        for (int i = 0; i < buf.length; ++i) {
            ArgumentsMarshalTest.assertEquals((String)("Bad value at index " + i), (long)1311768467139281697L, (long)buf[i]);
        }
    }

    public void testInvalidArgument() {
        try {
            this.lib.returnBooleanArgument((Object)this);
            ArgumentsMarshalTest.fail((String)"Unsupported Java objects should be rejected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testStringArrayArgument() {
        String[] args = new String[]{"one", "two", "three"};
        ArgumentsMarshalTest.assertEquals((String)"Wrong value returned", (String)args[0], (String)this.lib.returnStringArrayElement(args, 0));
        ArgumentsMarshalTest.assertNull((String)"Native String array should be null terminated", (Object)this.lib.returnStringArrayElement(args, args.length));
    }

    public void testWideStringArrayArgument() {
        WString[] args = new WString[]{new WString("one"), new WString("two"), new WString("three")};
        ArgumentsMarshalTest.assertEquals((String)"Wrong value returned", (Object)args[0], (Object)this.lib.returnWideStringArrayElement(args, 0));
        ArgumentsMarshalTest.assertNull((String)"Native WString array should be null terminated", (Object)this.lib.returnWideStringArrayElement(args, args.length));
    }

    public void testPointerArrayArgument() {
        Pointer[] args = new Pointer[]{new NativeString(this.getName()).getPointer(), null, new NativeString(this.getName() + "2").getPointer()};
        Pointer[] originals = new Pointer[args.length];
        System.arraycopy(args, 0, originals, 0, args.length);
        ArgumentsMarshalTest.assertEquals((String)"Wrong value returned", (Object)args[0], (Object)this.lib.returnPointerArrayElement(args, 0));
        ArgumentsMarshalTest.assertNull((String)"Wrong value returned", (Object)this.lib.returnPointerArrayElement(args, 1));
        ArgumentsMarshalTest.assertEquals((String)"Wrong value returned", (Object)args[2], (Object)this.lib.returnPointerArrayElement(args, 2));
        ArgumentsMarshalTest.assertNull((String)"Native array should be null terminated", (Object)this.lib.returnPointerArrayElement(args, 3));
        ArgumentsMarshalTest.assertSame((String)"Argument pointers should remain unmodified [0]", (Object)originals[0], (Object)args[0]);
        ArgumentsMarshalTest.assertSame((String)"Argument pointers should remain unmodified [2]", (Object)originals[2], (Object)args[2]);
    }

    public void testNativeMappedArrayArgument() {
        TestLibrary.TestPointerType[] args = new TestLibrary.TestPointerType[]{new TestLibrary.TestPointerType(new NativeString(this.getName()).getPointer()), null, new TestLibrary.TestPointerType(new NativeString(this.getName() + "2").getPointer())};
        ArgumentsMarshalTest.assertEquals((String)"Wrong value returned", (Object)((Object)args[0]), (Object)((Object)this.lib.returnPointerArrayElement(args, 0)));
        ArgumentsMarshalTest.assertNull((String)"Wrong value returned", (Object)((Object)this.lib.returnPointerArrayElement(args, 1)));
        ArgumentsMarshalTest.assertEquals((String)"Wrong value returned", (Object)((Object)args[2]), (Object)((Object)this.lib.returnPointerArrayElement(args, 2)));
    }

    public void testStructureByReferenceArrayArgument() {
        TestLibrary.CheckFieldAlignment.ByReference[] args = new TestLibrary.CheckFieldAlignment.ByReference[]{new TestLibrary.CheckFieldAlignment.ByReference(), null, new TestLibrary.CheckFieldAlignment.ByReference()};
        ArgumentsMarshalTest.assertEquals((String)"Wrong value returned (0)", (Object)((Object)args[0]), (Object)((Object)this.lib.returnPointerArrayElement(args, 0)));
        ArgumentsMarshalTest.assertNull((String)"Wrong value returned (1)", (Object)((Object)this.lib.returnPointerArrayElement(args, 1)));
        ArgumentsMarshalTest.assertEquals((String)"Wrong value returned (2)", (Object)((Object)args[2]), (Object)((Object)this.lib.returnPointerArrayElement(args, 2)));
        ArgumentsMarshalTest.assertNull((String)"Native array should be null terminated", (Object)((Object)this.lib.returnPointerArrayElement(args, 3)));
    }

    public void testModifiedCharArrayArgument() {
        String[] args = new String[]{"one", "two", "three"};
        ArgumentsMarshalTest.assertEquals((String)"Wrong native array count", (int)args.length, (int)this.lib.returnRotatedArgumentCount(args));
        ArgumentsMarshalTest.assertEquals((String)"Modified array argument not re-read", Arrays.asList("two", "three", "one"), Arrays.asList(args));
    }

    public void testReadFunctionPointerAsCallback() {
        TestLibrary.CbStruct s = new TestLibrary.CbStruct();
        ArgumentsMarshalTest.assertNull((String)"Function pointer field should be null", (Object)s.cb);
        this.lib.setCallbackInStruct(s);
        ArgumentsMarshalTest.assertNotNull((String)"Callback field not set", (Object)s.cb);
    }

    public void testCallProxiedFunctionPointer() {
        TestLibrary.CbStruct s = new TestLibrary.CbStruct();
        this.lib.setCallbackInStruct(s);
        ArgumentsMarshalTest.assertEquals((String)("Proxy to native function pointer failed: " + s.cb), (int)3, (int)s.cb.callback(1, 2));
    }

    public void testVariableSizedStructureArgument() {
        String EXPECTED = this.getName();
        TestLibrary.VariableSizedStructure s = new TestLibrary.VariableSizedStructure(EXPECTED);
        ArgumentsMarshalTest.assertEquals((String)"Wrong string returned from variable sized struct", (String)EXPECTED, (String)this.lib.returnStringFromVariableSizedStructure(s));
    }

    public void testDisableAutoSynch() {
        TestLibrary.MinTestStructure s = new TestLibrary.MinTestStructure();
        int VALUE = 42;
        s.field = 42;
        s.setAutoWrite(false);
        this.lib.testStructurePointerArgument(s);
        ArgumentsMarshalTest.assertEquals((String)"Auto write should be disabled", (int)0, (int)s.field);
        int EXPECTED = s.field;
        s.getPointer().setInt(0L, 42);
        s.setAutoRead(false);
        this.lib.testStructurePointerArgument(s);
        ArgumentsMarshalTest.assertEquals((String)"Auto read should be disabled", (int)EXPECTED, (int)s.field);
    }

    public void testUnionByValueCallbackArgument() throws Exception {
        String VALUE;
        TestLibrary.TestUnion arg = new TestLibrary.TestUnion();
        arg.setType(String.class);
        arg.f1 = VALUE = this.getName();
        final boolean[] called = new boolean[]{false};
        final String[] cbvalue = new String[]{null};
        TestLibrary.TestUnion result = this.lib.testUnionByValueCallbackArgument(new TestLibrary.UnionCallback(){

            public TestLibrary.TestUnion invoke(TestLibrary.TestUnion v) {
                called[0] = true;
                v.setType(String.class);
                v.read();
                cbvalue[0] = v.f1;
                return v;
            }
        }, arg);
        ArgumentsMarshalTest.assertTrue((String)"Callback not called", (boolean)called[0]);
        ArgumentsMarshalTest.assertEquals((String)"Incorrect callback union argument", (String)VALUE, (String)cbvalue[0]);
        ArgumentsMarshalTest.assertEquals((String)"Union value not propagated", (Object)VALUE, (Object)result.getTypedValue(String.class));
    }

    public static void main(String[] argList) {
        TestRunner.run(ArgumentsMarshalTest.class);
    }

    public static class Custom
    implements NativeMapped {
        private int value;

        public Custom() {
        }

        public Custom(int value) {
            this.value = value;
        }

        public Object fromNative(Object nativeValue, FromNativeContext context) {
            return new Custom((Integer)nativeValue);
        }

        public Class nativeType() {
            return Integer.class;
        }

        public Object toNative() {
            return new Integer(this.value);
        }
    }

    public static interface NativeMappedLibrary
    extends Library {
        public int returnInt32Argument(Custom var1);
    }

    public static interface TestLibrary
    extends Library {
        public String returnStringArgument(Object var1);

        public boolean returnBooleanArgument(boolean var1);

        public byte returnInt8Argument(byte var1);

        public char returnWideCharArgument(char var1);

        public short returnInt16Argument(short var1);

        public int returnInt32Argument(int var1);

        public long returnInt64Argument(long var1);

        public NativeLong returnLongArgument(NativeLong var1);

        public float returnFloatArgument(float var1);

        public double returnDoubleArgument(double var1);

        public String returnStringArgument(String var1);

        public WString returnWStringArgument(WString var1);

        public Pointer returnPointerArgument(Pointer var1);

        public String returnStringArrayElement(String[] var1, int var2);

        public WString returnWideStringArrayElement(WString[] var1, int var2);

        public Pointer returnPointerArrayElement(Pointer[] var1, int var2);

        public TestPointerType returnPointerArrayElement(TestPointerType[] var1, int var2);

        public CheckFieldAlignment returnPointerArrayElement(CheckFieldAlignment.ByReference[] var1, int var2);

        public int returnRotatedArgumentCount(String[] var1);

        public long checkInt64ArgumentAlignment(int var1, long var2, int var4, long var5);

        public double checkDoubleArgumentAlignment(float var1, double var2, float var4, double var5);

        public Pointer testStructurePointerArgument(CheckFieldAlignment var1);

        public int testStructureByValueArgument(CheckFieldAlignment.ByValue var1);

        public int testStructureArrayInitialization(CheckFieldAlignment[] var1, int var2);

        public int testStructureByReferenceArrayInitialization(CheckFieldAlignment.ByReference[] var1, int var2);

        public void modifyStructureArray(CheckFieldAlignment[] var1, int var2);

        public void modifyStructureByReferenceArray(CheckFieldAlignment.ByReference[] var1, int var2);

        public int fillInt8Buffer(byte[] var1, int var2, byte var3);

        public int fillInt16Buffer(short[] var1, int var2, short var3);

        public int fillInt32Buffer(int[] var1, int var2, int var3);

        public int fillInt64Buffer(long[] var1, int var2, long var3);

        public int fillFloatBuffer(float[] var1, int var2, float var3);

        public int fillDoubleBuffer(double[] var1, int var2, double var3);

        public boolean returnBooleanArgument(Object var1);

        public Pointer testStructurePointerArgument(MinTestStructure var1);

        public String returnStringFromVariableSizedStructure(VariableSizedStructure var1);

        public void setCallbackInStruct(CbStruct var1);

        public TestUnion testUnionByValueCallbackArgument(UnionCallback var1, TestUnion var2);

        public static interface UnionCallback
        extends Callback {
            public TestUnion invoke(TestUnion var1);
        }

        public static class TestUnion
        extends Union
        implements Structure.ByValue {
            public String f1;
            public int f2;
        }

        public static class CbStruct
        extends Structure {
            public TestCallback cb;

            protected List getFieldOrder() {
                return Arrays.asList("cb");
            }

            public static interface TestCallback
            extends Callback {
                public int callback(int var1, int var2);
            }
        }

        public static class VariableSizedStructure
        extends Structure {
            public int length;
            public byte[] buffer;

            protected List getFieldOrder() {
                return Arrays.asList("length", "buffer");
            }

            public VariableSizedStructure(String arg) {
                this.length = arg.length() + 1;
                this.buffer = new byte[this.length];
                System.arraycopy(arg.getBytes(), 0, this.buffer, 0, arg.length());
            }
        }

        public static class MinTestStructure
        extends Structure {
            public int field;

            protected List getFieldOrder() {
                return Arrays.asList("field");
            }
        }

        public static class TestPointerType
        extends PointerType {
            public TestPointerType() {
            }

            public TestPointerType(Pointer p) {
                super(p);
            }
        }

        public static class CheckFieldAlignment
        extends Structure {
            public byte int8Field = (byte)this.fieldOffset("int8Field");
            public short int16Field = (short)this.fieldOffset("int16Field");
            public int int32Field = this.fieldOffset("int32Field");
            public long int64Field = this.fieldOffset("int64Field");
            public float floatField = this.fieldOffset("floatField");
            public double doubleField = this.fieldOffset("doubleField");

            public List getFieldOrder() {
                return Arrays.asList("int8Field", "int16Field", "int32Field", "int64Field", "floatField", "doubleField");
            }

            public static class ByReference
            extends CheckFieldAlignment
            implements Structure.ByReference {
            }

            public static class ByValue
            extends CheckFieldAlignment
            implements Structure.ByValue {
            }
        }
    }
}

