#include "hello.h"

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef _WIN32
#include <direct.h>
#endif


using namespace std;

CORBA::ULong state = 0;

class MyClientInterceptor
    : virtual public PortableInterceptor::ClientRequestInterceptor,
      virtual public CORBA::LocalObject
{
    string nm;
public:
    MyClientInterceptor()
    { nm = ""; }

    MyClientInterceptor(char * name)
    { nm = name; }
	
    char* name()
    { return CORBA::string_dup(nm.c_str()); }

    void destroy()
    { cerr << this->name() << " destroy" << endl; }

    void send_request(PortableInterceptor::ClientRequestInfo_ptr ri)
    {
	cout << "client: send_request" << endl;
	if (state == 0 && nm == "MyInterceptor") {
	    cout << "MyInterceptor throws NO_PERMISSION exception" << endl;
	    mico_throw(CORBA::NO_PERMISSION());
	}
    }
    
    void send_poll(PortableInterceptor::ClientRequestInfo_ptr ri)
    {
	cout << "client: send_poll" << endl;
    }
    
    void receive_reply(PortableInterceptor::ClientRequestInfo_ptr ri)
    {
	cout << "client: receive_reply" << endl;
	if (state == 1 && nm == "MyInterceptor") {
	    cout << "MyInterceptor throws NO_PERMISSION exception" << endl;
	    mico_throw(CORBA::NO_PERMISSION());
	}
    }
    
    void receive_exception(PortableInterceptor::ClientRequestInfo_ptr ri)
    {
	cout << "client: receive_exception: " << ri->received_exception_id() << endl;
	if (nm == "MyInterceptor2") {
	    cout << "MyInterceptor2 throws NO_RESOURCES exception" << endl;
	    mico_throw(CORBA::NO_RESOURCES());
	}
	if (nm == "MyInterceptor3") {
	    cout << "MyInterceptor3 throws NO_MEMORY exception" << endl;
	    mico_throw(CORBA::NO_MEMORY());
	}
    }
    
    void receive_other(PortableInterceptor::ClientRequestInfo_ptr ri)
    {
	cout << "client: receive_other" << endl;
	if (state == 2 && nm == "MyInterceptor") {
	    cout << "MyInterceptor throws NO_PERMISSION exception" << endl;
	    mico_throw(CORBA::NO_PERMISSION());
	}
    }
};

class MyInitializer
    : virtual public PortableInterceptor::ORBInitializer,
      virtual public CORBA::LocalObject
{
public:
    MyInitializer() {}
    ~MyInitializer() {}

    virtual void pre_init(PortableInterceptor::ORBInitInfo_ptr info)
    {
    	// register interceptor	
    	MyClientInterceptor * interceptor = new MyClientInterceptor("MyInterceptor");
    	info->add_client_request_interceptor(interceptor);
	MyClientInterceptor * interceptor2 = new MyClientInterceptor("MyInterceptor2");
	info->add_client_request_interceptor(interceptor2);
	MyClientInterceptor * interceptor3 = new MyClientInterceptor("MyInterceptor3");
	info->add_client_request_interceptor(interceptor3);
    }
    
    virtual void post_init(PortableInterceptor::ORBInitInfo_ptr info)
    {
    	// nothing
    }
};


int
main (int argc, char *argv[])
{
    MyInitializer* ini = new MyInitializer;
    PortableInterceptor::register_orb_initializer(ini);

    CORBA::ORB_var orb = CORBA::ORB_init (argc, argv);

    char pwd[256], uri[300];
    sprintf (uri, "file://%s/hello.ref", getcwd(pwd, 256));

    CORBA::Object_var obj = orb->string_to_object (uri);
    assert(!CORBA::is_nil(obj));
    CORBA::Request_var req = CORBA::Request::_nil();
    try {
	req = obj->_request("hello");
	req->result()->value()->set_type(CORBA::_tc_void);
	req->send_deferred();
	//req->poll_response();
	req->get_response();
    } catch (CORBA::Exception& ex) {
	cout << "client: caught: " << ex._repoid() << endl;
    }
    if (!CORBA::is_nil(req) && req->env()->exception() != NULL) {
	cout << "exception set in req->env(): "
	     << req->env()->exception()->_repoid() << endl;
    }
    state = 1;
    try {
	req = obj->_request("hello");
	req->result()->value()->set_type(CORBA::_tc_void);
	req->send_deferred();
	//req->poll_response();
	req->get_response();
    } catch (CORBA::Exception& ex) {
	cout << "client: caught: " << ex._repoid() << endl;
    }
    if (!CORBA::is_nil(req) && req->env()->exception() != NULL) {
	cout << "exception set in req->env(): "
	     << req->env()->exception()->_repoid() << endl;
    }
    state = 2;
    try {
	req = obj->_request("oneway_hello");
	req->result()->value()->set_type(CORBA::_tc_void);
	req->send_oneway();
	//req->poll_response();
	req->get_response();
    } catch (CORBA::Exception& ex) {
	cout << "client: caught: " << ex._repoid() << endl;
    }
    if (!CORBA::is_nil(req) && req->env()->exception() != NULL) {
	cout << "exception set in req->env(): "
	     << req->env()->exception()->_repoid() << endl;
    }
    return 0;
}




