//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: PDEProblem.hpp,v 1.2 2003/09/20 21:31:09 delpinux Exp $

#ifndef PDEPROBLEM_H
#define PDEPROBLEM_H

#include <PDE.hpp>
#include <BoundaryConditionSet.hpp>

#include <StreamCenter.hpp>

 /*!
  \class PDEProblem

  This is the base to define PDE problems.

  \author Stphane Del Pino
*/
class PDEProblem
{
private:
  //! A given PDE.
  ConstReferenceCounting<PDE> __pde;

  //! A set of boudary conditions.
  ReferenceCounting<BoundaryConditionSet> __boundaryConditionSet;

public:
  //! Read only access function to the ith equation of the PDEProblem
  const PDE& pde() const
  {
    return *__pde;
  }

  //! Read only access function to the boundary condition set
  const BoundaryConditionSet& boundaryConditionSet() const
  {
    return *__boundaryConditionSet;
  }

  ReferenceCounting<PDEProblem> operator * (ConstReferenceCounting<UserFunction> u) const
  {
    PDEProblem* newPDEProblem = new PDEProblem(*this);
    (*newPDEProblem).__pde = (*__pde) * u;
    return newPDEProblem;
  }

  friend std::ostream& operator << (std::ostream& os,
				    const PDEProblem& P)
  {
    os << *P.__pde << '\n';
    os << *P.__boundaryConditionSet;
    return os;
  }

  PDEProblem(ReferenceCounting<PDE> pde,
	     ReferenceCounting<BoundaryConditionSet> boundaryConditionSet)
    : __pde(pde),
      __boundaryConditionSet(boundaryConditionSet)
  {
    ;
  }

  PDEProblem(const PDEProblem& pdePb)
    : __pde(pdePb.__pde),
      __boundaryConditionSet(pdePb.__boundaryConditionSet)
  {
    ;
  }

  virtual ~PDEProblem()
  {
    ;
  }
};

#endif

