//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: PDEOperatorSum.hpp,v 1.3 2003/09/21 14:34:18 delpinux Exp $

// Implement the sum of scalar PDE Operators

#ifndef _PDEOPERATORSUM_HPP_
#define _PDEOPERATORSUM_HPP_

#include <vector>

#include <StreamCenter.hpp>

#include <PDEOperator.hpp>
#include <ReferenceCounting.hpp>
/*!
  \class PDEOperatorSum

  This class is used to descibe the sum of PDEOperators.

  \author Stphane Del Pino.
*/
class PDEOperatorSum
{
  //! The list of PDEOperator sum.
  std::vector<ReferenceCounting<PDEOperator> > __operators;

public:
  //! returns the number of operators contained in the sum.
  size_t nbOperators() const
  {
    return __operators.size();
  }

  ReferenceCounting<PDEOperatorSum> operator* (ConstReferenceCounting<UserFunction> u) const
  {
    PDEOperatorSum* newPDEOperatorSum = new PDEOperatorSum();
    newPDEOperatorSum->__operators.reserve(__operators.size());

    for (std::vector<ReferenceCounting<PDEOperator> >::const_iterator i = __operators.begin();
	 i != __operators.end(); ++i) {
      newPDEOperatorSum->add((*(*i))*u);
    }

    return newPDEOperatorSum;
  }

  //! Returns the ith embeded operator.
  ReferenceCounting<PDEOperator> operator[](const size_t& i) const
  {
    assert (i<__operators.size());
    return (__operators[i]);
  }

  const PDEOperatorSum& operator = (const PDEOperatorSum& pdeOpSum)
  {
    __operators.resize(pdeOpSum.__operators.size());
    std::copy(pdeOpSum.__operators.begin(),
	      pdeOpSum.__operators.end(),
	      __operators.begin());

    return *this; 
  }

  friend std::ostream& operator << (std::ostream& os,
				    const PDEOperatorSum& pdeOpSum)
  {
    if (pdeOpSum.__operators.size() > 0) {
      os << *(pdeOpSum.__operators[0]);
      for (size_t i=1; i<pdeOpSum.__operators.size(); ++i)
	os << '+' << *(pdeOpSum.__operators[i]);
    } else {
      os << 0;
    }

    return os;
  }

  void add(ReferenceCounting<PDEOperator> anOperator)
  {
    __operators.push_back(anOperator);
  }

  //! Default constructor.
  PDEOperatorSum()
  {
    ;
  }

  //! Destructor.
  ~PDEOperatorSum()
  {
    ;
  }
};

#endif // _PDEOPERATORSUM_HPP_

