//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: Normal.cpp,v 1.1 2005/10/30 23:14:04 delpinux Exp $

#include <Normal.hpp>
#include <NormalManager.hpp>
#include <ErrorHandler.hpp>

real_t
Normal::operator()(const real_t& x,
		   const real_t& y,
		   const real_t& z) const
{
  switch(__componentType) {
  case Normal::x: {
    return NormalManager::instance().nx();
  }
  case Normal::y: {
    return NormalManager::instance().ny();
  }
  case Normal::z: {
    return NormalManager::instance().nz();
  }
  case Normal::undefined: {
    throw ErrorHandler(__FILE__,__LINE__,
		       "No normal is defined",
		       ErrorHandler::normal);
  }
  }
  return 0;
}
