//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: VariableList.hpp,v 1.2 2004/12/31 14:00:47 delpinux Exp $

#ifndef VARIABLE_LIST_HPP
#define VARIABLE_LIST_HPP

#include <map>

#include <ReferenceCounting.hpp>
#include <Variable.hpp>

#include <Stringify.hpp>
#include <ErrorHandler.hpp>

class VariableList
{
private:
  //! The container of variables.
  typedef std::map<std::string,ReferenceCounting<Variable> > Container;
  VariableList::Container __variableList;

public:
  inline ReferenceCounting<Variable> find(const std::string& name) const
  {
    VariableList::Container::const_iterator i = __variableList.find(name);
    if (i == __variableList.end()) {
      return 0;
    } else {
      return i->second;
    } 
  }

  void change(ReferenceCounting<Variable> V)
  {
    VariableList::Container::iterator i
      = __variableList.find((*V).name().c_str());

    if (i == __variableList.end()) {
      const std::string errorMsg
	= "cannot modify variable "+stringify((*V).name())
	+", since it is not declared";

      throw ErrorHandler(__FILE__,__LINE__,
			 errorMsg,
			 ErrorHandler::normal);
    } else {
      i->second = V;
    } 
  }

  void add(ReferenceCounting<Variable> v)
  {
    __variableList[(*v).name()]=v;
  }

  void remove(const std::string& name)
  {
    __variableList.erase(name);
  }

  void clear()
  {
    __variableList.clear();
  }

  VariableList()
  {
    ;
  }

  ~VariableList()
  {
    ;
  }
};

#endif // VARIABLE_LIST_HPP

