//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: UnknownListExpression.cpp,v 1.4 2005/09/25 13:57:34 delpinux Exp $

#include <Variable.hpp>
#include <UnknownListExpression.hpp>

#include <VariableList.hpp>

// A pointer to the lexer.
extern VariableList variableList;

std::ostream& UnknownListExpressionSet::put(std::ostream& os) const
{
  os << '[';
  for (listType::const_iterator i = __list.begin(); i != __list.end(); ++i) {
    const FunctionExpressionVariable& u
      = static_cast<const FunctionExpressionVariable&>((**i));
    if (i != __list.begin()) {
      os << ',';
    }
    os << (*u.variable()).name() << ':';
    switch(u.discretizationType()) {
    case DiscretizationType::LagrangianFEM1: {
      os << "P1";
      break;
    }
    case DiscretizationType::LagrangianFEM2: {
      os << "P2";
      break;
    }
    default: {
      throw ErrorHandler(__FILE__,__LINE__,
			 "not implemented",
			 ErrorHandler::unexpected);
    }
    }
  }
  os << ']';
  return os;
}


void UnknownListExpressionSet::unknownsDeclare()
{
  for (listType::iterator i = __list.begin(); i != __list.end(); ++i) {
    FunctionExpressionVariable& u
      = dynamic_cast<FunctionExpressionVariable&>((*(*i)));

    u.subscribe();

    bool isVariable = (variableList.find((*u.variable()).name()) != 0);

    if (!isVariable) {
      ReferenceCounting<Variable> newVariable
	= &dynamic_cast<FunctionVariable&>(*u.variable());
      variableList.add(newVariable);
    }
  }
}

void UnknownListExpressionSet::unknownsUndeclare()
{
  for (listType::iterator i = __list.begin(); i != __list.end(); ++i) {
    FunctionExpressionVariable& u
      = dynamic_cast<FunctionExpressionVariable&>((*(*i)));

    u.unsubscribe();
  }
}

