//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: IntegratedOperatorExpression.hpp,v 1.3 2005/10/16 21:52:16 delpinux Exp $

#ifndef INTEGRATED_OPERATOR_EXPRESSION_HPP
#define INTEGRATED_OPERATOR_EXPRESSION_HPP

#include <Expression.hpp>
#include <IntegratedExpression.hpp>

class IntegratedOperatorExpression
  : public Expression
{
public:
  enum OperatorType {
    undefined,
    orderZero,
    gradient,
    dx,
    dy,
    dz
  };

private:
  const OperatorType __operatorType;

protected:
  ReferenceCounting<IntegratedExpression> __integratedExpression;

public:
  const OperatorType operatorType() const
  {
    return __operatorType;
  }

  ReferenceCounting<IntegratedExpression> integratedExpression()
  {
    return __integratedExpression;
  }

  IntegratedOperatorExpression(const IntegratedOperatorExpression::
			       OperatorType t,
			       ReferenceCounting<IntegratedExpression> i)
    : Expression(Expression::integratedOperator),
      __operatorType(t),
      __integratedExpression(i)
  {
    ;
  }

  IntegratedOperatorExpression(const IntegratedOperatorExpression& I)
    : Expression(I),
      __operatorType(I.__operatorType),
      __integratedExpression(I.__integratedExpression)
  {
    ;
  }

  virtual ~IntegratedOperatorExpression()
  {
    ;
  }
};


class IntegratedOperatorExpressionOrderZero
  : public IntegratedOperatorExpression
{
private:
  std::ostream& put(std::ostream& os) const
  {
    os << *__integratedExpression;
    return os;
  }
public:

  void execute()
  {
    ;
  }

  IntegratedOperatorExpressionOrderZero(ReferenceCounting<IntegratedExpression> I)
    : IntegratedOperatorExpression(IntegratedOperatorExpression::orderZero,
				   I)
  {
    ;
  }

  IntegratedOperatorExpressionOrderZero(const IntegratedOperatorExpressionOrderZero& I)
    : IntegratedOperatorExpression(I)
  {
    ;
  }

  ~IntegratedOperatorExpressionOrderZero()
  {
    ;
  }
};


class IntegratedOperatorExpressionGrad
  : public IntegratedOperatorExpression
{
private:
  std::ostream& put(std::ostream& os) const
  {
    os << "grad(" << *__integratedExpression << ')';
    return os;
  }
public:

  void execute()
  {
    ;
  }

  IntegratedOperatorExpressionGrad(ReferenceCounting<IntegratedExpression> I)
    : IntegratedOperatorExpression(IntegratedOperatorExpression::gradient, I)
  {
    ;
  }

  IntegratedOperatorExpressionGrad(const IntegratedOperatorExpressionGrad& I)
    : IntegratedOperatorExpression(I)
  {
    ;
  }

  ~IntegratedOperatorExpressionGrad()
  {
    ;
  }
};

class IntegratedOperatorExpressionDx
  : public IntegratedOperatorExpression
{
private:
  std::ostream& put(std::ostream& os) const
  {
    os << "dx(" << *__integratedExpression << ')';
    return os;
  }
public:

  void execute()
  {
    ;
  }

  IntegratedOperatorExpressionDx(ReferenceCounting<IntegratedExpression> I)
    : IntegratedOperatorExpression(IntegratedOperatorExpression::dx, I)
  {
    ;
  }

  IntegratedOperatorExpressionDx(const IntegratedOperatorExpressionDx& I)
    : IntegratedOperatorExpression(I)
  {
    ;
  }

  ~IntegratedOperatorExpressionDx()
  {
    ;
  }
};

class IntegratedOperatorExpressionDy
  : public IntegratedOperatorExpression
{
private:
  std::ostream& put(std::ostream& os) const
  {
    os << "dy(" << *__integratedExpression << ')';
    return os;
  }
public:

  void execute()
  {
    ;
  }

  IntegratedOperatorExpressionDy(ReferenceCounting<IntegratedExpression> I)
    : IntegratedOperatorExpression(IntegratedOperatorExpression::dy, I)
  {
    ;
  }

  IntegratedOperatorExpressionDy(const IntegratedOperatorExpressionDy& I)
    : IntegratedOperatorExpression(I)
  {
    ;
  }

  ~IntegratedOperatorExpressionDy()
  {
    ;
  }
};

class IntegratedOperatorExpressionDz
  : public IntegratedOperatorExpression
{
private:
  std::ostream& put(std::ostream& os) const
  {
    os << "dz(" << *__integratedExpression << ')';
    return os;
  }
public:

  void execute()
  {
    ;
  }

  IntegratedOperatorExpressionDz(ReferenceCounting<IntegratedExpression> I)
    : IntegratedOperatorExpression(IntegratedOperatorExpression::dz, I)
  {
    ;
  }

  IntegratedOperatorExpressionDz(const IntegratedOperatorExpressionDz& I)
    : IntegratedOperatorExpression(I)
  {
    ;
  }

  ~IntegratedOperatorExpressionDz()
  {
    ;
  }
};


#endif // INTEGRATED_OPERATOR_EXPRESSION_HPP

