//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: Information.hpp,v 1.3 2004/11/28 17:55:42 delpinux Exp $

#ifndef INFORMATION_HPP
#define INFORMATION_HPP

#include <ReferenceCounting.hpp>
class MeshExpression;
class Scene;
class UnknownListExpression;

#include <stack>
#include <StaticBase.hpp>

/**
 * @file   Information.hpp
 * @author Stephane Del Pino
 * @date   Sun Nov 28 15:07:51 2004
 * 
 * @brief Contains informations related to ff3d's behaviour
 * 
 * 
 */

class Information
  : public StaticBase<Information>
{
private:
  typedef StaticBase<Information> Mother;
  /// if not NULL contains the mesh which is used in the instruction
  std::stack<ReferenceCounting<MeshExpression> > __mesh;

  /// the last defined scene.
  ReferenceCounting<Scene> __scene;

  /// The current Unknown list.
  ReferenceCounting<UnknownListExpression> __unknownListExpression;

  /// Choose which algorithm is used for surface mesh generation. If
  /// true, does not use mesh intersection algorithm.
  bool __coarseMesh;

public:
  ReferenceCounting<MeshExpression> getMesh();

  void setMesh(ReferenceCounting<MeshExpression> mesh);

  void unsetMesh();

  const bool usesMesh() const;

  ReferenceCounting<UnknownListExpression> getUnknownList();

  void setUnknownList(ReferenceCounting<UnknownListExpression> ul);

  void unsetUnknownList();

  const bool usesUnknownList() const;

  ReferenceCounting<Scene> getScene();

  void setScene(ReferenceCounting<Scene> scene);

  void unsetScene();

  const bool usesScene() const;

  void setCoarseMesh(const bool& b);

  const bool& coarseMesh() const;

  Information();

  Information(const Information& I);

  ~Information();
};

#endif // INFORMATION_HPP
