#include <time.h>
#include <stdlib.h>
 
enum typeclause{rule,constraint};

/////////////////////////////////////////////////////////////////////////////
//An object of this class is a clause (a rule or a constraint)
class CLAUSEID
  {  
 public:
  typeclause clause;
  unsigned index;
   
  CLAUSEID(typeclause clause2=rule,unsigned j=0):
    clause(clause2),
    index(j)
    {}

  };

//////////////////////////////////////////////////////////////////////////////
// A container of unsatisfied clauses
class UNSATISFIED
  {
  unsigned numunsat;
  CLAUSEID * Unsat;
  size_t * OffsetRules;
  size_t * OffsetConstraints;

 public:

  UNSATISFIED(unsigned r, unsigned c)
    {
    numunsat=0;
    Unsat = new CLAUSEID[r+c];
    OffsetRules = new size_t[r];
    OffsetConstraints = new size_t[c];
    }

  void reset()
    {
    numunsat=0;
    }
  
  void add(const CLAUSEID& clauseid)
    {
    numunsat++;
    Unsat[numunsat-1]=clauseid;
    if(clauseid.clause==rule)
      OffsetRules[clauseid.index]=numunsat-1;
    else
      OffsetConstraints[clauseid.index]=numunsat-1;

    }
   
  void remove(const CLAUSEID& clauseid)
    { 
    assert(numunsat>0);	   
    unsigned i;
    if (clauseid.clause==rule)
      {
      i=OffsetRules[clauseid.index];
	
      }
    else
      {
      i=OffsetConstraints[clauseid.index];
	
      }
    Unsat[i]=Unsat[numunsat-1];
    numunsat--;
    CLAUSEID clauseid2 = Unsat[i];
    if (clauseid2.clause==rule)
      OffsetRules[clauseid2.index]=i;
    else
      OffsetConstraints[clauseid2.index]=i;
     
    }

  CLAUSEID choose()
    { 
    assert(numunsat>0);
    unsigned random=rand()%numunsat;
    return Unsat[random];
    }

  ~UNSATISFIED()
    {
    delete [] OffsetRules;
    delete [] OffsetConstraints;
    delete [] Unsat;
    }
  };

//////////////////////////////////////////////////////////////////////////////
// A container of unsupported atoms
class UNSUPPORTEDATOMS
  {
  unsigned numunsupported;
  unsigned* Unsupported;
  size_t * OffsetAtoms;
  unsigned dimensione;
 public:

  UNSUPPORTEDATOMS(unsigned a)
    { 
    numunsupported=0;
    Unsupported = new unsigned[a];
    OffsetAtoms = new size_t[a];
    dimensione=a;
    }

  void reset()
    {
    numunsupported=0;
    }
  
  void add(unsigned indexatom)
    {
    assert(numunsupported<dimensione);
    numunsupported++;
    Unsupported[numunsupported-1]=indexatom;
    OffsetAtoms[indexatom]=numunsupported-1;
    GATOM atom(indexatom);
    if (TraceLevel>=3)
      cdebug<<atom<< " is unsupported"<<endl;
    // cdebug<<" " <<numunsupported<<endl;
    }
  
  void remove(unsigned indexatom)
    { 
    assert(numunsupported>0);	 
    if (TraceLevel>=3)
      cdebug<<GATOM(indexatom)<<" e' rimosso "<<endl; 
    unsigned i;
    i=OffsetAtoms[indexatom];
    Unsupported[i]=Unsupported[numunsupported-1];
    numunsupported--;
    unsigned indexatom2 = Unsupported[i];
    OffsetAtoms[indexatom2]=i;
    }

  unsigned choose()
    { 
    assert(numunsupported>0);
    unsigned random=rand()%numunsupported;
    return Unsupported[random];
    }
  
  unsigned Size()
    {
    assert(numunsupported<dimensione);
    return numunsupported;
    }
  
  ~UNSUPPORTEDATOMS()
    {
    delete [] OffsetAtoms;
    delete [] Unsupported;
    }
  };

double guessprobability()
  {
  double random = rand();
  return random/32767;
  }
















