%{
///////////////////
//  SQL2DL - Translate SQL queries to datalog queries
//
// Wolfgang Faber
//
///////////////////


//
// Scanner
//

// We don't need unput, and it can yield a "defined but not used"-warning.
#define YY_NO_UNPUT

#include "sql.h"
#include "sql_parser.h"


void sqlyyerror(char *s);
extern int sqlyydebug;

%}

%%

(WITH|with) 		{ return WITH; }
(RECURSIVE|recursive)	{ return RECURSIVE; }
(AS|as)			{ return AS; }
(UNION|union)		{ return UNION; }
(EXCEPT|except)		{ return EXCEPT; }
(ALL|all)		{ return ALL; }
(INTERSECT|intersect)	{ return INTERSECT;}
(SELECT|select)		{ return SELECT; }
(DISTINCT|distinct)	{ return DISTINCT; }
(FROM|from)		{ return FROM; }
(TABLE|table)		{ return TABLE; }
(WHERE|where)		{ return WHERE; }
(BETWEEN|between)	{ return BETWEEN; }
(VALUES|values)		{ return VALUES; }
(IN|in)			{ return IN; }
(DATALOG-SCHEMA|datalog-schema)	{ return DATALOGSCHEMA; }
(DATALOGSCHEMA|datalogschema)	{ return DATALOGSCHEMA; }
(DATALOG[ ]SCHEMA|datalog[ ]schema)	{ return DATALOGSCHEMA;}
(AND|and)		{ return AND; }
(OR|or)			{ return OR; }
(UNLESS|unless)		{ return UNLESS; }
(SUCH|such)		{ return SUCH; }
(THAT|that)		{ return THAT; }
(EXISTS|exists)		{ return EXISTS; }

"="		{ sqlyylval.subtok = OP_EQ; return COMPARISON; }
"<>"		{ sqlyylval.subtok = OP_NEQ; return COMPARISON; }
"<"		{ sqlyylval.subtok = OP_LT; return COMPARISON; }
">"		{ sqlyylval.subtok = OP_GT; return COMPARISON; }
"<="		{ sqlyylval.subtok = OP_LEQ; return COMPARISON; }
">="		{ sqlyylval.subtok = OP_GEQ; return COMPARISON; }

[-+*/:(),.;]	{ return yytext[0]; }

	/* names */

[A-Za-z][A-Za-z0-9_]*	{ sqlyytext[sqlyyleng] = '\0'; \
                          sqlyylval.strval = (new string(sqlyytext)); \
                          return NAME; }

	/* numbers */

[0-9]+	|
[0-9]+"."[0-9]* |
"."[0-9]*	{ return INTNUM; }

[0-9]+[eE][+-]?[0-9]+	|
[0-9]+"."[0-9]*[eE][+-]?[0-9]+ |
"."[0-9]*[eE][+-]?[0-9]+	{ return APPROXNUM; }

	/* strings */

'[^'\n]*'	{
#ifdef NEVER
		int c = input();

		unput(c);	/* just peeking */
		if(c != '\'') {
			return STRING;
		} else
			sqlyymore();
#endif
	}
		
'[^'\n]*$	{ sqlyyerror("Unterminated string"); }

\n		parser_line++;

[ \t\r]+	;	/* white space */

"--".*$		;	/* comment */

%%

void sqlyyerror(char *s)
{
	cout << parser_line << ": " << s << " at " << sqlyytext << endl;
}

