%{
//////////////////////////////////////////////////////////////////////////////
// sql_parser.y

#include "sql.h"
#include "dl.h"

%}

%union {
  int intval;
  double floatval;
  string *strval;
  int subtok;
  Attributes *attrl;
  SelectList *selectl;
  SSC_Tree *selectitemt;
}


%token NAME
%token STRING
%token INTNUM 
%token APPROXNUM

%token OR
%token AND
%token NOT


/*%left OR
%left AND
%left NOT */
%left <subtok> COMPARISON /* = <> < > <= >= */
%left '+' '-'
%left '*' '/'
%nonassoc UMINUS

%token WITH RECURSIVE AS UNION EXCEPT ALL INTERSECT SELECT DISTINCT FROM
%token TABLE WHERE BETWEEN VALUES IN DATALOGSCHEMA UNLESS SUCH THAT EXISTS

%type <attrl> dl_attributelist column_name_list with_column_list
%type <attrl> opt_with_column_spec
%type <intval> sign
%type <strval> opt_as_correlation
%type <selectl> select_list select_sublist
%type <selectitemt> select_sublist_item derived_column value_expression
%type <selectitemt> numeric_value_expression term factor numeric_primary
%type <selectitemt> item_reference value_expression_primary column_reference
%type <selectitemt> opt_where_clause search_condition boolean_primary
%type <selectitemt> boolean_value_expression boolean_simple_expression
%type <selectitemt> boolean_term boolean_factor predicate
%type <selectitemt> comparison_predicate row_value_expression
%type <selectitemt> value_specification general_value_specification
%type <selectitemt> table_expression

%start init

%%

init:
		{

		  // initialize global datastructures

		  sql_schemata = new Schemata();

		  querynames = new Querynames();

		  correlations = new Correlations();
		  
		  attribute_affiliations = new AttributeAffiliations();

		  correlations_reverse = new CorrelationsReverse();
		  
		  predicate_names = new NameSpace(SQL_INTERNAL_NAME_PREFIX);
		  variable_names = new NameSpace(SQL_INTERNAL_VARNAME_PREFIX);

		  current_bindings = new Bindings();

		  head_arguments = new HeadArguments();

		  // prepare for the first statement
		  // get a new predicatename
		  querynames->push_back(predicate_names->get());

		  // By default, the first query is the one which will be 
		  // printed out by dl
		  SQL_Interesting_Predicate = querynames->front();

#ifdef BISON_DEBUG
		  sqlyydebug=1;
#endif

		  // query_spec_nesting describes how many levels of 
		  // subqueries are allowed. Negative values stand for
		  // unlimited nesting.
		  query_spec_nesting = -1;

		} 
		sql_list
                {
		  // clean up

		  delete sql_schemata;

		  delete querynames;

		  delete correlations;
		  
		  delete attribute_affiliations;

		  delete correlations_reverse;
		  
		  delete predicate_names;
		  delete variable_names;

		  delete current_bindings;

		  delete head_arguments;

		}

	;

sql_list:
		sql ';'
	|	
		sql_list sql ';'
	;

sql:
		query_expression	
                  {
		    // ok, finished one query, prepare for the next one
		    // assign a new name for the query
		    querynames->push_back(predicate_names->get());
		  }
	|	
		meta_statement
	;

meta_statement:
		DATALOGSCHEMA 
		dl_schemalist
	;

dl_schemalist:
		NAME '(' 
		dl_attributelist ')' 
                  {
		    // A new datalog schema is entered.

		    // NOTE: If an old schema with identical name existed
		    //       before, this fact is silently ignored by now.

		    (*sql_schemata)[*$<strval>1] = *$3;

		    // insert the attributes for an attributes->relation
		    // lookup

		    for (Attributes::iterator i = $3->begin();
			 !(i == $3->end());
			 i++)
		      {
			

			attribute_affiliations->insert(make_broken_pair(*i,*$<strval>1));
			
		      }

		  }
        |	
		NAME '(' 
		dl_attributelist ')' ',' 
		dl_schemalist 
                  {
		    // A new datalog schema is entered.

		    // NOTE: If an old schema with identical name existed
		    //       before, this fact is silently ignored by now.

		    (*sql_schemata)[*$<strval>1] = *$3;

		    // insert the attributes for an attributes->relation
		    // lookup

		    for (Attributes::iterator i = $3->begin();
			 !(i == $3->end());
			 i++)
		      {
			attribute_affiliations->insert(make_broken_pair(*i,*$<strval>1));
		      }
		  }
	;

dl_attributelist:
		NAME 
                  {
		    // Create an Attributes object and insert the name

		    Attributes* att = new Attributes();
		    att->push_back(*$<strval>1);
		    $$ = att;
		  }
        |	
		dl_attributelist ',' 
		NAME 
                  {
		    // insert the name in Attributes generated by 
		    // dl_attributelist
		    $1->push_back(*$<strval>3);
		    $$ = $1;
		  }
	;

/* End of Metastatements section */

query_expression:
		with_query_expression
        |       
		simple_query_expression   /* This is not in the standard */
        ;

with_query_expression:
                with_clause with_constraints with_query_expression_body
	;

simple_query_expression:               
                /* Otherwise shift reduce conflicts */
		simple_non_join_query_expression
        ;

with_query_expression_body:
		with_query_expression
	|	
		non_join_query_term
/*	|	
	        joined_table */
	|	
		query_expression_body_setop
	;


query_expression_body_setop:
		non_join_query_term 
		UNION 
		opt_all 
		opt_corresponding_spec 
		query_expression_body_setop_tail
	|	
		non_join_query_term 
		EXCEPT 
		opt_all 
		opt_corresponding_spec 
		query_expression_body_setop_tail
	;

query_expression_body_setop_tail:
		query_term
	|	
		query_term 
		UNION 
		opt_all 
		opt_corresponding_spec 
		query_expression_body_setop_tail
	|	
		query_term 
		EXCEPT 
		opt_all 
		opt_corresponding_spec 
		query_expression_body_setop_tail
	;

simple_non_join_query_expression:
		non_join_query_term
	|	
		query_expression_body_setop
	;

non_join_query_expression:
		simple_non_join_query_expression
/*		
	|
                non_join_query_term
	|	
		query_expression 
		UNION 
		opt_all 
		opt_corresponding_spec 
		query_term
	|	
		query_expression 
		EXCEPT 
		opt_all
		opt_corresponding_spec
		query_term
*/
	;

opt_all:
		/* empty */
	|	
		ALL
	;

opt_corresponding_spec:		/* not yet implemented */
		/* empty */
	;

non_join_query_term:
		non_join_query_primary
	|	
		query_term 
		INTERSECT 
		opt_all 
		opt_corresponding_spec 
		query_primary 
	;

non_join_query_primary:
		simple_table
	|	
		'(' non_join_query_expression ')'
	;

simple_table:
		query_specification
	|	
		table_value_constructor
	|	
		explicit_table
	;

with_clause:
                WITH opt_recursive with_list
        ;


opt_recursive:
		/* empty */
	|	
		RECURSIVE
	;


with_list: 
		with_list_element
	|	
		with_list ',' 
		with_list_element
	;

with_list_element:
		NAME /* was query_name */ 
		opt_with_column_spec AS '(' 
                  { 
		    // This is a new query
		    querynames->push_back(*$<strval>1);

		    // Since the query might be recursive
		    // we remember it as a relation scheme
		    (*sql_schemata)[*$<strval>1] = *$2;
		    // record attribute affiliations
		    for(Attributes::iterator i = $2->begin();
			!(i == $2->end());
			i++)
		      {
			attribute_affiliations->insert(make_broken_pair(*i,*$<strval>1));
		      }
		  } 
                query_expression ')' 
                  {
		    // retract the queryname
		    querynames->pop_back();
		  } 
                /* opt_search_or_cycle_clause */
	;

/*
query_name:
		NAME
	;
*/

opt_with_column_spec:
		/* empty */ 
                  {
		    // create empty Attributes
		    $$ = new Attributes();
		  }
	|	
		'(' with_column_list ')'  
                  {
		    // hand over Attributes
		    $$ = $2;
		  }
	;

with_column_list:
		column_name_list 
                  {
		    // hand over Attributes
		    $$ = $1;
		  }
	;

column_name_list:
		NAME 
		  {
		    // create new Attributes and insert the first one
		    Attributes* att = new Attributes();
		    att->push_back(*$<strval>1);
		    $$ = att;
		  }
	|	
		column_name_list ',' 
		NAME 
		  {
		    // insert the next attribute in Attributes from 
		    // previous column_names
		    $1->push_back(*$<strval>3);
		    $$ = $1;
		  }
	;

/*
column_name:
		NAME
	;
*/

/*
opt_search_or_cycle_clause:
	;
*/


query_specification:
		SELECT opt_set_quantifier select_list table_expression 
		  {
		    // generate Datalog rules
		    ($3)->process();
		    conditions_proc(*$4);
		    if(FTraceLevel >= 1) print_rules(querynames->back());
		    integrate_rules(querynames->back());
		    correlations_reverse->erase(correlations_reverse->begin(),
						correlations_reverse->end());
		    correlations->erase(correlations->begin(),
					correlations->end());

		    current_bindings->erase(current_bindings->begin(),
					    current_bindings->end());
		    variable_names->reset();
		    head_arguments->erase(head_arguments->begin(),
					  head_arguments->end());
		  }
	;

opt_set_quantifier:
		/* empty */
       	|	
		ALL 
		  {
		    cerr << "Warning: ALL: Datalog doesn't support duplicates";
		  }
	|	
		DISTINCT 
	;

select_list:
		'*'	
		  {
		    // Return a SelectList with just one SSC_Tree,
		    // which is just a leaf node containing "*"

		    SelectList* sl = new SelectList();
		    sl->push_back(new SSC_Tree(new SSC_RelSpec("*","")));
		    $$ = sl;
		  }
	|	
		select_sublist	
		  {
		    // Hand over the SelectList
		    $$ = $1;
		  }
	;

select_sublist:		
		/* This slightly differs in terminology from the */
		/* proposed standard */
		select_sublist_item	
		  {
		    // First item: create the SelectList
		    SelectList* sl = new SelectList();
		    // and insert select_sublist_item's SSC_Tree
		    sl->push_back($1);
		    $$ = sl;
		  }

	|	
		select_sublist_item ',' 
		select_sublist 
		  {
		    // insert the SSC_Tree
		    $3->push_front($1);
		    $$ = $3;
		  }
	;

select_sublist_item:
		/* in fact, there should be more cases */
		derived_column	
		  {
		    $$ = $1;
		  }
	;

/********/

derived_column:
		value_expression
		opt_as_clause 
		  {
		    // AS ignored for the moment
		    // Take over value_expression's SSC_Tree
		    $$ = $1;
		  } 
	;

value_expression:	/* Terms etc. Find out what is needed! */
		numeric_value_expression 
		  {
		    // Take over numeric_value_expression's SSC_Tree
		    $$ = $1;
		  }
	;

numeric_value_expression:
		term	
		  {
		    // Take over term's SSC_Tree
		    $$ = $1;
		  }
	|	
		numeric_value_expression '+' 
		term	
		  {
		    // Create a + node for the SSC_Tree
		    $$ = new SSC_Tree(new SSC_Operator(OP_PLUS), $1, $3);
		  }
	|	
		numeric_value_expression '-' term 
		  {
		    // Create a '+' node
		    $$ = new SSC_Tree(new SSC_Operator(OP_MINUS), $1, $3);
		  }
	;

term:
		factor	
		  {
		    // Take over factor's SelectItemTree
		    $$ = $1;
		  }
	|	
		term '*' 
		factor	
		  {
		    // Create a '*' node
		    $$ = new SSC_Tree(new SSC_Operator(OP_TIMES), $1, $3);
		  }
	|	
		term '/' 
		factor 
		  {
		    // Create a '/' node
		    $$ = new SSC_Tree(new SSC_Operator(OP_FRAC), $1, $3);
		  }
	;

factor:
	        numeric_primary 
		  {
		    // Take over numeric_primary's SSC_Tree
		    $$ = $1;
		  }
	|       
		sign 
		numeric_primary 
                {
		  // check whether sign is a '-'
		  if( $1 )
		    {
		      // sign is '-': create appropriate SSC_Tree
		      $$ = new SSC_Tree(new SSC_Operator(OP_UMINUS), $2);
		    } 
		  else 
		    {
		      // sign is '+': just hand over numeric_primary's 
		      // SSC_Tree
		      $$ = $2;
		    }
		}
	;

numeric_primary:
		value_expression_primary	
                  {
		    // Take over value_expression_primary's SSC_Tree
		    $$ = $1;
		  }
/*	|	
	        numeric_value_function */
	;

opt_as_clause:
		/* empty */
	|	
		opt_as 
		NAME /* was column_name */
	;

opt_as:
		/* empty */
	|	
		AS
	;

table_expression:
		from_clause 
		opt_where_clause 
		opt_group_by_clause 
		opt_having_clause 
                {
		  // get SSC_Tree from opt_where_clause
		  $$ = $2;
		}
	;

from_clause:
		FROM table_reference_list
	;

table_reference_list:
		table_reference
        |	
		table_reference ',' 
		table_reference_list 
	;

table_reference:
		NAME /* was table_or_query_name */ 
		opt_as_correlation 
                  {
		    // If a correlation exists, store it
		    // otherwise store the relationname as correlationname
		    if(!(*$2 == "")) {
		      newcorrelation(*$2,*$<strval>1);
		    } else {
		      newcorrelation(*$<strval>1,*$<strval>1);
		    }
		  }
        |	
		derived_table opt_as_correlation
/*	|	
	        joined_table */
        |	
		collection_derived_table opt_as_correlation
	;

/*
table_or_query_name:
		table_name
	|	
		query_name
	;
*/

/*
table_name:
		NAME // This is simplified!
	;
*/

opt_as_correlation:
		/* empty */ 
                {
		  $$ = new string("");
		}
        |	
		opt_as 
	        NAME /* was correlation_name */ 
	        opt_derived_column_list 
                {
		  // take over the string
		  $$ = $<strval>2;
		}
	;

opt_derived_column_list:
		/* empty */
	|	
		'(' column_name_list ')'   /* simplified! */
	;

derived_table:
		subquery	/* simplified! */
	;

subquery:
		'(' query_expression ')'
	;

/*
joined_table:		// not yet implemented 
	;
*/

collection_derived_table:
		TABLE '(' 
		query_expression ')'
	;

opt_where_clause:
		/* empty */	
                {
		  // create empty SSC_Tree
		  $$ = new SSC_Tree();
		}
	|	WHERE search_condition	
                {
		  // copy SSC_Tree
		  $$ = $2;
		}
	;

opt_group_by_clause:		/* not implemented yet */
	;

opt_having_clause:		/* not implemented yet */
	;

search_condition:
		boolean_value_expression	
                {
		  // hand over SSC_Tree
		  $$ = $1;
		}
	;

boolean_value_expression:
		boolean_simple_expression	
                {
		  // copy SSC_Tree
		  $$ = $1;
		}
/*	|	boolean_implication */
	;

/* not implemented yet */
/*boolean_implication:		
	;
	*/

boolean_simple_expression:
		boolean_term	
                {
		  // copy SSC_Tree
		  $$ = $1;
		}
	|	
		boolean_value_expression OR boolean_term	
		{
		  // create a new SSC_Tree node
		  $$ = new SSC_Tree(new SSC_Operator(OP_OR), $1, $3);
		}
	;

boolean_term:
		boolean_factor	
                {
		  // copy SSC_Tree
		  $$ = $1;
		}
	|	
		boolean_term AND boolean_factor
                {
		  // create a new SSC_Tree node
 		  $$ = new SSC_Tree(new SSC_Operator(OP_AND), $1, $3);
		}
	;

boolean_factor:
		boolean_primary	
                {
		  // copy SSC_Tree
		  $$ = $1;
		}
	|	
		NOT boolean_primary
                {
		  // create a new SSC_Tree node
 		  $$ = new SSC_Tree(new SSC_Operator(OP_NOT), $2);
		}
	;

boolean_primary:
		predicate	
                {
		  // copy SSC_Tree
		  $$ = $1;
		}
/*	|	value_expression_primary *//*not implemented yet */
	;

predicate:
		comparison_predicate	
                {
		  // copy SSC_Tree
		  $$ = $1;
		}
/*	|	
		between_predicate
	|	
		in_predicate
	|	
		like_predicate
	|	
		null_predicate
	|	
		quantified_comparison_predicate
	|	
		exists_predicate
	|	
		unique_predicate
	|	
		match_predicate
	|	
		overlaps_predicate
	|	
		similar_predicate
	|	
		quantified_predicate
	|	
		distinct_predicate
	|	
		boolean_predicate
	|	
		type_predicate */
	;

comparison_predicate:
		row_value_expression COMPARISON row_value_expression
                {
		  // later there will be a switch statement
		  if($2 == OP_EQ) {
		    // create a SSC_Tree for '='
		    $$ = new SSC_Tree(new SSC_Operator(OP_EQ), $1, $3);
		  } else {
		    fprintf(stderr,
			    "Comparison operators other than = are not supported yet\n");
		    $$ = new SSC_Tree();
		  }
		}
	;

row_value_expression:
		value_specification	
                {
		  // copy SSC_Tree
		  $$ = $1;
		}
/*	|	
                row_reference
	|	
                row_value_constructor */
	;

value_specification:
		literal	
                {
		}
	|	
		general_value_specification	
                {
		  // copy SSC_Tree
		  $$ = $1;
		}
	;

literal:
		signed_numeric_literal
/*	|	
	        general_literal */
	;

signed_numeric_literal:
		unsigned_numeric_literal
	|	
		sign unsigned_numeric_literal 
                {
		} 
	;

sign:
		'+'	
                {
		  $$ = 0;
		}
	|	
		'-'	
                {
		  $$ = 1;
		}
	;

unsigned_numeric_literal:
		INTNUM
	|	
		APPROXNUM
	;

general_value_specification:	/* simplified */
		item_reference	
                {
		  // copy SSC_Tree
		  $$ = $1;
		} 
	;

item_reference:
		NAME /* was item_name */
		{
		  // create a SSC_Tree leafnode
 		  $$ = new SSC_Tree(new SSC_RelSpec("",*$<strval>1));
		}
	|	
		NAME /* was item_qualifier */ 
		'.' 
		NAME /* was item_name */
		{
		  // create a SSC_Tree leafnode
 		  $$ = new SSC_Tree(new SSC_RelSpec(*$<strval>1,*$<strval>3));
		}
	;

/*
item_qualifier:
		NAME
	|	
	        NAME
	;
*/

/*
item_name:
		NAME
	;
*/

/* not yet
between_predicate:
		row_value_expression 
		NOT 
		BETWEEN 
		row_value_expression 
		AND 
		row_value_expression
                {
		}
	|	
		row_value_expression 
		BETWEEN 
		row_value_expression 
		AND 
		row_value_expression
                {
		}
	;
*/

value_expression_primary:
		unsigned_value_specification	
                {
		  // not yet implemented
		  $$ = new SSC_Tree();
		}
	|	
		column_reference
                {
		  // hand over SSC_Tree
		  $$ = $1;
		}
/*	|	
		set_function_specification
	|	
		scalar_subquery
	|	
		case_expression
	|	
		'(' value_expression ')'
	|	
		cast specification
	|	
		subtype_treatment
	|	
		collection_value_constructor
	|	
		routine_invocation
	|	
		field_reference
	|	
		observer_reference */
	;

column_reference:
		item_reference	
                {
		  // copy SSC_Tree 
		  $$ = $1;
		}
	;

query_term:
		non_join_query_term
/*	|	
	        joined_table */
	;

query_primary:
		non_join_query_primary
/*	|	
	        joined_table */
	;

table_value_constructor:
		VALUES table_value_constructor_list
	;

table_value_constructor_list:
		row_value_expression 
                {
		}
	|	
		table_value_constructor_list 
		',' 
		row_value_expression
                {
		}
	;

explicit_table:
		TABLE NAME /* was table_name */
	;

/*
correlation_name:
		NAME
	;
*/

/*
in_predicate:
		row_value_expression 
		IN 
		in_predicate_value
                {
		  // nothing yet
		}
	|	
		row_value_expression 
		NOT 
		IN 
		in_predicate_value	
                {
		  // nothing yet
		}
	;
*/

/*
in_predicate_value:
		subquery
	|	
		'(' in_value_list ')'
	;
*/

/*
in_value_list:
		value_expression 
                {
		  // select_item_tree_t *dummy; dummy=$1;
		} 
	|	
		in_value_list ',' 
		value_expression 
                { 
		  // select_item_tree_t *dummy; dummy= $3;
		}
	;
*/

unsigned_value_specification:
		unsigned_numeric_literal	/* simplified */
	;

/////////////////////////////////////////////////////////////////
// nonstandard constraints extension
/////////////////////////////////////////////////////////////////

with_constraints:
		/* empty */
	|	strictcheck
                unless_clause 
                {

		  // Constraint treatment should go here

		}
	|       strictcheck
                unless_clause 
                {
		}
		suchthat_clause
                {
                }
	;

strictcheck:
		{
		  if(sql_strict_SQL3) 
		  {
		    fprintf(stderr, "Error: UNLESS is not allowed in strict SQL3\n");
		    exit(ERROR_SQL3_STRICT);
		  }
		}
        ;

unless_clause:
	        UNLESS unless_cond
	;

unless_cond:
		compound_unless_cond
	;

simple_unless_cond:
                  {
		  }
		EXISTS query_specification_unnested
                  {
		  }
	;

compound_unless_cond:
		'(' simple_unless_cond ')'
        |       '(' simple_unless_cond ')' OR compound_unless_cond
	;

suchthat_clause:
		SUCH THAT suchthat_cond
	;

suchthat_cond:
		compound_suchthat_cond
        ;

simple_suchthat_cond:
                  {
		  }
		NOT EXISTS query_specification_nested_once
                  {
		  }
        |         
                  {
		  }
                EXISTS query_specification_nested_once
                  {
		  }
        ;

compound_suchthat_cond:
		'(' simple_suchthat_cond ')'
        |       '(' simple_suchthat_cond ')' AND compound_suchthat_cond
        ;

query_specification_nested_once:
                  {
		    // at most one level of nesting
		    query_spec_nesting = 1;
		  }
		query_specification
                  {
		    // reset to unlimited nesting
		    query_spec_nesting = -1;
		  }
	;

query_specification_unnested:
                  {
		    // no nesting allowed
		    query_spec_nesting = 0;
		  }
		query_specification
                  {
		    // reset to unlimited nesting
		    query_spec_nesting = -1;
		  }
	;
%%
