//////////////////////////////////////////////////////////////////////////////
// diag.h

#ifndef DIAG_H
#define DIAG_H

//////////////////////////////////////////////////////////////////////////////
class WEIGHTEDATOM : public ATOM
    {
private:
    unsigned weight;      
public:

    WEIGHTEDATOM()
        {
        assert(0);
        }

    WEIGHTEDATOM( const ATOM &a, unsigned w )
        : ATOM(a), 
          weight(w)
        {
        }
  
    WEIGHTEDATOM( const WEIGHTEDATOM &wa ) 
        : ATOM(wa),
          weight(wa.weight)
        {
        }
  
    void operator=( const WEIGHTEDATOM& )
        {
        assert( 0 );
        }

    unsigned getWeight() const 
        { 
        return weight;
        }
    };

 typedef vector<WEIGHTEDATOM> WATOMS;

//////////////////////////////////////////////////////////////////////////////
// Global Variables

extern WATOMS   diagH;
extern LITERALS diagO;

extern "C" bool diagParseLiterals;


//////////////////////////////////////////////////////////////////////////////
// Global Functions

void CreateDiagnosis(RULES&, const WATOMS&, const LITERALS&);

class MODEL_GENERATOR;
bool DiagCallback(MODEL_GENERATOR*, const INTERPRET*, const GINTERPRET*);


extern "C" FILE* diagyyin; // Where LEX reads its input from 

// BUG-FIX: bison[1.24] fails to prototype its interfaces yylex() and yyerror().
extern "C" int diagyylex();
extern "C" int diagyyerror(const char*);

#endif
