set terminal png
set size 1.25,1
set key top left Left
set xdata time
set timefmt "%y%m%d"

set output "tramp3d-summary-build.png"
set ylabel "time [s]"
set title "tramp3d-v4 build time"
plot [:] [:250] \
	"tramp3d-summary.txt" u 1:3 title "mainline" w lp, \
	"tramp3d-summary.txt" u 1:5 title "mainline (leafify)" w lp, \
	"tramp3d-summary.txt" u 1:9 title "mainline (-fprofile-generate)" w lp, \
	"tramp3d-summary.txt" u 1:11 title "mainline (-fprofile-use)" w lp
set output

# split graphs
set output "tramp3d-summary-build-mainline.png"
set ylabel "time [s]"
set title "tramp3d-v4 build time for mainline"
plot [:] [:] \
	"tramp3d-summary.txt" u 1:3 title "mainline" w lp
set output
set output "tramp3d-summary-build-mainline-leafify.png"
set ylabel "time [s]"
set title "tramp3d-v4 build time for mainline (leafify)"
plot [:] [:] \
	"tramp3d-summary.txt" u 1:5 title "mainline (leafify)" w lp
set output

set output "tramp3d-summary-memory.png"
set ylabel "memory [MB]"
set title "cc1plus maximum virtual memory requirements"
plot [:] [:] \
	"tramp3d-summary.txt" u 1:($7/1024.0) title "mainline" w lp, \
	"tramp3d-summary.txt" u 1:($8/1024.0) title "mainline (leafify)" w lp
set output

set output "tramp3d-summary-size.png"
set ylabel "text size [kB]"
set title "tramp3d binary text size"
plot [:] [:] \
	"tramp3d-summary.txt" u 1:($13/1024.0) title "mainline" w lp, \
	"tramp3d-summary.txt" u 1:($14/1024.0) title "mainline (leafify)" w lp
set output

set output "tramp3d-summary-run.png"
set ylabel "time [s]"
set title "tramp3d-v4 -n 25 run time"
set logscale y
set ytics
plot [:] [:35] \
	"tramp3d-summary.txt" u 1:4 title "mainline" w lp, \
	"tramp3d-summary.txt" u 1:6 title "mainline (leafify)" w lp, \
	"tramp3d-summary.txt" u 1:($10*2.5) title "mainline (-fprofile-generate)" w lp, \
	"tramp3d-summary.txt" u 1:12 title "mainline (-fprofile-use)" w lp
set output
set nologscale
set ytics

# split graphs
set output "tramp3d-summary-run-mainline.png"
set ylabel "time [s]"
set title "tramp3d-v4 -n 25 run time for mainline"
set ytics
plot [:] [:] \
	"tramp3d-summary.txt" u 1:4 title "mainline" w lp, \
	"tramp3d-summary.txt" u 1:6 title "mainline (leafify)" w lp, \
	"tramp3d-summary.txt" u 1:12 title "mainline (-fprofile-use)" w lp
set output

