#!/bin/sh

# Usage: raytracer.sh BASEDIR GCCINSTALLDIR LOGDIR TMPDIR

if test -z "$4"; then
  exit 1
fi

BASEDIR="$1"
GCCINSTALLDIR="$2"
LOGDIR="$3"
TMPDIR="$4"

LOGFILE="$LOGDIR/raytracer-performance-`date +%y%m%d-%s`"

export LANG=C

echo DATE-MARKER $[`date +%-y*365+%-j`] 2>&1 | tee $LOGFILE

cd $TMPDIR
for i in `cat $BASEDIR/tests`; do
  for j in -O0 -O1 -O2 -O3 -Os; do
# Dump memory usage, compile time, text size, runtime and output size
    echo "$GCCINSTALLDIR/bin/g++ -o $i$j $j $BASEDIR/$i.cpp" 2>&1 | tee -a $LOGFILE
    $BASEDIR/../maxmem2.sh $GCCINSTALLDIR/bin/g++ -o $i$j $j $BASEDIR/$i.cpp 2>&1 | tee -a $LOGFILE
    echo FILESIZE: `size ./$i$j` 2>&1 | tee -a $LOGFILE
    /usr/bin/time -f "TIME: %U" $GCCINSTALLDIR/bin/g++ -o $i$j $j $BASEDIR/$i.cpp 2>&1 | tee -a $LOGFILE
    /usr/bin/time -f "TIME: %U" ./$i$j 2>&1 > $i$j.out | tee -a $LOGFILE
    echo MD5SUM: `md5sum $i$j.out | cut -f 1` 2>&1 | tee -a $LOGFILE
  done
done

cp $LOGFILE $LOGDIR/raytracer-performance-latest
