#!/bin/sh

# Usage: $0 base-dir log-dir tmp-dir

if test -z "$3"; then
  exit 1
fi

BASEDIR="$1"
LOGDIR="$2"
TMPDIR="$3"

cd $TMPDIR

summary="raytracer-summary.txt"

echo "# Four values per group, build-time memory, text-size, compile-time and runtime"
echo -n "# DATE " > $summary
cat $BASEDIR/tests-x >> $summary
echo >> $summary

for i in $LOGDIR/raytracer-*; do
  echo $i | sed -e 's/.*-\([0-9][0-9][0-9][0-9][0-9][0-9]\)\(\|-.*\)$/\1/' | tr '\n' ' ' | cat >> $summary
  cat $i | grep '^total:\|FILESIZE:\|TIME:' | sed -e 's/^[^0-9]*\([0-9\.]*\).*$/\1/' | tr '\n' ' ' >> $summary
  echo >> $summary;
done

if test -f $BASEDIR/raytracer-summary.gp-`hostname`; then
  gnuplot $BASEDIR/raytracer-summary.gp-`hostname`
else
  gnuplot $BASEDIR/raytracer-summary.gp
fi
