set terminal png
set size 1.25,1
set key top left Left
set xdata time
set timefmt "%y%m%d"


# ../gen-gp.sh --title Compile time memory usage in kB --ylabel kB raytracer-summary.txt tests-x 1 4
set ylabel "kB"

set logscale y
set output "raytracer-summary.txt-1-0.png"
set title "Compile time memory usage in kB"
plot [:] [:] "raytracer-summary.txt"  u 1:2 title "ray-1-O0" w lp, \
	"" u 1:6 title "ray-1-O1" w lp, \
	"" u 1:10 title "ray-1-O2" w lp, \
	"" u 1:14 title "ray-1-O3" w lp, \
	"" u 1:18 title "ray-1-Os" w lp, \
	"" u 1:22 title "ray-2-O0" w lp, \
	"" u 1:26 title "ray-2-O1" w lp, \
	"" u 1:30 title "ray-2-O2" w lp, \
	"" u 1:34 title "ray-2-O3" w lp, \
	"" u 1:38 title "ray-2-Os" w lp, \
	"" u 1:42 title "ray-3-O0" w lp, \
	"" u 1:46 title "ray-3-O1" w lp, \
	"" u 1:50 title "ray-3-O2" w lp, \
	"" u 1:54 title "ray-3-O3" w lp, \
	"" u 1:58 title "ray-3-Os" w lp, \
	"" u 1:62 title "ray-4-O0" w lp, \
	"" u 1:66 title "ray-4-O1" w lp, \
	"" u 1:70 title "ray-4-O2" w lp, \
	"" u 1:74 title "ray-4-O3" w lp, \
	"" u 1:78 title "ray-4-Os" w lp, \
	"" u 1:82 title "ray-5-O0" w lp, \
	"" u 1:86 title "ray-5-O1" w lp, \
	"" u 1:90 title "ray-5-O2" w lp, \
	"" u 1:94 title "ray-5-O3" w lp, \
	"" u 1:98 title "ray-5-Os" w lp, \
	"" u 1:102 title "sphereflake-O0" w lp, \
	"" u 1:106 title "sphereflake-O1" w lp, \
	"" u 1:110 title "sphereflake-O2" w lp, \
	"" u 1:114 title "sphereflake-O3" w lp, \
	"" u 1:118 title "sphereflake-Os" w lp
set nologscale

set output "raytracer-summary.txt-ray-1-O0-2.png"
set title "Compile time memory usage in kB for ray-1-O0"
plot [:] [:] "raytracer-summary.txt" u 1:2 title "ray-1-O0" w lp
set output "raytracer-summary.txt-ray-1-O1-6.png"
set title "Compile time memory usage in kB for ray-1-O1"
plot [:] [:] "raytracer-summary.txt" u 1:6 title "ray-1-O1" w lp
set output "raytracer-summary.txt-ray-1-O2-10.png"
set title "Compile time memory usage in kB for ray-1-O2"
plot [:] [:] "raytracer-summary.txt" u 1:10 title "ray-1-O2" w lp
set output "raytracer-summary.txt-ray-1-O3-14.png"
set title "Compile time memory usage in kB for ray-1-O3"
plot [:] [:] "raytracer-summary.txt" u 1:14 title "ray-1-O3" w lp
set output "raytracer-summary.txt-ray-1-Os-18.png"
set title "Compile time memory usage in kB for ray-1-Os"
plot [:] [:] "raytracer-summary.txt" u 1:18 title "ray-1-Os" w lp
set output "raytracer-summary.txt-ray-2-O0-22.png"
set title "Compile time memory usage in kB for ray-2-O0"
plot [:] [:] "raytracer-summary.txt" u 1:22 title "ray-2-O0" w lp
set output "raytracer-summary.txt-ray-2-O1-26.png"
set title "Compile time memory usage in kB for ray-2-O1"
plot [:] [:] "raytracer-summary.txt" u 1:26 title "ray-2-O1" w lp
set output "raytracer-summary.txt-ray-2-O2-30.png"
set title "Compile time memory usage in kB for ray-2-O2"
plot [:] [:] "raytracer-summary.txt" u 1:30 title "ray-2-O2" w lp
set output "raytracer-summary.txt-ray-2-O3-34.png"
set title "Compile time memory usage in kB for ray-2-O3"
plot [:] [:] "raytracer-summary.txt" u 1:34 title "ray-2-O3" w lp
set output "raytracer-summary.txt-ray-2-Os-38.png"
set title "Compile time memory usage in kB for ray-2-Os"
plot [:] [:] "raytracer-summary.txt" u 1:38 title "ray-2-Os" w lp
set output "raytracer-summary.txt-ray-3-O0-42.png"
set title "Compile time memory usage in kB for ray-3-O0"
plot [:] [:] "raytracer-summary.txt" u 1:42 title "ray-3-O0" w lp
set output "raytracer-summary.txt-ray-3-O1-46.png"
set title "Compile time memory usage in kB for ray-3-O1"
plot [:] [:] "raytracer-summary.txt" u 1:46 title "ray-3-O1" w lp
set output "raytracer-summary.txt-ray-3-O2-50.png"
set title "Compile time memory usage in kB for ray-3-O2"
plot [:] [:] "raytracer-summary.txt" u 1:50 title "ray-3-O2" w lp
set output "raytracer-summary.txt-ray-3-O3-54.png"
set title "Compile time memory usage in kB for ray-3-O3"
plot [:] [:] "raytracer-summary.txt" u 1:54 title "ray-3-O3" w lp
set output "raytracer-summary.txt-ray-3-Os-58.png"
set title "Compile time memory usage in kB for ray-3-Os"
plot [:] [:] "raytracer-summary.txt" u 1:58 title "ray-3-Os" w lp
set output "raytracer-summary.txt-ray-4-O0-62.png"
set title "Compile time memory usage in kB for ray-4-O0"
plot [:] [:] "raytracer-summary.txt" u 1:62 title "ray-4-O0" w lp
set output "raytracer-summary.txt-ray-4-O1-66.png"
set title "Compile time memory usage in kB for ray-4-O1"
plot [:] [:] "raytracer-summary.txt" u 1:66 title "ray-4-O1" w lp
set output "raytracer-summary.txt-ray-4-O2-70.png"
set title "Compile time memory usage in kB for ray-4-O2"
plot [:] [:] "raytracer-summary.txt" u 1:70 title "ray-4-O2" w lp
set output "raytracer-summary.txt-ray-4-O3-74.png"
set title "Compile time memory usage in kB for ray-4-O3"
plot [:] [:] "raytracer-summary.txt" u 1:74 title "ray-4-O3" w lp
set output "raytracer-summary.txt-ray-4-Os-78.png"
set title "Compile time memory usage in kB for ray-4-Os"
plot [:] [:] "raytracer-summary.txt" u 1:78 title "ray-4-Os" w lp
set output "raytracer-summary.txt-ray-5-O0-82.png"
set title "Compile time memory usage in kB for ray-5-O0"
plot [:] [:] "raytracer-summary.txt" u 1:82 title "ray-5-O0" w lp
set output "raytracer-summary.txt-ray-5-O1-86.png"
set title "Compile time memory usage in kB for ray-5-O1"
plot [:] [:] "raytracer-summary.txt" u 1:86 title "ray-5-O1" w lp
set output "raytracer-summary.txt-ray-5-O2-90.png"
set title "Compile time memory usage in kB for ray-5-O2"
plot [:] [:] "raytracer-summary.txt" u 1:90 title "ray-5-O2" w lp
set output "raytracer-summary.txt-ray-5-O3-94.png"
set title "Compile time memory usage in kB for ray-5-O3"
plot [:] [:] "raytracer-summary.txt" u 1:94 title "ray-5-O3" w lp
set output "raytracer-summary.txt-ray-5-Os-98.png"
set title "Compile time memory usage in kB for ray-5-Os"
plot [:] [:] "raytracer-summary.txt" u 1:98 title "ray-5-Os" w lp
set output "raytracer-summary.txt-sphereflake-O0-102.png"
set title "Compile time memory usage in kB for sphereflake-O0"
plot [:] [:] "raytracer-summary.txt" u 1:102 title "sphereflake-O0" w lp
set output "raytracer-summary.txt-sphereflake-O1-106.png"
set title "Compile time memory usage in kB for sphereflake-O1"
plot [:] [:] "raytracer-summary.txt" u 1:106 title "sphereflake-O1" w lp
set output "raytracer-summary.txt-sphereflake-O2-110.png"
set title "Compile time memory usage in kB for sphereflake-O2"
plot [:] [:] "raytracer-summary.txt" u 1:110 title "sphereflake-O2" w lp
set output "raytracer-summary.txt-sphereflake-O3-114.png"
set title "Compile time memory usage in kB for sphereflake-O3"
plot [:] [:] "raytracer-summary.txt" u 1:114 title "sphereflake-O3" w lp
set output "raytracer-summary.txt-sphereflake-Os-118.png"
set title "Compile time memory usage in kB for sphereflake-Os"
plot [:] [:] "raytracer-summary.txt" u 1:118 title "sphereflake-Os" w lp
set output


# ../gen-gp.sh --title Binary text size in bytes --ylabel bytes raytracer-summary.txt tests-x 2 4
set ylabel "bytes"

set logscale y
set output "raytracer-summary.txt-2-0.png"
set title "Binary text size in bytes"
plot [:] [:] "raytracer-summary.txt"  u 1:3 title "ray-1-O0" w lp, \
	"" u 1:7 title "ray-1-O1" w lp, \
	"" u 1:11 title "ray-1-O2" w lp, \
	"" u 1:15 title "ray-1-O3" w lp, \
	"" u 1:19 title "ray-1-Os" w lp, \
	"" u 1:23 title "ray-2-O0" w lp, \
	"" u 1:27 title "ray-2-O1" w lp, \
	"" u 1:31 title "ray-2-O2" w lp, \
	"" u 1:35 title "ray-2-O3" w lp, \
	"" u 1:39 title "ray-2-Os" w lp, \
	"" u 1:43 title "ray-3-O0" w lp, \
	"" u 1:47 title "ray-3-O1" w lp, \
	"" u 1:51 title "ray-3-O2" w lp, \
	"" u 1:55 title "ray-3-O3" w lp, \
	"" u 1:59 title "ray-3-Os" w lp, \
	"" u 1:63 title "ray-4-O0" w lp, \
	"" u 1:67 title "ray-4-O1" w lp, \
	"" u 1:71 title "ray-4-O2" w lp, \
	"" u 1:75 title "ray-4-O3" w lp, \
	"" u 1:79 title "ray-4-Os" w lp, \
	"" u 1:83 title "ray-5-O0" w lp, \
	"" u 1:87 title "ray-5-O1" w lp, \
	"" u 1:91 title "ray-5-O2" w lp, \
	"" u 1:95 title "ray-5-O3" w lp, \
	"" u 1:99 title "ray-5-Os" w lp, \
	"" u 1:103 title "sphereflake-O0" w lp, \
	"" u 1:107 title "sphereflake-O1" w lp, \
	"" u 1:111 title "sphereflake-O2" w lp, \
	"" u 1:115 title "sphereflake-O3" w lp, \
	"" u 1:119 title "sphereflake-Os" w lp
set nologscale

set output "raytracer-summary.txt-ray-1-O0-3.png"
set title "Binary text size in bytes for ray-1-O0"
plot [:] [:] "raytracer-summary.txt" u 1:3 title "ray-1-O0" w lp
set output "raytracer-summary.txt-ray-1-O1-7.png"
set title "Binary text size in bytes for ray-1-O1"
plot [:] [:] "raytracer-summary.txt" u 1:7 title "ray-1-O1" w lp
set output "raytracer-summary.txt-ray-1-O2-11.png"
set title "Binary text size in bytes for ray-1-O2"
plot [:] [:] "raytracer-summary.txt" u 1:11 title "ray-1-O2" w lp
set output "raytracer-summary.txt-ray-1-O3-15.png"
set title "Binary text size in bytes for ray-1-O3"
plot [:] [:] "raytracer-summary.txt" u 1:15 title "ray-1-O3" w lp
set output "raytracer-summary.txt-ray-1-Os-19.png"
set title "Binary text size in bytes for ray-1-Os"
plot [:] [:] "raytracer-summary.txt" u 1:19 title "ray-1-Os" w lp
set output "raytracer-summary.txt-ray-2-O0-23.png"
set title "Binary text size in bytes for ray-2-O0"
plot [:] [:] "raytracer-summary.txt" u 1:23 title "ray-2-O0" w lp
set output "raytracer-summary.txt-ray-2-O1-27.png"
set title "Binary text size in bytes for ray-2-O1"
plot [:] [:] "raytracer-summary.txt" u 1:27 title "ray-2-O1" w lp
set output "raytracer-summary.txt-ray-2-O2-31.png"
set title "Binary text size in bytes for ray-2-O2"
plot [:] [:] "raytracer-summary.txt" u 1:31 title "ray-2-O2" w lp
set output "raytracer-summary.txt-ray-2-O3-35.png"
set title "Binary text size in bytes for ray-2-O3"
plot [:] [:] "raytracer-summary.txt" u 1:35 title "ray-2-O3" w lp
set output "raytracer-summary.txt-ray-2-Os-39.png"
set title "Binary text size in bytes for ray-2-Os"
plot [:] [:] "raytracer-summary.txt" u 1:39 title "ray-2-Os" w lp
set output "raytracer-summary.txt-ray-3-O0-43.png"
set title "Binary text size in bytes for ray-3-O0"
plot [:] [:] "raytracer-summary.txt" u 1:43 title "ray-3-O0" w lp
set output "raytracer-summary.txt-ray-3-O1-47.png"
set title "Binary text size in bytes for ray-3-O1"
plot [:] [:] "raytracer-summary.txt" u 1:47 title "ray-3-O1" w lp
set output "raytracer-summary.txt-ray-3-O2-51.png"
set title "Binary text size in bytes for ray-3-O2"
plot [:] [:] "raytracer-summary.txt" u 1:51 title "ray-3-O2" w lp
set output "raytracer-summary.txt-ray-3-O3-55.png"
set title "Binary text size in bytes for ray-3-O3"
plot [:] [:] "raytracer-summary.txt" u 1:55 title "ray-3-O3" w lp
set output "raytracer-summary.txt-ray-3-Os-59.png"
set title "Binary text size in bytes for ray-3-Os"
plot [:] [:] "raytracer-summary.txt" u 1:59 title "ray-3-Os" w lp
set output "raytracer-summary.txt-ray-4-O0-63.png"
set title "Binary text size in bytes for ray-4-O0"
plot [:] [:] "raytracer-summary.txt" u 1:63 title "ray-4-O0" w lp
set output "raytracer-summary.txt-ray-4-O1-67.png"
set title "Binary text size in bytes for ray-4-O1"
plot [:] [:] "raytracer-summary.txt" u 1:67 title "ray-4-O1" w lp
set output "raytracer-summary.txt-ray-4-O2-71.png"
set title "Binary text size in bytes for ray-4-O2"
plot [:] [:] "raytracer-summary.txt" u 1:71 title "ray-4-O2" w lp
set output "raytracer-summary.txt-ray-4-O3-75.png"
set title "Binary text size in bytes for ray-4-O3"
plot [:] [:] "raytracer-summary.txt" u 1:75 title "ray-4-O3" w lp
set output "raytracer-summary.txt-ray-4-Os-79.png"
set title "Binary text size in bytes for ray-4-Os"
plot [:] [:] "raytracer-summary.txt" u 1:79 title "ray-4-Os" w lp
set output "raytracer-summary.txt-ray-5-O0-83.png"
set title "Binary text size in bytes for ray-5-O0"
plot [:] [:] "raytracer-summary.txt" u 1:83 title "ray-5-O0" w lp
set output "raytracer-summary.txt-ray-5-O1-87.png"
set title "Binary text size in bytes for ray-5-O1"
plot [:] [:] "raytracer-summary.txt" u 1:87 title "ray-5-O1" w lp
set output "raytracer-summary.txt-ray-5-O2-91.png"
set title "Binary text size in bytes for ray-5-O2"
plot [:] [:] "raytracer-summary.txt" u 1:91 title "ray-5-O2" w lp
set output "raytracer-summary.txt-ray-5-O3-95.png"
set title "Binary text size in bytes for ray-5-O3"
plot [:] [:] "raytracer-summary.txt" u 1:95 title "ray-5-O3" w lp
set output "raytracer-summary.txt-ray-5-Os-99.png"
set title "Binary text size in bytes for ray-5-Os"
plot [:] [:] "raytracer-summary.txt" u 1:99 title "ray-5-Os" w lp
set output "raytracer-summary.txt-sphereflake-O0-103.png"
set title "Binary text size in bytes for sphereflake-O0"
plot [:] [:] "raytracer-summary.txt" u 1:103 title "sphereflake-O0" w lp
set output "raytracer-summary.txt-sphereflake-O1-107.png"
set title "Binary text size in bytes for sphereflake-O1"
plot [:] [:] "raytracer-summary.txt" u 1:107 title "sphereflake-O1" w lp
set output "raytracer-summary.txt-sphereflake-O2-111.png"
set title "Binary text size in bytes for sphereflake-O2"
plot [:] [:] "raytracer-summary.txt" u 1:111 title "sphereflake-O2" w lp
set output "raytracer-summary.txt-sphereflake-O3-115.png"
set title "Binary text size in bytes for sphereflake-O3"
plot [:] [:] "raytracer-summary.txt" u 1:115 title "sphereflake-O3" w lp
set output "raytracer-summary.txt-sphereflake-Os-119.png"
set title "Binary text size in bytes for sphereflake-Os"
plot [:] [:] "raytracer-summary.txt" u 1:119 title "sphereflake-Os" w lp
set output


# ../gen-gp.sh --title Compile time in s --ylabel s raytracer-summary.txt tests-x 3 4
set ylabel "s"

set logscale y
set output "raytracer-summary.txt-3-0.png"
set title "Compile time in s"
plot [:] [:] "raytracer-summary.txt"  u 1:4 title "ray-1-O0" w lp, \
	"" u 1:8 title "ray-1-O1" w lp, \
	"" u 1:12 title "ray-1-O2" w lp, \
	"" u 1:16 title "ray-1-O3" w lp, \
	"" u 1:20 title "ray-1-Os" w lp, \
	"" u 1:24 title "ray-2-O0" w lp, \
	"" u 1:28 title "ray-2-O1" w lp, \
	"" u 1:32 title "ray-2-O2" w lp, \
	"" u 1:36 title "ray-2-O3" w lp, \
	"" u 1:40 title "ray-2-Os" w lp, \
	"" u 1:44 title "ray-3-O0" w lp, \
	"" u 1:48 title "ray-3-O1" w lp, \
	"" u 1:52 title "ray-3-O2" w lp, \
	"" u 1:56 title "ray-3-O3" w lp, \
	"" u 1:60 title "ray-3-Os" w lp, \
	"" u 1:64 title "ray-4-O0" w lp, \
	"" u 1:68 title "ray-4-O1" w lp, \
	"" u 1:72 title "ray-4-O2" w lp, \
	"" u 1:76 title "ray-4-O3" w lp, \
	"" u 1:80 title "ray-4-Os" w lp, \
	"" u 1:84 title "ray-5-O0" w lp, \
	"" u 1:88 title "ray-5-O1" w lp, \
	"" u 1:92 title "ray-5-O2" w lp, \
	"" u 1:96 title "ray-5-O3" w lp, \
	"" u 1:100 title "ray-5-Os" w lp, \
	"" u 1:104 title "sphereflake-O0" w lp, \
	"" u 1:108 title "sphereflake-O1" w lp, \
	"" u 1:112 title "sphereflake-O2" w lp, \
	"" u 1:116 title "sphereflake-O3" w lp, \
	"" u 1:120 title "sphereflake-Os" w lp
set nologscale

set output "raytracer-summary.txt-ray-1-O0-4.png"
set title "Compile time in s for ray-1-O0"
plot [:] [:] "raytracer-summary.txt" u 1:4 title "ray-1-O0" w lp
set output "raytracer-summary.txt-ray-1-O1-8.png"
set title "Compile time in s for ray-1-O1"
plot [:] [:] "raytracer-summary.txt" u 1:8 title "ray-1-O1" w lp
set output "raytracer-summary.txt-ray-1-O2-12.png"
set title "Compile time in s for ray-1-O2"
plot [:] [:] "raytracer-summary.txt" u 1:12 title "ray-1-O2" w lp
set output "raytracer-summary.txt-ray-1-O3-16.png"
set title "Compile time in s for ray-1-O3"
plot [:] [:] "raytracer-summary.txt" u 1:16 title "ray-1-O3" w lp
set output "raytracer-summary.txt-ray-1-Os-20.png"
set title "Compile time in s for ray-1-Os"
plot [:] [:] "raytracer-summary.txt" u 1:20 title "ray-1-Os" w lp
set output "raytracer-summary.txt-ray-2-O0-24.png"
set title "Compile time in s for ray-2-O0"
plot [:] [:] "raytracer-summary.txt" u 1:24 title "ray-2-O0" w lp
set output "raytracer-summary.txt-ray-2-O1-28.png"
set title "Compile time in s for ray-2-O1"
plot [:] [:] "raytracer-summary.txt" u 1:28 title "ray-2-O1" w lp
set output "raytracer-summary.txt-ray-2-O2-32.png"
set title "Compile time in s for ray-2-O2"
plot [:] [:] "raytracer-summary.txt" u 1:32 title "ray-2-O2" w lp
set output "raytracer-summary.txt-ray-2-O3-36.png"
set title "Compile time in s for ray-2-O3"
plot [:] [:] "raytracer-summary.txt" u 1:36 title "ray-2-O3" w lp
set output "raytracer-summary.txt-ray-2-Os-40.png"
set title "Compile time in s for ray-2-Os"
plot [:] [:] "raytracer-summary.txt" u 1:40 title "ray-2-Os" w lp
set output "raytracer-summary.txt-ray-3-O0-44.png"
set title "Compile time in s for ray-3-O0"
plot [:] [:] "raytracer-summary.txt" u 1:44 title "ray-3-O0" w lp
set output "raytracer-summary.txt-ray-3-O1-48.png"
set title "Compile time in s for ray-3-O1"
plot [:] [:] "raytracer-summary.txt" u 1:48 title "ray-3-O1" w lp
set output "raytracer-summary.txt-ray-3-O2-52.png"
set title "Compile time in s for ray-3-O2"
plot [:] [:] "raytracer-summary.txt" u 1:52 title "ray-3-O2" w lp
set output "raytracer-summary.txt-ray-3-O3-56.png"
set title "Compile time in s for ray-3-O3"
plot [:] [:] "raytracer-summary.txt" u 1:56 title "ray-3-O3" w lp
set output "raytracer-summary.txt-ray-3-Os-60.png"
set title "Compile time in s for ray-3-Os"
plot [:] [:] "raytracer-summary.txt" u 1:60 title "ray-3-Os" w lp
set output "raytracer-summary.txt-ray-4-O0-64.png"
set title "Compile time in s for ray-4-O0"
plot [:] [:] "raytracer-summary.txt" u 1:64 title "ray-4-O0" w lp
set output "raytracer-summary.txt-ray-4-O1-68.png"
set title "Compile time in s for ray-4-O1"
plot [:] [:] "raytracer-summary.txt" u 1:68 title "ray-4-O1" w lp
set output "raytracer-summary.txt-ray-4-O2-72.png"
set title "Compile time in s for ray-4-O2"
plot [:] [:] "raytracer-summary.txt" u 1:72 title "ray-4-O2" w lp
set output "raytracer-summary.txt-ray-4-O3-76.png"
set title "Compile time in s for ray-4-O3"
plot [:] [:] "raytracer-summary.txt" u 1:76 title "ray-4-O3" w lp
set output "raytracer-summary.txt-ray-4-Os-80.png"
set title "Compile time in s for ray-4-Os"
plot [:] [:] "raytracer-summary.txt" u 1:80 title "ray-4-Os" w lp
set output "raytracer-summary.txt-ray-5-O0-84.png"
set title "Compile time in s for ray-5-O0"
plot [:] [:] "raytracer-summary.txt" u 1:84 title "ray-5-O0" w lp
set output "raytracer-summary.txt-ray-5-O1-88.png"
set title "Compile time in s for ray-5-O1"
plot [:] [:] "raytracer-summary.txt" u 1:88 title "ray-5-O1" w lp
set output "raytracer-summary.txt-ray-5-O2-92.png"
set title "Compile time in s for ray-5-O2"
plot [:] [:] "raytracer-summary.txt" u 1:92 title "ray-5-O2" w lp
set output "raytracer-summary.txt-ray-5-O3-96.png"
set title "Compile time in s for ray-5-O3"
plot [:] [:] "raytracer-summary.txt" u 1:96 title "ray-5-O3" w lp
set output "raytracer-summary.txt-ray-5-Os-100.png"
set title "Compile time in s for ray-5-Os"
plot [:] [:] "raytracer-summary.txt" u 1:100 title "ray-5-Os" w lp
set output "raytracer-summary.txt-sphereflake-O0-104.png"
set title "Compile time in s for sphereflake-O0"
plot [:] [:] "raytracer-summary.txt" u 1:104 title "sphereflake-O0" w lp
set output "raytracer-summary.txt-sphereflake-O1-108.png"
set title "Compile time in s for sphereflake-O1"
plot [:] [:] "raytracer-summary.txt" u 1:108 title "sphereflake-O1" w lp
set output "raytracer-summary.txt-sphereflake-O2-112.png"
set title "Compile time in s for sphereflake-O2"
plot [:] [:] "raytracer-summary.txt" u 1:112 title "sphereflake-O2" w lp
set output "raytracer-summary.txt-sphereflake-O3-116.png"
set title "Compile time in s for sphereflake-O3"
plot [:] [:] "raytracer-summary.txt" u 1:116 title "sphereflake-O3" w lp
set output "raytracer-summary.txt-sphereflake-Os-120.png"
set title "Compile time in s for sphereflake-Os"
plot [:] [:] "raytracer-summary.txt" u 1:120 title "sphereflake-Os" w lp
set output


# ../gen-gp.sh --title Raytraycing run time in s --ylabel s raytracer-summary.txt tests-x 4 4
set ylabel "s"

set logscale y
set output "raytracer-summary.txt-4-0.png"
set title "Raytraycing run time in s"
plot [:] [:] "raytracer-summary.txt"  u 1:5 title "ray-1-O0" w lp, \
	"" u 1:9 title "ray-1-O1" w lp, \
	"" u 1:13 title "ray-1-O2" w lp, \
	"" u 1:17 title "ray-1-O3" w lp, \
	"" u 1:21 title "ray-1-Os" w lp, \
	"" u 1:25 title "ray-2-O0" w lp, \
	"" u 1:29 title "ray-2-O1" w lp, \
	"" u 1:33 title "ray-2-O2" w lp, \
	"" u 1:37 title "ray-2-O3" w lp, \
	"" u 1:41 title "ray-2-Os" w lp, \
	"" u 1:45 title "ray-3-O0" w lp, \
	"" u 1:49 title "ray-3-O1" w lp, \
	"" u 1:53 title "ray-3-O2" w lp, \
	"" u 1:57 title "ray-3-O3" w lp, \
	"" u 1:61 title "ray-3-Os" w lp, \
	"" u 1:65 title "ray-4-O0" w lp, \
	"" u 1:69 title "ray-4-O1" w lp, \
	"" u 1:73 title "ray-4-O2" w lp, \
	"" u 1:77 title "ray-4-O3" w lp, \
	"" u 1:81 title "ray-4-Os" w lp, \
	"" u 1:85 title "ray-5-O0" w lp, \
	"" u 1:89 title "ray-5-O1" w lp, \
	"" u 1:93 title "ray-5-O2" w lp, \
	"" u 1:97 title "ray-5-O3" w lp, \
	"" u 1:101 title "ray-5-Os" w lp, \
	"" u 1:105 title "sphereflake-O0" w lp, \
	"" u 1:109 title "sphereflake-O1" w lp, \
	"" u 1:113 title "sphereflake-O2" w lp, \
	"" u 1:117 title "sphereflake-O3" w lp, \
	"" u 1:121 title "sphereflake-Os" w lp
set nologscale

set output "raytracer-summary.txt-ray-1-O0-5.png"
set title "Raytraycing run time in s for ray-1-O0"
plot [:] [:] "raytracer-summary.txt" u 1:5 title "ray-1-O0" w lp
set output "raytracer-summary.txt-ray-1-O1-9.png"
set title "Raytraycing run time in s for ray-1-O1"
plot [:] [:] "raytracer-summary.txt" u 1:9 title "ray-1-O1" w lp
set output "raytracer-summary.txt-ray-1-O2-13.png"
set title "Raytraycing run time in s for ray-1-O2"
plot [:] [:] "raytracer-summary.txt" u 1:13 title "ray-1-O2" w lp
set output "raytracer-summary.txt-ray-1-O3-17.png"
set title "Raytraycing run time in s for ray-1-O3"
plot [:] [:] "raytracer-summary.txt" u 1:17 title "ray-1-O3" w lp
set output "raytracer-summary.txt-ray-1-Os-21.png"
set title "Raytraycing run time in s for ray-1-Os"
plot [:] [:] "raytracer-summary.txt" u 1:21 title "ray-1-Os" w lp
set output "raytracer-summary.txt-ray-2-O0-25.png"
set title "Raytraycing run time in s for ray-2-O0"
plot [:] [:] "raytracer-summary.txt" u 1:25 title "ray-2-O0" w lp
set output "raytracer-summary.txt-ray-2-O1-29.png"
set title "Raytraycing run time in s for ray-2-O1"
plot [:] [:] "raytracer-summary.txt" u 1:29 title "ray-2-O1" w lp
set output "raytracer-summary.txt-ray-2-O2-33.png"
set title "Raytraycing run time in s for ray-2-O2"
plot [:] [:] "raytracer-summary.txt" u 1:33 title "ray-2-O2" w lp
set output "raytracer-summary.txt-ray-2-O3-37.png"
set title "Raytraycing run time in s for ray-2-O3"
plot [:] [:] "raytracer-summary.txt" u 1:37 title "ray-2-O3" w lp
set output "raytracer-summary.txt-ray-2-Os-41.png"
set title "Raytraycing run time in s for ray-2-Os"
plot [:] [:] "raytracer-summary.txt" u 1:41 title "ray-2-Os" w lp
set output "raytracer-summary.txt-ray-3-O0-45.png"
set title "Raytraycing run time in s for ray-3-O0"
plot [:] [:] "raytracer-summary.txt" u 1:45 title "ray-3-O0" w lp
set output "raytracer-summary.txt-ray-3-O1-49.png"
set title "Raytraycing run time in s for ray-3-O1"
plot [:] [:] "raytracer-summary.txt" u 1:49 title "ray-3-O1" w lp
set output "raytracer-summary.txt-ray-3-O2-53.png"
set title "Raytraycing run time in s for ray-3-O2"
plot [:] [:] "raytracer-summary.txt" u 1:53 title "ray-3-O2" w lp
set output "raytracer-summary.txt-ray-3-O3-57.png"
set title "Raytraycing run time in s for ray-3-O3"
plot [:] [:] "raytracer-summary.txt" u 1:57 title "ray-3-O3" w lp
set output "raytracer-summary.txt-ray-3-Os-61.png"
set title "Raytraycing run time in s for ray-3-Os"
plot [:] [:] "raytracer-summary.txt" u 1:61 title "ray-3-Os" w lp
set output "raytracer-summary.txt-ray-4-O0-65.png"
set title "Raytraycing run time in s for ray-4-O0"
plot [:] [:] "raytracer-summary.txt" u 1:65 title "ray-4-O0" w lp
set output "raytracer-summary.txt-ray-4-O1-69.png"
set title "Raytraycing run time in s for ray-4-O1"
plot [:] [:] "raytracer-summary.txt" u 1:69 title "ray-4-O1" w lp
set output "raytracer-summary.txt-ray-4-O2-73.png"
set title "Raytraycing run time in s for ray-4-O2"
plot [:] [:] "raytracer-summary.txt" u 1:73 title "ray-4-O2" w lp
set output "raytracer-summary.txt-ray-4-O3-77.png"
set title "Raytraycing run time in s for ray-4-O3"
plot [:] [:] "raytracer-summary.txt" u 1:77 title "ray-4-O3" w lp
set output "raytracer-summary.txt-ray-4-Os-81.png"
set title "Raytraycing run time in s for ray-4-Os"
plot [:] [:] "raytracer-summary.txt" u 1:81 title "ray-4-Os" w lp
set output "raytracer-summary.txt-ray-5-O0-85.png"
set title "Raytraycing run time in s for ray-5-O0"
plot [:] [:] "raytracer-summary.txt" u 1:85 title "ray-5-O0" w lp
set output "raytracer-summary.txt-ray-5-O1-89.png"
set title "Raytraycing run time in s for ray-5-O1"
plot [:] [:] "raytracer-summary.txt" u 1:89 title "ray-5-O1" w lp
set output "raytracer-summary.txt-ray-5-O2-93.png"
set title "Raytraycing run time in s for ray-5-O2"
plot [:] [:] "raytracer-summary.txt" u 1:93 title "ray-5-O2" w lp
set output "raytracer-summary.txt-ray-5-O3-97.png"
set title "Raytraycing run time in s for ray-5-O3"
plot [:] [:] "raytracer-summary.txt" u 1:97 title "ray-5-O3" w lp
set output "raytracer-summary.txt-ray-5-Os-101.png"
set title "Raytraycing run time in s for ray-5-Os"
plot [:] [:] "raytracer-summary.txt" u 1:101 title "ray-5-Os" w lp
set output "raytracer-summary.txt-sphereflake-O0-105.png"
set title "Raytraycing run time in s for sphereflake-O0"
plot [:] [:] "raytracer-summary.txt" u 1:105 title "sphereflake-O0" w lp
set output "raytracer-summary.txt-sphereflake-O1-109.png"
set title "Raytraycing run time in s for sphereflake-O1"
plot [:] [:] "raytracer-summary.txt" u 1:109 title "sphereflake-O1" w lp
set output "raytracer-summary.txt-sphereflake-O2-113.png"
set title "Raytraycing run time in s for sphereflake-O2"
plot [:] [:] "raytracer-summary.txt" u 1:113 title "sphereflake-O2" w lp
set output "raytracer-summary.txt-sphereflake-O3-117.png"
set title "Raytraycing run time in s for sphereflake-O3"
plot [:] [:] "raytracer-summary.txt" u 1:117 title "sphereflake-O3" w lp
set output "raytracer-summary.txt-sphereflake-Os-121.png"
set title "Raytraycing run time in s for sphereflake-Os"
plot [:] [:] "raytracer-summary.txt" u 1:121 title "sphereflake-Os" w lp
set output

