#!/usr/bin/python

import string
import re
import sys

pidre = re.compile("^([0-9]*)")
brkre = re.compile("^[0-9 ]*brk.*= ([0-9a-fx]*)")
# munmap (0x40017000, 118685)
# mmap (NULL, 1174524, 
# mremap (void  *old_address,  size_t old_size , size_t new_size
mmapre = re.compile("^[0-9 ]*[mo][ml][ad][^\(]*\([^,]*, ([0-9a-fx]*)")
munmapre = re.compile("^[0-9 ]*munmap[^\(]*\([^,]*, ([0-9a-fx]*)")
mremapre = re.compile("^[0-9 ]*mremap[^\(]*\([^,]*, ([0-9a-fx]*), ([0-9a-fx]*)")

mmapmax = dict()
mmap = dict()
brkmin = dict()
brkmax = dict()

for line in sys.stdin:
	mo = pidre.search(line)
	pid = int(mo.group(1))
	mmapmax.setdefault(pid, 0)
	mmap.setdefault(pid, 0)
	mo = brkre.search(line)
	if mo:
		brkval = int(mo.group(1), 16)
		brkmin.setdefault(pid, brkval)
		brkmax.setdefault(pid, brkval)
		if brkval < brkmin[pid]:
			brkmin[pid] = brkval
		if brkval > brkmax[pid]:
			brkmax[pid] = brkval
	else:
		mo = mmapre.search(line)
		if mo:
			mmapval = int(mo.group(1))
			mmap[pid] += mmapval
		else:
			mo = munmapre.search(line)
			if mo:
				munmapval = int(mo.group(1))
				mmap[pid] -= munmapval
			else:
				mo = mremapre.search(line)
				if mo:
					mremappval = int(mo.group(1))
					mremapnval = int(mo.group(2))
					mmap[pid] += mremapnval - mremappval
		if mmap[pid] > mmapmax[pid]:
			mmapmax[pid] = mmap[pid]

ovrallmmap = 0
for pid, val in mmapmax.iteritems():
#	print "max mmap usage of pid %u is %u kB" % (pid, val/1024)
	if val > ovrallmmap:
		ovrallmmap = val

ovrallbrk = 0
for pid, val in brkmax.iteritems():
	use = val - brkmin[pid]
#	print "max brk usage of pid %u is %u kB" % (pid, use/1024)
	if use > ovrallbrk:
		ovrallbrk = use

#print "mmapmax: %u kB, brkmin: 0x%x, brkmax: 0x%x" % (mmapmax/1024, brkmin, brkmax)
#print "total: %u kB" % ((mmapmax + (brkmax-brkmin))/1024)

s = "total: %u kB\n" % ((ovrallmmap + ovrallbrk)/1024)
sys.stderr.write(s)
