set terminal png
set size 1.25,1
set key top left Left
set xdata time
set timefmt "%y%m%d"

set output "freefem-compile.png"
set title "Compile time for the ff3d binary in s"
set ylabel "s"
plot [:] [:] "freefem-summary.txt"  u 1:2 title "mainline" w lp, \
	437.62 title "4.1.0" w l
set output "freefem-memory.png"
set title "Compile time memory usage for building ff3d in kB"
set ylabel "kB"
plot [:] [:] "freefem-summary.txt"  u 1:3 title "mainline" w lp, \
	591998 title "4.1.0" w l
set output "freefem-textsize.png"
set title "Text size of the ff3d binary in bytes"
set ylabel "bytes"
plot [:] [:] "freefem-summary.txt"  u 1:4 title "mainline" w lp, \
	3332552 title "4.1.0" w l

