set terminal png
set size 1.25,1
set key top left Left
set xdata time
set timefmt "%y%m%d"


set output "botan-summary-time.png"
set ylabel "s"
set title "botan library build time"
plot [:] [:] \
        "botan-summary.txt" u 1:2 title "mainline" w lp
set output

set output "botan-summary-mem.png"
set ylabel "kB"
set title "botan library build time memory usage"
plot [:] [:] \
        "botan-summary.txt" u 1:3 title "mainline" w lp
set output

set output "botan-summary-size.png"
set ylabel "bytes"
set title "botan benchmark program text size"
plot [:] [:] \
        "botan-summary.txt" u 1:4 title "mainline" w lp
set output

