set terminal png
set size 1.25,1
set key top left Left
set xdata time
set timefmt "%y%m%d"


set output "botan-summary-time.png"
set ylabel "s"
set title "botan library build time"
plot [:] [:] \
        "botan-summary.txt" u 1:2 title "mainline" w lp
set output

set output "botan-summary-mem.png"
set ylabel "kB"
set title "botan library build time memory usage"
plot [:] [:] \
        "botan-summary.txt" u 1:3 title "mainline" w lp
set output

set output "botan-summary-size.png"
set ylabel "bytes"
set title "botan benchmark program text size"
plot [:] [:] \
        "botan-summary.txt" u 1:4 title "mainline" w lp
set output


# ../gen-gp.sh --title "Throughput in MB/s" --ylabel "MB/s" --skip 3 botan-summary.txt tests 1 1
set ylabel "MB/s"

set logscale y
set output "botan-summary.txt-1-0.png"
set title "Throughput in MB/s"
plot [:] [:] "botan-summary.txt"  u 1:5 title "AES-128" w lp, \
	"" u 1:6 title "AES-192" w lp, \
	"" u 1:7 title "AES-256" w lp, \
	"" u 1:8 title "Blowfish" w lp, \
	"" u 1:9 title "CAST-128" w lp, \
	"" u 1:10 title "CAST-256" w lp, \
	"" u 1:11 title "DES" w lp, \
	"" u 1:12 title "DESX" w lp, \
	"" u 1:13 title "TripleDES" w lp, \
	"" u 1:14 title "GOST" w lp, \
	"" u 1:15 title "IDEA" w lp, \
	"" u 1:16 title "KASUMI" w lp, \
	"" u 1:17 title "Lion(MD5,WiderWake4+1)" w lp, \
	"" u 1:18 title "Luby-Rackoff(SHA-1)" w lp, \
	"" u 1:19 title "MARS" w lp, \
	"" u 1:20 title "MISTY1" w lp, \
	"" u 1:21 title "RC2" w lp, \
	"" u 1:22 title "RC5(12)" w lp, \
	"" u 1:23 title "RC5(16)" w lp, \
	"" u 1:24 title "RC6" w lp, \
	"" u 1:25 title "SAFER-SK(10)" w lp, \
	"" u 1:26 title "SEED" w lp, \
	"" u 1:27 title "Serpent" w lp, \
	"" u 1:28 title "Skipjack" w lp, \
	"" u 1:29 title "Square" w lp, \
	"" u 1:30 title "TEA" w lp, \
	"" u 1:31 title "Twofish" w lp, \
	"" u 1:32 title "XTEA" w lp, \
	"" u 1:33 title "AES-128-gCBC-PKCS7" w lp, \
	"" u 1:34 title "AES-128-gCBC-CTS" w lp, \
	"" u 1:35 title "AES-128-gCFB(128)" w lp, \
	"" u 1:36 title "AES-128-gCFB(64)" w lp
set output "botan-summary.txt-1-1.png"
plot [:] [:] "botan-summary.txt"  u 1:37 title "AES-128-gCFB(32)" w lp, \
	"" u 1:38 title "AES-128-gCFB(16)" w lp, \
	"" u 1:39 title "AES-128-gCFB(8)" w lp, \
	"" u 1:40 title "AES-128-gOFB" w lp, \
	"" u 1:41 title "AES-128-gCTR" w lp, \
	"" u 1:42 title "AES-128-gEAX" w lp, \
	"" u 1:43 title "ARC4" w lp, \
	"" u 1:44 title "Turing" w lp, \
	"" u 1:45 title "WiderWake4+1" w lp, \
	"" u 1:46 title "Adler32" w lp, \
	"" u 1:47 title "CRC24" w lp, \
	"" u 1:48 title "CRC32" w lp, \
	"" u 1:49 title "FORK-256" w lp, \
	"" u 1:50 title "HAS-160" w lp, \
	"" u 1:51 title "MD2" w lp, \
	"" u 1:52 title "MD4" w lp, \
	"" u 1:53 title "MD5" w lp, \
	"" u 1:54 title "RIPEMD-128" w lp, \
	"" u 1:55 title "RIPEMD-160" w lp, \
	"" u 1:56 title "SHA-160" w lp, \
	"" u 1:57 title "SHA-256" w lp, \
	"" u 1:58 title "SHA-384" w lp, \
	"" u 1:59 title "SHA-512" w lp, \
	"" u 1:60 title "Tiger" w lp, \
	"" u 1:61 title "Whirlpool" w lp, \
	"" u 1:62 title "CMAC(AES-128)" w lp, \
	"" u 1:63 title "HMAC(SHA-1)" w lp, \
	"" u 1:64 title "X9.19-MAC" w lp, \
	"" u 1:65 title "Randpool" w lp, \
	"" u 1:66 title "X9.31-RNG" w lp
set nologscale

set output "botan-summary.txt-AES-128-5.png"
set title "Throughput in MB/s for AES-128"
plot [:] [:] "botan-summary.txt" u 1:5 title "AES-128" w lp
set output "botan-summary.txt-AES-192-6.png"
set title "Throughput in MB/s for AES-192"
plot [:] [:] "botan-summary.txt" u 1:6 title "AES-192" w lp
set output "botan-summary.txt-AES-256-7.png"
set title "Throughput in MB/s for AES-256"
plot [:] [:] "botan-summary.txt" u 1:7 title "AES-256" w lp
set output "botan-summary.txt-Blowfish-8.png"
set title "Throughput in MB/s for Blowfish"
plot [:] [:] "botan-summary.txt" u 1:8 title "Blowfish" w lp
set output "botan-summary.txt-CAST-128-9.png"
set title "Throughput in MB/s for CAST-128"
plot [:] [:] "botan-summary.txt" u 1:9 title "CAST-128" w lp
set output "botan-summary.txt-CAST-256-10.png"
set title "Throughput in MB/s for CAST-256"
plot [:] [:] "botan-summary.txt" u 1:10 title "CAST-256" w lp
set output "botan-summary.txt-DES-11.png"
set title "Throughput in MB/s for DES"
plot [:] [:] "botan-summary.txt" u 1:11 title "DES" w lp
set output "botan-summary.txt-DESX-12.png"
set title "Throughput in MB/s for DESX"
plot [:] [:] "botan-summary.txt" u 1:12 title "DESX" w lp
set output "botan-summary.txt-TripleDES-13.png"
set title "Throughput in MB/s for TripleDES"
plot [:] [:] "botan-summary.txt" u 1:13 title "TripleDES" w lp
set output "botan-summary.txt-GOST-14.png"
set title "Throughput in MB/s for GOST"
plot [:] [:] "botan-summary.txt" u 1:14 title "GOST" w lp
set output "botan-summary.txt-IDEA-15.png"
set title "Throughput in MB/s for IDEA"
plot [:] [:] "botan-summary.txt" u 1:15 title "IDEA" w lp
set output "botan-summary.txt-KASUMI-16.png"
set title "Throughput in MB/s for KASUMI"
plot [:] [:] "botan-summary.txt" u 1:16 title "KASUMI" w lp
set output "botan-summary.txt-Lion(MD5,WiderWake4+1)-17.png"
set title "Throughput in MB/s for Lion(MD5,WiderWake4+1)"
plot [:] [:] "botan-summary.txt" u 1:17 title "Lion(MD5,WiderWake4+1)" w lp
set output "botan-summary.txt-Luby-Rackoff(SHA-1)-18.png"
set title "Throughput in MB/s for Luby-Rackoff(SHA-1)"
plot [:] [:] "botan-summary.txt" u 1:18 title "Luby-Rackoff(SHA-1)" w lp
set output "botan-summary.txt-MARS-19.png"
set title "Throughput in MB/s for MARS"
plot [:] [:] "botan-summary.txt" u 1:19 title "MARS" w lp
set output "botan-summary.txt-MISTY1-20.png"
set title "Throughput in MB/s for MISTY1"
plot [:] [:] "botan-summary.txt" u 1:20 title "MISTY1" w lp
set output "botan-summary.txt-RC2-21.png"
set title "Throughput in MB/s for RC2"
plot [:] [:] "botan-summary.txt" u 1:21 title "RC2" w lp
set output "botan-summary.txt-RC5(12)-22.png"
set title "Throughput in MB/s for RC5(12)"
plot [:] [:] "botan-summary.txt" u 1:22 title "RC5(12)" w lp
set output "botan-summary.txt-RC5(16)-23.png"
set title "Throughput in MB/s for RC5(16)"
plot [:] [:] "botan-summary.txt" u 1:23 title "RC5(16)" w lp
set output "botan-summary.txt-RC6-24.png"
set title "Throughput in MB/s for RC6"
plot [:] [:] "botan-summary.txt" u 1:24 title "RC6" w lp
set output "botan-summary.txt-SAFER-SK(10)-25.png"
set title "Throughput in MB/s for SAFER-SK(10)"
plot [:] [:] "botan-summary.txt" u 1:25 title "SAFER-SK(10)" w lp
set output "botan-summary.txt-SEED-26.png"
set title "Throughput in MB/s for SEED"
plot [:] [:] "botan-summary.txt" u 1:26 title "SEED" w lp
set output "botan-summary.txt-Serpent-27.png"
set title "Throughput in MB/s for Serpent"
plot [:] [:] "botan-summary.txt" u 1:27 title "Serpent" w lp
set output "botan-summary.txt-Skipjack-28.png"
set title "Throughput in MB/s for Skipjack"
plot [:] [:] "botan-summary.txt" u 1:28 title "Skipjack" w lp
set output "botan-summary.txt-Square-29.png"
set title "Throughput in MB/s for Square"
plot [:] [:] "botan-summary.txt" u 1:29 title "Square" w lp
set output "botan-summary.txt-TEA-30.png"
set title "Throughput in MB/s for TEA"
plot [:] [:] "botan-summary.txt" u 1:30 title "TEA" w lp
set output "botan-summary.txt-Twofish-31.png"
set title "Throughput in MB/s for Twofish"
plot [:] [:] "botan-summary.txt" u 1:31 title "Twofish" w lp
set output "botan-summary.txt-XTEA-32.png"
set title "Throughput in MB/s for XTEA"
plot [:] [:] "botan-summary.txt" u 1:32 title "XTEA" w lp
set output "botan-summary.txt-AES-128-gCBC-PKCS7-33.png"
set title "Throughput in MB/s for AES-128-gCBC-PKCS7"
plot [:] [:] "botan-summary.txt" u 1:33 title "AES-128-gCBC-PKCS7" w lp
set output "botan-summary.txt-AES-128-gCBC-CTS-34.png"
set title "Throughput in MB/s for AES-128-gCBC-CTS"
plot [:] [:] "botan-summary.txt" u 1:34 title "AES-128-gCBC-CTS" w lp
set output "botan-summary.txt-AES-128-gCFB(128)-35.png"
set title "Throughput in MB/s for AES-128-gCFB(128)"
plot [:] [:] "botan-summary.txt" u 1:35 title "AES-128-gCFB(128)" w lp
set output "botan-summary.txt-AES-128-gCFB(64)-36.png"
set title "Throughput in MB/s for AES-128-gCFB(64)"
plot [:] [:] "botan-summary.txt" u 1:36 title "AES-128-gCFB(64)" w lp
set output "botan-summary.txt-AES-128-gCFB(32)-37.png"
set title "Throughput in MB/s for AES-128-gCFB(32)"
plot [:] [:] "botan-summary.txt" u 1:37 title "AES-128-gCFB(32)" w lp
set output "botan-summary.txt-AES-128-gCFB(16)-38.png"
set title "Throughput in MB/s for AES-128-gCFB(16)"
plot [:] [:] "botan-summary.txt" u 1:38 title "AES-128-gCFB(16)" w lp
set output "botan-summary.txt-AES-128-gCFB(8)-39.png"
set title "Throughput in MB/s for AES-128-gCFB(8)"
plot [:] [:] "botan-summary.txt" u 1:39 title "AES-128-gCFB(8)" w lp
set output "botan-summary.txt-AES-128-gOFB-40.png"
set title "Throughput in MB/s for AES-128-gOFB"
plot [:] [:] "botan-summary.txt" u 1:40 title "AES-128-gOFB" w lp
set output "botan-summary.txt-AES-128-gCTR-41.png"
set title "Throughput in MB/s for AES-128-gCTR"
plot [:] [:] "botan-summary.txt" u 1:41 title "AES-128-gCTR" w lp
set output "botan-summary.txt-AES-128-gEAX-42.png"
set title "Throughput in MB/s for AES-128-gEAX"
plot [:] [:] "botan-summary.txt" u 1:42 title "AES-128-gEAX" w lp
set output "botan-summary.txt-ARC4-43.png"
set title "Throughput in MB/s for ARC4"
plot [:] [:] "botan-summary.txt" u 1:43 title "ARC4" w lp
set output "botan-summary.txt-Turing-44.png"
set title "Throughput in MB/s for Turing"
plot [:] [:] "botan-summary.txt" u 1:44 title "Turing" w lp
set output "botan-summary.txt-WiderWake4+1-45.png"
set title "Throughput in MB/s for WiderWake4+1"
plot [:] [:] "botan-summary.txt" u 1:45 title "WiderWake4+1" w lp
set output "botan-summary.txt-Adler32-46.png"
set title "Throughput in MB/s for Adler32"
plot [:] [:] "botan-summary.txt" u 1:46 title "Adler32" w lp
set output "botan-summary.txt-CRC24-47.png"
set title "Throughput in MB/s for CRC24"
plot [:] [:] "botan-summary.txt" u 1:47 title "CRC24" w lp
set output "botan-summary.txt-CRC32-48.png"
set title "Throughput in MB/s for CRC32"
plot [:] [:] "botan-summary.txt" u 1:48 title "CRC32" w lp
set output "botan-summary.txt-FORK-256-49.png"
set title "Throughput in MB/s for FORK-256"
plot [:] [:] "botan-summary.txt" u 1:49 title "FORK-256" w lp
set output "botan-summary.txt-HAS-160-50.png"
set title "Throughput in MB/s for HAS-160"
plot [:] [:] "botan-summary.txt" u 1:50 title "HAS-160" w lp
set output "botan-summary.txt-MD2-51.png"
set title "Throughput in MB/s for MD2"
plot [:] [:] "botan-summary.txt" u 1:51 title "MD2" w lp
set output "botan-summary.txt-MD4-52.png"
set title "Throughput in MB/s for MD4"
plot [:] [:] "botan-summary.txt" u 1:52 title "MD4" w lp
set output "botan-summary.txt-MD5-53.png"
set title "Throughput in MB/s for MD5"
plot [:] [:] "botan-summary.txt" u 1:53 title "MD5" w lp
set output "botan-summary.txt-RIPEMD-128-54.png"
set title "Throughput in MB/s for RIPEMD-128"
plot [:] [:] "botan-summary.txt" u 1:54 title "RIPEMD-128" w lp
set output "botan-summary.txt-RIPEMD-160-55.png"
set title "Throughput in MB/s for RIPEMD-160"
plot [:] [:] "botan-summary.txt" u 1:55 title "RIPEMD-160" w lp
set output "botan-summary.txt-SHA-160-56.png"
set title "Throughput in MB/s for SHA-160"
plot [:] [:] "botan-summary.txt" u 1:56 title "SHA-160" w lp
set output "botan-summary.txt-SHA-256-57.png"
set title "Throughput in MB/s for SHA-256"
plot [:] [:] "botan-summary.txt" u 1:57 title "SHA-256" w lp
set output "botan-summary.txt-SHA-384-58.png"
set title "Throughput in MB/s for SHA-384"
plot [:] [:] "botan-summary.txt" u 1:58 title "SHA-384" w lp
set output "botan-summary.txt-SHA-512-59.png"
set title "Throughput in MB/s for SHA-512"
plot [:] [:] "botan-summary.txt" u 1:59 title "SHA-512" w lp
set output "botan-summary.txt-Tiger-60.png"
set title "Throughput in MB/s for Tiger"
plot [:] [:] "botan-summary.txt" u 1:60 title "Tiger" w lp
set output "botan-summary.txt-Whirlpool-61.png"
set title "Throughput in MB/s for Whirlpool"
plot [:] [:] "botan-summary.txt" u 1:61 title "Whirlpool" w lp
set output "botan-summary.txt-CMAC(AES-128)-62.png"
set title "Throughput in MB/s for CMAC(AES-128)"
plot [:] [:] "botan-summary.txt" u 1:62 title "CMAC(AES-128)" w lp
set output "botan-summary.txt-HMAC(SHA-1)-63.png"
set title "Throughput in MB/s for HMAC(SHA-1)"
plot [:] [:] "botan-summary.txt" u 1:63 title "HMAC(SHA-1)" w lp
set output "botan-summary.txt-X9.19-MAC-64.png"
set title "Throughput in MB/s for X9.19-MAC"
plot [:] [:] "botan-summary.txt" u 1:64 title "X9.19-MAC" w lp
set output "botan-summary.txt-Randpool-65.png"
set title "Throughput in MB/s for Randpool"
plot [:] [:] "botan-summary.txt" u 1:65 title "Randpool" w lp
set output "botan-summary.txt-X9.31-RNG-66.png"
set title "Throughput in MB/s for X9.31-RNG"
plot [:] [:] "botan-summary.txt" u 1:66 title "X9.31-RNG" w lp
set output

