set terminal png
set size 1.25,1
set key top left Left
set xdata time
set timefmt "%y%m%d"

# compile time / memory usage graphs
set output "DLV-compile-time.png"
set ylabel "s"
set title "Compile time for the dl binary in s"
plot [:] [:] "DLV-summary.txt" u 1:2 title "mainline" w lp, \
	     204.99 title "4.1.0" w l
set output

set output "DLV-compile-memory.png"
set ylabel "kB"
set title "Compile time memory usage for the dl binary in kB"
plot [:] [:] "DLV-summary.txt" u 1:3 title "mainline" w lp, \
	     373522 title "4.1.0" w l
set output

set output "DLV-size.png"
set ylabel "bytes"
set title "Text size of the dl binary in bytes"
plot [:] [:] "DLV-summary.txt" u 1:3 title "mainline" w lp
set output

