set terminal png
set size 1.25,1
set key top left Left
set xdata time
set timefmt "%y%m%d"

# compile time / memory usage graphs
set output "DLV-compile-time.png"
set ylabel "s"
set title "Compile time for the dl binary in s"
plot [:] [:] "DLV-summary.txt" u 1:2 title "mainline" w lp, \
	     204.99 title "4.1.0" w l
set output

set output "DLV-compile-memory.png"
set ylabel "kB"
set title "Compile time memory usage for the dl binary in kB"
plot [:] [:] "DLV-summary.txt" u 1:3 title "mainline" w lp, \
	     373522 title "4.1.0" w l
set output

set output "DLV-size.png"
set ylabel "bytes"
set title "Text size of the dl binary in bytes"
plot [:] [:] "DLV-summary.txt" u 1:4 title "mainline" w lp
set output


# ../gen-gp.sh --skip 3 --ylabel "s" --title "Runtime in s" DLV-summary.txt tests 1 1
set ylabel "s"

set logscale y
set output "DLV-summary.txt-1-0.png"
set title "Runtime in s"
plot [:] [:] "DLV-summary.txt"  u 1:5 title "STRATCOMP1-ALL" w lp, \
	"" u 1:6 title "STRATCOMP-770.2-Q" w lp, \
	"" u 1:7 title "2QBF1" w lp, \
	"" u 1:8 title "PRIMEIMPL2" w lp, \
	"" u 1:9 title "ANCESTOR" w lp, \
	"" u 1:10 title "3COL-SIMPLEX1" w lp, \
	"" u 1:11 title "3COL-LADDER" w lp, \
	"" u 1:12 title "3COL-N-LADDER" w lp, \
	"" u 1:13 title "3COL-RANDOM1" w lp, \
	"" u 1:14 title "HP-RANDOM1" w lp, \
	"" u 1:15 title "HAMCYCLE-FREE" w lp, \
	"" u 1:16 title "DECOMP2" w lp, \
	"" u 1:17 title "BW-P4-Esra-a" w lp, \
	"" u 1:18 title "BW-P5-nopush" w lp, \
	"" u 1:19 title "BW-P5-pushbin" w lp, \
	"" u 1:20 title "BW-P5-nopushbin" w lp, \
	"" u 1:21 title "3SAT-1" w lp, \
	"" u 1:22 title "3SAT-1-CONSTRAINT" w lp, \
	"" u 1:23 title "HANOI-Towers" w lp, \
	"" u 1:24 title "RAMSEY" w lp, \
	"" u 1:25 title "CRISTAL" w lp, \
	"" u 1:26 title "HANOI-K" w lp, \
	"" u 1:27 title "21-QUEENS" w lp, \
	"" u 1:28 title "MSTDir[V=13,A=40]" w lp, \
	"" u 1:29 title "MSTDir[V=15,A=40]" w lp, \
	"" u 1:30 title "MSTUndir[V=13,A=40]" w lp, \
	"" u 1:31 title "MSTUndir[V=15,A=40]" w lp, \
	"" u 1:32 title "TIMETABLING" w lp
set nologscale

set output "DLV-summary.txt-STRATCOMP1-ALL-5.png"
set title "Runtime in s for STRATCOMP1-ALL"
plot [:] [:] "DLV-summary.txt" u 1:5 title "STRATCOMP1-ALL" w lp
set output "DLV-summary.txt-STRATCOMP-770.2-Q-6.png"
set title "Runtime in s for STRATCOMP-770.2-Q"
plot [:] [:] "DLV-summary.txt" u 1:6 title "STRATCOMP-770.2-Q" w lp
set output "DLV-summary.txt-2QBF1-7.png"
set title "Runtime in s for 2QBF1"
plot [:] [:] "DLV-summary.txt" u 1:7 title "2QBF1" w lp
set output "DLV-summary.txt-PRIMEIMPL2-8.png"
set title "Runtime in s for PRIMEIMPL2"
plot [:] [:] "DLV-summary.txt" u 1:8 title "PRIMEIMPL2" w lp
set output "DLV-summary.txt-ANCESTOR-9.png"
set title "Runtime in s for ANCESTOR"
plot [:] [:] "DLV-summary.txt" u 1:9 title "ANCESTOR" w lp
set output "DLV-summary.txt-3COL-SIMPLEX1-10.png"
set title "Runtime in s for 3COL-SIMPLEX1"
plot [:] [:] "DLV-summary.txt" u 1:10 title "3COL-SIMPLEX1" w lp
set output "DLV-summary.txt-3COL-LADDER-11.png"
set title "Runtime in s for 3COL-LADDER"
plot [:] [:] "DLV-summary.txt" u 1:11 title "3COL-LADDER" w lp
set output "DLV-summary.txt-3COL-N-LADDER-12.png"
set title "Runtime in s for 3COL-N-LADDER"
plot [:] [:] "DLV-summary.txt" u 1:12 title "3COL-N-LADDER" w lp
set output "DLV-summary.txt-3COL-RANDOM1-13.png"
set title "Runtime in s for 3COL-RANDOM1"
plot [:] [:] "DLV-summary.txt" u 1:13 title "3COL-RANDOM1" w lp
set output "DLV-summary.txt-HP-RANDOM1-14.png"
set title "Runtime in s for HP-RANDOM1"
plot [:] [:] "DLV-summary.txt" u 1:14 title "HP-RANDOM1" w lp
set output "DLV-summary.txt-HAMCYCLE-FREE-15.png"
set title "Runtime in s for HAMCYCLE-FREE"
plot [:] [:] "DLV-summary.txt" u 1:15 title "HAMCYCLE-FREE" w lp
set output "DLV-summary.txt-DECOMP2-16.png"
set title "Runtime in s for DECOMP2"
plot [:] [:] "DLV-summary.txt" u 1:16 title "DECOMP2" w lp
set output "DLV-summary.txt-BW-P4-Esra-a-17.png"
set title "Runtime in s for BW-P4-Esra-a"
plot [:] [:] "DLV-summary.txt" u 1:17 title "BW-P4-Esra-a" w lp
set output "DLV-summary.txt-BW-P5-nopush-18.png"
set title "Runtime in s for BW-P5-nopush"
plot [:] [:] "DLV-summary.txt" u 1:18 title "BW-P5-nopush" w lp
set output "DLV-summary.txt-BW-P5-pushbin-19.png"
set title "Runtime in s for BW-P5-pushbin"
plot [:] [:] "DLV-summary.txt" u 1:19 title "BW-P5-pushbin" w lp
set output "DLV-summary.txt-BW-P5-nopushbin-20.png"
set title "Runtime in s for BW-P5-nopushbin"
plot [:] [:] "DLV-summary.txt" u 1:20 title "BW-P5-nopushbin" w lp
set output "DLV-summary.txt-3SAT-1-21.png"
set title "Runtime in s for 3SAT-1"
plot [:] [:] "DLV-summary.txt" u 1:21 title "3SAT-1" w lp
set output "DLV-summary.txt-3SAT-1-CONSTRAINT-22.png"
set title "Runtime in s for 3SAT-1-CONSTRAINT"
plot [:] [:] "DLV-summary.txt" u 1:22 title "3SAT-1-CONSTRAINT" w lp
set output "DLV-summary.txt-HANOI-Towers-23.png"
set title "Runtime in s for HANOI-Towers"
plot [:] [:] "DLV-summary.txt" u 1:23 title "HANOI-Towers" w lp
set output "DLV-summary.txt-RAMSEY-24.png"
set title "Runtime in s for RAMSEY"
plot [:] [:] "DLV-summary.txt" u 1:24 title "RAMSEY" w lp
set output "DLV-summary.txt-CRISTAL-25.png"
set title "Runtime in s for CRISTAL"
plot [:] [:] "DLV-summary.txt" u 1:25 title "CRISTAL" w lp
set output "DLV-summary.txt-HANOI-K-26.png"
set title "Runtime in s for HANOI-K"
plot [:] [:] "DLV-summary.txt" u 1:26 title "HANOI-K" w lp
set output "DLV-summary.txt-21-QUEENS-27.png"
set title "Runtime in s for 21-QUEENS"
plot [:] [:] "DLV-summary.txt" u 1:27 title "21-QUEENS" w lp
set output "DLV-summary.txt-MSTDir[V=13,A=40]-28.png"
set title "Runtime in s for MSTDir[V=13,A=40]"
plot [:] [:] "DLV-summary.txt" u 1:28 title "MSTDir[V=13,A=40]" w lp
set output "DLV-summary.txt-MSTDir[V=15,A=40]-29.png"
set title "Runtime in s for MSTDir[V=15,A=40]"
plot [:] [:] "DLV-summary.txt" u 1:29 title "MSTDir[V=15,A=40]" w lp
set output "DLV-summary.txt-MSTUndir[V=13,A=40]-30.png"
set title "Runtime in s for MSTUndir[V=13,A=40]"
plot [:] [:] "DLV-summary.txt" u 1:30 title "MSTUndir[V=13,A=40]" w lp
set output "DLV-summary.txt-MSTUndir[V=15,A=40]-31.png"
set title "Runtime in s for MSTUndir[V=15,A=40]"
plot [:] [:] "DLV-summary.txt" u 1:31 title "MSTUndir[V=15,A=40]" w lp
set output "DLV-summary.txt-TIMETABLING-32.png"
set title "Runtime in s for TIMETABLING"
plot [:] [:] "DLV-summary.txt" u 1:32 title "TIMETABLING" w lp
set output

