/*
 * Photo Image Print System
 * Copyright (C) 2000-2005 EPSON AVASYS Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2000-2005.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON AVASYS Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON AVASYS Public License and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON AVASYS Public License.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif


#ifndef __RSC_CTL_H__
#define __RSC_CTL_H__

typedef struct _MODEL_CONFIG
            { short idSize;
              short idType;
              short idLevel;  
              short idT4; 
            } MODEL_CONFIG;


typedef struct _MODEL_CONFIG_LIST
            { MODEL_CONFIG dataitem;
              struct  MODEL_CONFIG_LIST *link;
            } MODEL_CONFIG_LIST;

typedef char Str100[100];

typedef enum {
	FUCHI_NASI,
	FUCHI_ARI,
	FUCHI_NUM
} FUCHI;

typedef enum {
	QLT_DRAFT,
	QLT_NORMAL,
	QLT_HIGH,
	QLT_NUM
} QUALITY;
typedef enum {
	LPR_NULL,
	LPR_COMMENT,
	LPR_PRINTER_ID,
	LPR_PAPERINFO_ENTRY,
	LPR_PRTOPT_ENTRY,
	LPR_OTHER
} LINE_PARSING_RSLT;

typedef enum {
	PAPER_CODE,
	PAPER_ID,
	PAPER_SIZE_WIDTH,
	PAPER_SIZE_HEIGHT,
	PAPER_MARGIN_LEFT,
	PAPER_MARGIN_TOP,	
	PAPER_MARGIN_RIGHT,
	PAPER_MARGIN_BOTTOM,
	PAPER_FIELD_NUM
} PAPER_FIELDS;

typedef enum {
	PRTOPT_MEDIA_SIZE,
	PRTOPT_MEDIA_TYPE,
	PRTOPT_QUALITY,
	PRTOPT_FUCHINASI,
	PRTOPT_FIELD_NUM
} PRTOPT_FIELDS;
#define MAX_NUM_PARSE 8
#define MAX_LINE_LEN 128
#define MAX_FIELD_LEN 30
#define NUM_FIELD_PRTOPT 4
#define NUM_FIELD_PAPER_LIST 8

 

#endif /* __RSC_CTL_H__ */
