/*
 * Photo Image Print System
 * Copyright (C) 2002-2005 EPSON AVASYS Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2002-2005.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON AVASYS Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON AVASYS Public License and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON AVASYS Public License.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ltdl.h>

#include "libprtX.h" 
#include "getstat.h"

int
get_status (char *buf)
{
	char status_command[]  = { 's', 't', 0x01, 0x00, 0x01 };
	int nwrite, nread;

	buf[0] = '\0';

	nwrite = sizeof (status_command);
	nread = 0;
	if (sock_write (status_command, &nwrite) < 0)
	{
		sock_reopen ();
		nwrite = sizeof (status_command);
		sock_write (status_command, &nwrite);
	}
	
	if (nwrite > 0)
	{
		nread = REPLAY_SIZE;
		sock_read (buf, &nread);
		buf[nread] = '\0';
	}

	if (buf[0]) /* no error */
		return 0;
	/* error */
	return 1;
}


#define OFFSET_SEVENTH_INK_CARTRIDGE 34
/*
	Extract a substring between start_tag and end_tag from a string
*/
char* str_extract(const char* src, const char* start_tag, const char* end_tag, char* result)
{
	char	*p_start = NULL, *p_end = NULL;
	int	len = 0;
	
	result[0] = '\0';
	
	p_start = strstr(src, start_tag);
	if (p_start)
	{			
		p_start += strlen(start_tag);
		p_end = strstr(p_start, end_tag);
		if (p_end)
		{
			len = (int)p_end - (int)p_start;
			memcpy(result, p_start, len);
			result[len] = '\0';
		}
	}
	return result;
}

int get_printer_id(char* model)
{
	char di_command[]  = { 'd', 'i', 0x01, 0x00, 0x01 };
	char buf[REPLAY_SIZE];
	int nwrite, nread;
	char cmd[REPLAY_SIZE];

	buf[0] = '\0';

	nwrite = sizeof (di_command);
	nread = 0;
	if (sock_write (di_command, &nwrite) < 0)
	{
		sock_reopen ();
		nwrite = sizeof (di_command);
		sock_write (di_command, &nwrite);
	}
	
	if (nwrite > 0)
	{
		nread = REPLAY_SIZE;
		sock_read (buf, &nread);
		buf[nread] = '\0';
	}

	if (buf[0]) /* no error */
	{
		/*  parse the reply message */
		if (strstr(str_extract(buf, "CMD:", ";", cmd), "ESCPR"))
			str_extract(buf, "MDL:", ";", model);
		else
			/* error, not an ESCPR printer*/
			return 1;
		return 0;
	}
	
	/* error */
	return 1;
}

int get_printer_peculiar(char *buf, int* size)
{
	char pm_command[]  = { 'p', 'm', 0x01, 0x00, 0x01 };
	int nwrite;
 	FILTER_PMPEPLY_FUNC dl_pmfilter; 
	lt_dlhandle lib_h;
	char *libfile = LIBPATH;
	int err = 0;

	buf[0] = '\0';

	err = lt_dlinit();

	if (err) {
		fprintf (stderr, lt_dlerror ());
		exit(1);
	}
	lib_h = lt_dlopenext (libfile);
	if (lib_h == NULL){
		fprintf (stderr, lt_dlerror ());
		exit(1);
	}
	
	dl_pmfilter  = (FILTER_PMPEPLY_FUNC) lt_dlsym (lib_h, DLL_FILTER_PMREPLY);
	if (! dl_pmfilter)
	{
		fprintf (stderr, "The symbols to function was not found.");
		exit(1);
	}

	nwrite = sizeof (pm_command);
	*size = 0;
	if (sock_write (pm_command, &nwrite) < 0)
	{
		sock_reopen ();
		nwrite = sizeof (pm_command);
		sock_write (pm_command, &nwrite);
	}
	
	if (nwrite > 0)
	{
		*size = REPLAY_SIZE;
		sock_read (buf, size);

		/* fix the received string using service pack function */
		if(dl_pmfilter((ESCPR_UBYTE1*)buf)){
			fprintf (stderr, "escprFilterReply() failed");
		}

		buf[*size] = '\0';
	}

	if (buf[0]) /* no error */
		return 0;
	/* error */
	return 1;
}
