/*
 * Copyright 2014 Netflix, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.netflix.config.scala

import org.junit.runner.RunWith
import org.scalatest.junit.JUnitRunner
import org.scalatest.matchers.ShouldMatchers
import scala.concurrent.duration._

@RunWith(classOf[JUnitRunner])
class ChainedPropertyTest extends PropertiesTestHelp with ShouldMatchers with ChainedPropertyBehaviors[Duration] {

  val defaultUnmappedValue = -1L
  val defaultMappedValue = defaultUnmappedValue.millis

  def fixture(pre: Option[String], mid: String, post: Option[String]) = {
    new ChainedLongProperty(pre, mid, post, defaultUnmappedValue).map( v => v.millis )
  }

  "ChainedProperty.map to another type" should {
    behave like chainedPropertyWithOnePart(defaultUnmappedValue, 1L, defaultMappedValue, 1L.milli)
    behave like chainedPropertyWithTwoParts(defaultUnmappedValue, 1L, defaultMappedValue, 1L.milli)
    behave like chainedPropertyWithManyParts(defaultUnmappedValue, 0L, 1L, 2L, defaultMappedValue, 0L.millis, 1L.milli, 2L.millis)
  }
}
