/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import jdk.internal.loader.ClassLoaderValue;

public class Level
implements Serializable {
    private static final String defaultBundle = "sun.util.logging.resources.logging";
    private final String name;
    private final int value;
    private final String resourceBundleName;
    private transient String localizedLevelName;
    private transient Locale cachedLocale;
    public static final Level OFF;
    public static final Level SEVERE;
    public static final Level WARNING;
    public static final Level INFO;
    public static final Level CONFIG;
    public static final Level FINE;
    public static final Level FINER;
    public static final Level FINEST;
    public static final Level ALL;
    private static final long serialVersionUID = -8176160795706313070L;

    protected Level(String string, int n) {
    }

    protected Level(String string, int n, String string2) {
    }

    public String getResourceBundleName() {
        return null;
    }

    public String getName() {
        return null;
    }

    public String getLocalizedName() {
        return null;
    }

    public final String toString() {
        return null;
    }

    public final int intValue() {
        return 0;
    }

    public static synchronized Level parse(String string) throws IllegalArgumentException {
        return null;
    }

    public boolean equals(Object object) {
        return false;
    }

    public int hashCode() {
        return 0;
    }

    static final class KnownLevel
    extends WeakReference<Level> {
        private static Map<String, List<KnownLevel>> nameToLevels = new HashMap<String, List<KnownLevel>>();
        private static Map<Integer, List<KnownLevel>> intToLevels = new HashMap<Integer, List<KnownLevel>>();
        private static final ReferenceQueue<Level> QUEUE = new ReferenceQueue();
        private static final ClassLoaderValue<List<Level>> CUSTOM_LEVEL_CLV = new ClassLoaderValue();
        final Level mirroredLevel;

        KnownLevel(Level l) {
            super(l, QUEUE);
            this.mirroredLevel = l.getClass() == Level.class ? l : new Level(l.name, l.value, l.resourceBundleName, false);
        }

        Optional<Level> mirrored() {
            return Optional.of(this.mirroredLevel);
        }

        Optional<Level> referent() {
            return Optional.ofNullable((Level)this.get());
        }

        private void remove() {
            Optional.ofNullable(nameToLevels.get(this.mirroredLevel.name)).ifPresent(x -> x.remove(this));
            Optional.ofNullable(intToLevels.get(this.mirroredLevel.value)).ifPresent(x -> x.remove(this));
        }

        static synchronized void purge() {
            Reference<Level> ref;
            while ((ref = QUEUE.poll()) != null) {
                if (!(ref instanceof KnownLevel)) continue;
                ((KnownLevel)ref).remove();
            }
        }

        private static void registerWithClassLoader(Level customLevel) {
            PrivilegedAction<ClassLoader> pa = customLevel.getClass()::getClassLoader;
            ClassLoader cl = AccessController.doPrivileged(pa);
            CUSTOM_LEVEL_CLV.computeIfAbsent(cl, (c, v) -> new ArrayList()).add(customLevel);
        }

        static synchronized void add(Level l) {
            KnownLevel.purge();
            KnownLevel o = new KnownLevel(l);
            nameToLevels.computeIfAbsent(l.name, k -> new ArrayList()).add(o);
            intToLevels.computeIfAbsent(l.value, k -> new ArrayList()).add(o);
            if (o.mirroredLevel != l) {
                KnownLevel.registerWithClassLoader(l);
            }
        }

        static synchronized Optional<Level> findByName(String name, Function<KnownLevel, Optional<Level>> selector) {
            KnownLevel.purge();
            return nameToLevels.getOrDefault(name, Collections.emptyList()).stream().map(selector).flatMap((Function<Optional, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, stream(), (Ljava/util/Optional;)Ljava/util/stream/Stream;)()).findFirst();
        }

        static synchronized Optional<Level> findByValue(int value, Function<KnownLevel, Optional<Level>> selector) {
            KnownLevel.purge();
            return intToLevels.getOrDefault(value, Collections.emptyList()).stream().map(selector).flatMap((Function<Optional, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, stream(), (Ljava/util/Optional;)Ljava/util/stream/Stream;)()).findFirst();
        }

        static synchronized Optional<Level> findByLocalizedLevelName(String name, Function<KnownLevel, Optional<Level>> selector) {
            KnownLevel.purge();
            return nameToLevels.values().stream().flatMap(Collection::stream).map(selector).flatMap((Function<Optional, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, stream(), (Ljava/util/Optional;)Ljava/util/stream/Stream;)()).filter(l -> name.equals(l.getLocalizedLevelName())).findFirst();
        }

        static synchronized Optional<Level> matches(Level l) {
            KnownLevel.purge();
            List<KnownLevel> list = nameToLevels.get(l.name);
            if (list != null) {
                for (KnownLevel ref : list) {
                    Level levelObject = (Level)ref.get();
                    if (levelObject == null) continue;
                    Level other = ref.mirroredLevel;
                    Class<?> type = levelObject.getClass();
                    if (l.value != other.value || l.resourceBundleName != other.resourceBundleName && (l.resourceBundleName == null || !l.resourceBundleName.equals(other.resourceBundleName)) || type != l.getClass()) continue;
                    return Optional.of(levelObject);
                }
            }
            return Optional.empty();
        }
    }
}

