/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import sun.nio.fs.DefaultFileSystemProvider;

public final class FileSystems {
    public static FileSystem getDefault() {
        return null;
    }

    public static FileSystem getFileSystem(URI uRI) {
        return null;
    }

    public static FileSystem newFileSystem(URI uRI, Map<String, ?> map) throws IOException {
        return null;
    }

    public static FileSystem newFileSystem(URI uRI, Map<String, ?> map, ClassLoader classLoader) throws IOException {
        return null;
    }

    public static FileSystem newFileSystem(Path path, ClassLoader classLoader) throws IOException {
        return null;
    }

    private static class DefaultFileSystemHolder {
        static final FileSystem defaultFileSystem = DefaultFileSystemHolder.defaultFileSystem();

        private DefaultFileSystemHolder() {
        }

        private static FileSystem defaultFileSystem() {
            FileSystemProvider provider = AccessController.doPrivileged(new PrivilegedAction<FileSystemProvider>(){

                @Override
                public FileSystemProvider run() {
                    return DefaultFileSystemHolder.getDefaultProvider();
                }
            });
            return provider.getFileSystem(URI.create("file:///"));
        }

        private static FileSystemProvider getDefaultProvider() {
            FileSystemProvider provider = DefaultFileSystemProvider.instance();
            String prop = "java.nio.file.spi.DefaultFileSystemProvider";
            String propValue = System.getProperty(prop);
            if (propValue != null) {
                for (String cn : propValue.split(",")) {
                    try {
                        Class<?> c = Class.forName(cn, true, ClassLoader.getSystemClassLoader());
                        Constructor<?> ctor = c.getDeclaredConstructor(FileSystemProvider.class);
                        provider = (FileSystemProvider)ctor.newInstance(provider);
                        if (provider.getScheme().equals("file")) continue;
                        throw new Error("Default provider must use scheme 'file'");
                    }
                    catch (Exception x) {
                        throw new Error(x);
                    }
                }
            }
            return provider;
        }
    }
}

